/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.processors.search;

import ambit2.base.data.Property;
import ambit2.base.data.Template;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.exceptions.HttpException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.base.processors.DefaultAmbitProcessor;
import java.util.Iterator;

public abstract class AbstractFinder<REQUEST, RESULT>
extends DefaultAmbitProcessor<IStructureRecord, IStructureRecord> {
    private static final long serialVersionUID = 2897055153094159861L;
    protected REQUEST request;
    protected Template profile;
    protected MODE mode;

    public AbstractFinder(Template template, REQUEST REQUEST, MODE mODE) {
        this.profile = template;
        this.request = REQUEST;
        this.mode = mODE;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setMode(MODE mODE) {
        this.mode = mODE;
    }

    protected abstract RESULT query(String var1) throws AmbitException;

    protected IStructureRecord transformResult(IStructureRecord iStructureRecord, IStructureRecord iStructureRecord2) throws AmbitException {
        iStructureRecord.setContent(iStructureRecord2.getContent());
        iStructureRecord.setFormat(iStructureRecord2.getFormat());
        for (Property property : iStructureRecord2.getProperties()) {
            iStructureRecord.setProperty(property, iStructureRecord2.getProperty(property));
        }
        return iStructureRecord;
    }

    protected IStructureRecord transformResult(IStructureRecord iStructureRecord, String string) throws AmbitException {
        iStructureRecord.setContent(string);
        iStructureRecord.setFormat(IStructureRecord.MOL_TYPE.SDF.toString());
        return iStructureRecord;
    }

    protected IStructureRecord transform(IStructureRecord iStructureRecord, RESULT RESULT) throws AmbitException {
        if (RESULT instanceof IStructureRecord) {
            return this.transformResult(iStructureRecord, (IStructureRecord)RESULT);
        }
        return this.transformResult(iStructureRecord, RESULT.toString());
    }

    @Override
    public IStructureRecord process(IStructureRecord iStructureRecord) throws AmbitException {
        try {
            if (iStructureRecord == null) {
                return null;
            }
            if ((MODE.emptyonly.equals((Object)this.mode) || MODE.emptyadd.equals((Object)this.mode)) && !IStructureRecord.STRUC_TYPE.NA.equals((Object)iStructureRecord.getType())) {
                return null;
            }
            Iterator iterator = this.profile.getProperties(true);
            Object object = null;
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                try {
                    RESULT RESULT;
                    object = iStructureRecord.getProperty(property);
                    if (object == null || "".equals(object.toString().trim()) || (RESULT = this.query(object.toString())) == null) continue;
                    IStructureRecord.STRUC_TYPE sTRUC_TYPE = iStructureRecord.getType();
                    iStructureRecord = this.transform(iStructureRecord, RESULT);
                    switch (this.mode) {
                        case emptyonly: {
                            if (IStructureRecord.STRUC_TYPE.NA.equals((Object)sTRUC_TYPE)) break;
                            iStructureRecord.setIdstructure(-1);
                            break;
                        }
                        case emptyadd: {
                            iStructureRecord.setIdstructure(-1);
                            iStructureRecord.setUsePreferedStructure(false);
                            break;
                        }
                        case replace: {
                            iStructureRecord.setUsePreferedStructure(false);
                            break;
                        }
                        default: {
                            iStructureRecord.setIdstructure(-1);
                            iStructureRecord.setUsePreferedStructure(false);
                        }
                    }
                    return iStructureRecord;
                }
                catch (HttpException httpException) {
                    if (httpException.getCode() != 404) continue;
                    System.out.println(object + httpException.getMessage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static enum SITE {
        CIR{

            @Override
            public String getTitle() {
                return "Chemical Identifier Resolver";
            }

            @Override
            public String getURI() {
                return "http://cactus.nci.nih.gov/chemical/structure";
            }
        }
        ,
        CHEMIDPLUS{

            @Override
            public String getTitle() {
                return "ChemIDplus";
            }

            @Override
            public String getURI() {
                return "http://chem.sis.nlm.nih.gov/chemidplus";
            }
        }
        ,
        PUBCHEM{

            @Override
            public String getTitle() {
                return "PubChem";
            }

            @Override
            public String getURI() {
                return "http://www.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=pccompound&maxret=1&term=";
            }
        }
        ,
        NAME2STRUCTURE{

            @Override
            public String getTitle() {
                return "Chemical Name to Structure converter (OPSIN) ";
            }

            @Override
            public String getURI() {
                return "http://www-ucc.ch.cam.ac.uk/products/software/opsin";
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        }
        ,
        CHEBI{

            @Override
            public String getTitle() {
                return "Chemical Entities of Biological Interest (ChEBI)";
            }

            @Override
            public String getURI() {
                return "http://www.ebi.ac.uk/chebi";
            }

            @Override
            public boolean isEnabled() {
                return false;
            }
        }
        ,
        CHEMBL{

            @Override
            public String getTitle() {
                return "ChEMBL Web Services";
            }

            @Override
            public String getURI() {
                return "https://www.ebi.ac.uk/chembldb/index.php/ws/";
            }
        }
        ,
        OPENTOX{

            @Override
            public String getTitle() {
                return "OpenTox";
            }

            @Override
            public String getURI() {
                return "http://apps.ideaconsult.net:8080/ambit2";
            }

            @Override
            public boolean isEnabled() {
                return true;
            }
        };


        public String getTitle() {
            return this.toString();
        }

        public String getURI() {
            return this.toString();
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public static enum MODE {
        emptyonly{

            @Override
            public String getDescription() {
                return "Lookup only empty structures and replace the current structure representation";
            }
        }
        ,
        replace{

            @Override
            public String getDescription() {
                return "Lookup all structures and replace the current structure representation";
            }
        }
        ,
        add{

            @Override
            public String getDescription() {
                return "Lookup all structures and add the result as additional structure representation";
            }
        }
        ,
        emptyadd{

            @Override
            public String getDescription() {
                return "Lookup only empty structures and add the result as additional structure representation";
            }
        };


        public String getDescription() {
            return this.toString();
        }
    }
}

