/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.event.ConnectedComponentTraversalEvent;
import org._3pq.jgrapht.event.GraphEdgeChangeEvent;
import org._3pq.jgrapht.event.GraphListener;
import org._3pq.jgrapht.event.GraphVertexChangeEvent;
import org._3pq.jgrapht.event.TraversalListenerAdapter;
import org._3pq.jgrapht.event.VertexTraversalEvent;
import org._3pq.jgrapht.graph.AsUndirectedGraph;
import org._3pq.jgrapht.traverse.BreadthFirstIterator;

public class ConnectivityInspector
implements GraphListener {
    List m_connectedSets;
    Map m_vertexToConnectedSet;
    private Graph m_graph;

    public ConnectivityInspector(UndirectedGraph undirectedGraph) {
        this.init();
        this.m_graph = undirectedGraph;
    }

    public ConnectivityInspector(DirectedGraph directedGraph) {
        this.init();
        this.m_graph = new AsUndirectedGraph(directedGraph);
    }

    public boolean isGraphConnected() {
        return this.lazyFindConnectedSets().size() == 1;
    }

    public Set connectedSetOf(Object object) {
        HashSet<Object> hashSet = (HashSet<Object>)this.m_vertexToConnectedSet.get(object);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this.m_graph, object);
            while (breadthFirstIterator.hasNext()) {
                hashSet.add(breadthFirstIterator.next());
            }
            this.m_vertexToConnectedSet.put(object, hashSet);
        }
        return hashSet;
    }

    public List connectedSets() {
        return this.lazyFindConnectedSets();
    }

    public void edgeAdded(GraphEdgeChangeEvent graphEdgeChangeEvent) {
        this.init();
    }

    public void edgeRemoved(GraphEdgeChangeEvent graphEdgeChangeEvent) {
        this.init();
    }

    public boolean pathExists(Object object, Object object2) {
        Set set = this.connectedSetOf(object);
        return set.contains(object2);
    }

    public void vertexAdded(GraphVertexChangeEvent graphVertexChangeEvent) {
        this.init();
    }

    public void vertexRemoved(GraphVertexChangeEvent graphVertexChangeEvent) {
        this.init();
    }

    private void init() {
        this.m_connectedSets = null;
        this.m_vertexToConnectedSet = new HashMap();
    }

    private List lazyFindConnectedSets() {
        if (this.m_connectedSets == null) {
            this.m_connectedSets = new ArrayList();
            Set set = this.m_graph.vertexSet();
            if (set.size() > 0) {
                BreadthFirstIterator breadthFirstIterator = new BreadthFirstIterator(this.m_graph, null);
                breadthFirstIterator.addTraversalListener(new MyTraversalListener());
                while (breadthFirstIterator.hasNext()) {
                    breadthFirstIterator.next();
                }
            }
        }
        return this.m_connectedSets;
    }

    private class MyTraversalListener
    extends TraversalListenerAdapter {
        private Set m_currentConnectedSet;

        private MyTraversalListener() {
        }

        public void connectedComponentFinished(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
            ConnectivityInspector.this.m_connectedSets.add(this.m_currentConnectedSet);
        }

        public void connectedComponentStarted(ConnectedComponentTraversalEvent connectedComponentTraversalEvent) {
            this.m_currentConnectedSet = new HashSet();
        }

        public void vertexTraversed(VertexTraversalEvent vertexTraversalEvent) {
            Object object = vertexTraversalEvent.getVertex();
            this.m_currentConnectedSet.add(object);
            ConnectivityInspector.this.m_vertexToConnectedSet.put(object, this.m_currentConnectedSet);
        }
    }
}

