/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.LinkedHashMap;
import java.util.Map;
import libpadeldescriptor.ElectrotopologicalStateDescriptor;
import libpadeldescriptor.HydrogenEStateDescriptor;
import libpadeldescriptor.IntrinsicStateDescriptor;
import org.openscience.cdk.atomtype.EStateAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.DoubleResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class EStateAtomTypeDescriptor
implements IMolecularDescriptor {
    private static final String sumI = "sumI";
    private static final String hmax = "hmax";
    private static final String gmax = "gmax";
    private static final String hmin = "hmin";
    private static final String gmin = "gmin";
    private static final String LipoaffinityIndex = "LipoaffinityIndex";
    private static final String MAXDN = "MAXDN";
    private static final String MAXDP = "MAXDP";
    private static final String DELS = "DELS";
    private static final String MAXDN2 = "MAXDN2";
    private static final String MAXDP2 = "MAXDP2";
    private static final String DELS2 = "DELS2";
    private static final String SHBd = "SHBd";
    private static final String SwHBd = "SwHBd";
    private static final String SHBa = "SHBa";
    private static final String SwHBa = "SwHBa";
    private static final String SHBint2 = "SHBint2";
    private static final String SHBint3 = "SHBint3";
    private static final String SHBint4 = "SHBint4";
    private static final String SHBint5 = "SHBint5";
    private static final String SHBint6 = "SHBint6";
    private static final String SHBint7 = "SHBint7";
    private static final String SHBint8 = "SHBint8";
    private static final String SHBint9 = "SHBint9";
    private static final String SHBint10 = "SHBint10";
    private static final String SHsOH = "SHsOH";
    private static final String SHdNH = "SHdNH";
    private static final String SHsSH = "SHsSH";
    private static final String SHsNH2 = "SHsNH2";
    private static final String SHssNH = "SHssNH";
    private static final String SHaaNH = "SHaaNH";
    private static final String SHsNH3p = "SHsNH3p";
    private static final String SHssNH2p = "SHssNH2p";
    private static final String SHsssNHp = "SHsssNHp";
    private static final String SHtCH = "SHtCH";
    private static final String SHdCH2 = "SHdCH2";
    private static final String SHdsCH = "SHdsCH";
    private static final String SHaaCH = "SHaaCH";
    private static final String SHCHnX = "SHCHnX";
    private static final String SHCsats = "SHCsats";
    private static final String SHCsatu = "SHCsatu";
    private static final String SHAvin = "SHAvin";
    private static final String SHother = "SHother";
    private static final String SHmisc = "SHmisc";
    private static final String SsLi = "SsLi";
    private static final String SssBe = "SssBe";
    private static final String SssssBem = "SssssBem";
    private static final String SsBH2 = "SsBH2";
    private static final String SssBH = "SssBH";
    private static final String SsssB = "SsssB";
    private static final String SssssBm = "SssssBm";
    private static final String SsCH3 = "SsCH3";
    private static final String SdCH2 = "SdCH2";
    private static final String SssCH2 = "SssCH2";
    private static final String StCH = "StCH";
    private static final String SdsCH = "SdsCH";
    private static final String SaaCH = "SaaCH";
    private static final String SsssCH = "SsssCH";
    private static final String SddC = "SddC";
    private static final String StsC = "StsC";
    private static final String SdssC = "SdssC";
    private static final String SsaaC = "SsaaC";
    private static final String SaaaC = "SaaaC";
    private static final String SssssC = "SssssC";
    private static final String SsNpH3 = "SsNpH3";
    private static final String SsNH2 = "SsNH2";
    private static final String SssNpH2 = "SssNpH2";
    private static final String SdNH = "SdNH";
    private static final String SssNH = "SssNH";
    private static final String SaaNH = "SaaNH";
    private static final String StN = "StN";
    private static final String SsssNpH = "SsssNpH";
    private static final String SdsN = "SdsN";
    private static final String SaaN = "SaaN";
    private static final String SsssN = "SsssN";
    private static final String SddsN = "SddsN";
    private static final String SsaaN = "SsaaN";
    private static final String SssssNp = "SssssNp";
    private static final String SsOH = "SsOH";
    private static final String SdO = "SdO";
    private static final String SssO = "SssO";
    private static final String SaaO = "SaaO";
    private static final String SaOm = "SaOm";
    private static final String SsOm = "SsOm";
    private static final String SsF = "SsF";
    private static final String SsSiH3 = "SsSiH3";
    private static final String SssSiH2 = "SssSiH2";
    private static final String SsssSiH = "SsssSiH";
    private static final String SssssSi = "SssssSi";
    private static final String SsPH2 = "SsPH2";
    private static final String SssPH = "SssPH";
    private static final String SsssP = "SsssP";
    private static final String SdsssP = "SdsssP";
    private static final String SddsP = "SddsP";
    private static final String SsssssP = "SsssssP";
    private static final String SsSH = "SsSH";
    private static final String SdS = "SdS";
    private static final String SssS = "SssS";
    private static final String SaaS = "SaaS";
    private static final String SdssS = "SdssS";
    private static final String SddssS = "SddssS";
    private static final String SssssssS = "SssssssS";
    private static final String SSm = "SSm";
    private static final String SsCl = "SsCl";
    private static final String SsGeH3 = "SsGeH3";
    private static final String SssGeH2 = "SssGeH2";
    private static final String SsssGeH = "SsssGeH";
    private static final String SssssGe = "SssssGe";
    private static final String SsAsH2 = "SsAsH2";
    private static final String SssAsH = "SssAsH";
    private static final String SsssAs = "SsssAs";
    private static final String SdsssAs = "SdsssAs";
    private static final String SddsAs = "SddsAs";
    private static final String SsssssAs = "SsssssAs";
    private static final String SsSeH = "SsSeH";
    private static final String SdSe = "SdSe";
    private static final String SssSe = "SssSe";
    private static final String SaaSe = "SaaSe";
    private static final String SdssSe = "SdssSe";
    private static final String SssssssSe = "SssssssSe";
    private static final String SddssSe = "SddssSe";
    private static final String SsBr = "SsBr";
    private static final String SsSnH3 = "SsSnH3";
    private static final String SssSnH2 = "SssSnH2";
    private static final String SsssSnH = "SsssSnH";
    private static final String SssssSn = "SssssSn";
    private static final String SsI = "SsI";
    private static final String SsPbH3 = "SsPbH3";
    private static final String SssPbH2 = "SssPbH2";
    private static final String SsssPbH = "SsssPbH";
    private static final String SssssPb = "SssssPb";
    private static final String[] prefixes = new String[]{"n", "S", "min", "max"};
    private static final String[] suffixes = new String[]{"HBd", "wHBd", "HBa", "wHBa", "HBint2", "HBint3", "HBint4", "HBint5", "HBint6", "HBint7", "HBint8", "HBint9", "HBint10", "HsOH", "HdNH", "HsSH", "HsNH2", "HssNH", "HaaNH", "HsNH3p", "HssNH2p", "HsssNHp", "HtCH", "HdCH2", "HdsCH", "HaaCH", "HCHnX", "HCsats", "HCsatu", "HAvin", "Hother", "Hmisc", "sLi", "ssBe", "ssssBem", "sBH2", "ssBH", "sssB", "ssssBm", "sCH3", "dCH2", "ssCH2", "tCH", "dsCH", "aaCH", "sssCH", "ddC", "tsC", "dssC", "aasC", "aaaC", "ssssC", "sNH3p", "sNH2", "ssNH2p", "dNH", "ssNH", "aaNH", "tN", "sssNHp", "dsN", "aaN", "sssN", "ddsN", "aasN", "ssssNp", "sOH", "dO", "ssO", "aaO", "aOm", "sOm", "sF", "sSiH3", "ssSiH2", "sssSiH", "ssssSi", "sPH2", "ssPH", "sssP", "dsssP", "ddsP", "sssssP", "sSH", "dS", "ssS", "aaS", "dssS", "ddssS", "ssssssS", "Sm", "sCl", "sGeH3", "ssGeH2", "sssGeH", "ssssGe", "sAsH2", "ssAsH", "sssAs", "dsssAs", "ddsAs", "sssssAs", "sSeH", "dSe", "ssSe", "aaSe", "dssSe", "ssssssSe", "ddssSe", "sBr", "sSnH3", "ssSnH2", "sssSnH", "ssssSn", "sI", "sPbH3", "ssPbH2", "sssPbH", "ssssPb"};
    private static final String[] others = new String[]{"sumI", "hmax", "gmax", "hmin", "gmin", "LipoaffinityIndex", "MAXDN", "MAXDP", "DELS", "MAXDN2", "MAXDP2", "DELS2"};
    private static final String[] atomTypes = new String[]{"SHBd", "SwHBd", "SHBa", "SwHBa", "SHBint2", "SHBint3", "SHBint4", "SHBint5", "SHBint6", "SHBint7", "SHBint8", "SHBint9", "SHBint10", "SHsOH", "SHdNH", "SHsSH", "SHsNH2", "SHssNH", "SHaaNH", "SHsNH3p", "SHssNH2p", "SHsssNHp", "SHtCH", "SHdCH2", "SHdsCH", "SHaaCH", "SHCHnX", "SHCsats", "SHCsatu", "SHAvin", "SHother", "SHmisc", "SsLi", "SssBe", "SssssBem", "SsBH2", "SssBH", "SsssB", "SssssBm", "SsCH3", "SdCH2", "SssCH2", "StCH", "SdsCH", "SaaCH", "SsssCH", "SddC", "StsC", "SdssC", "SsaaC", "SaaaC", "SssssC", "SsNpH3", "SsNH2", "SssNpH2", "SdNH", "SssNH", "SaaNH", "StN", "SsssNpH", "SdsN", "SaaN", "SsssN", "SddsN", "SsaaN", "SssssNp", "SsOH", "SdO", "SssO", "SaaO", "SaOm", "SsOm", "SsF", "SsSiH3", "SssSiH2", "SsssSiH", "SssssSi", "SsPH2", "SssPH", "SsssP", "SdsssP", "SddsP", "SsssssP", "SsSH", "SdS", "SssS", "SaaS", "SdssS", "SddssS", "SssssssS", "SSm", "SsCl", "SsGeH3", "SssGeH2", "SsssGeH", "SssssGe", "SsAsH2", "SssAsH", "SsssAs", "SdsssAs", "SddsAs", "SsssssAs", "SsSeH", "SdSe", "SssSe", "SaaSe", "SdssSe", "SssssssSe", "SddssSe", "SsBr", "SsSnH3", "SssSnH2", "SsssSnH", "SssssSn", "SsI", "SsPbH3", "SssPbH2", "SsssPbH", "SssssPb"};
    private Map<String, Integer> eStatesCount = new LinkedHashMap<String, Integer>();
    private Map<String, Double> eStatesSum = new LinkedHashMap<String, Double>();
    private Map<String, Double> eStatesMin = new LinkedHashMap<String, Double>();
    private Map<String, Double> eStatesMax = new LinkedHashMap<String, Double>();
    private Map<String, Double> eStatesOthers = new LinkedHashMap<String, Double>();
    public String[] names = new String[prefixes.length * suffixes.length + others.length];

    public EStateAtomTypeDescriptor() {
        int n = 0;
        for (String string : prefixes) {
            for (String string2 : suffixes) {
                this.names[n] = string + string2;
                ++n;
            }
        }
        String[] stringArray = others;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string;
            this.names[n] = string = stringArray[i];
            ++n;
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("eStateAtomType", this.getClass().getName(), "$Id: EStateAtomTypeDescriptor.java 1 2008-06-10 06:50:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        Object object;
        IAtom iAtom;
        int d;
        Object object2;
        IRingSet iRingSet;
        Object object4;
        try {
            object4 = new AllRingsFinder();
            iRingSet = ((AllRingsFinder)object4).findAllRings(iAtomContainer);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Could not find all rings: " + exception.getMessage()));
        }
        this.eStatesCount = new LinkedHashMap<String, Integer>();
        this.eStatesSum = new LinkedHashMap<String, Double>();
        this.eStatesMin = new LinkedHashMap<String, Double>();
        this.eStatesMax = new LinkedHashMap<String, Double>();
        for (String object32 : atomTypes) {
            this.eStatesCount.put(object32, 0);
            this.eStatesSum.put(object32, 0.0);
            this.eStatesMin.put(object32, (Double)Double.MAX_VALUE);
            this.eStatesMax.put(object32, (Double)Double.MIN_VALUE);
        }
        this.eStatesOthers.put(sumI, 0.0);
        this.eStatesOthers.put(hmax, (Double)Double.MIN_VALUE);
        this.eStatesOthers.put(gmax, (Double)Double.MIN_VALUE);
        this.eStatesOthers.put(hmin, (Double)Double.MAX_VALUE);
        this.eStatesOthers.put(gmin, (Double)Double.MAX_VALUE);
        this.eStatesOthers.put(LipoaffinityIndex, 0.0);
        this.eStatesOthers.put(MAXDN, 0.0);
        this.eStatesOthers.put(MAXDP, 0.0);
        this.eStatesOthers.put(DELS, 0.0);
        this.eStatesOthers.put(MAXDN2, 0.0);
        this.eStatesOthers.put(MAXDP2, 0.0);
        this.eStatesOthers.put(DELS2, 0.0);
        object4 = new IntrinsicStateDescriptor();
        ElectrotopologicalStateDescriptor electrotopologicalStateDescriptor = new ElectrotopologicalStateDescriptor();
        HydrogenEStateDescriptor hydrogenEStateDescriptor = new HydrogenEStateDescriptor();
        EStateAtomTypeMatcher eStateAtomTypeMatcher = new EStateAtomTypeMatcher();
        eStateAtomTypeMatcher.setRingSet(iRingSet);
        int n = iAtomContainer.getAtomCount();
        int[][] nArray = new int[n][n];
        for (int dArray = 0; dArray < n; ++dArray) {
            object2 = iAtomContainer.getAtom(dArray);
            if (object2.getSymbol().equals("H")) continue;
            for (d = dArray + 1; d < n; ++d) {
                iAtom = iAtomContainer.getAtom(d);
                if (iAtom.getSymbol().equals("H")) continue;
                int n2 = PathTools.getShortestPath(iAtomContainer, (IAtom)object2, iAtom).size() - 1;
                nArray[d][dArray] = n2;
                nArray[dArray][d] = n2;
            }
        }
        double[] dArray = new double[n];
        object2 = new double[n];
        for (d = 0; d < n; ++d) {
            iAtom = iAtomContainer.getAtom(d);
            if (iAtom.getSymbol().equals("H")) {
                dArray[d] = Double.NaN;
                object2[d] = Double.NaN;
                continue;
            }
            object = (DoubleArrayResult)((IntrinsicStateDescriptor)object4).calculate(iAtom, iAtomContainer).getValue();
            dArray[d] = ((DoubleArrayResult)object).get(0);
            object2[d] = ((DoubleArrayResult)object).get(1);
        }
        for (d = 0; d < n; ++d) {
            IAtomType iAtomType;
            iAtom = iAtomContainer.getAtom(d);
            if (iAtom.getSymbol().equals("H")) continue;
            object = eStateAtomTypeMatcher.findMatchingAtomType(iAtomContainer, iAtom);
            boolean bl = AtomContainerManipulator.countHydrogens(iAtomContainer, iAtom) > 0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < n; ++i) {
                if (d == i || iAtomContainer.getAtom(i).getSymbol().equals("H")) continue;
                d2 += (dArray[d] - dArray[i]) / (double)((nArray[d][i] + 1) * (nArray[d][i] + 1));
                d3 += (object2[d] - object2[i]) / (double)((nArray[d][i] + 1) * (nArray[d][i] + 1));
            }
            double i = Math.abs(d2);
            if (d2 < 0.0) {
                if (i > this.eStatesOthers.get(MAXDN)) {
                    this.eStatesOthers.put(MAXDN, i);
                }
            } else if (d2 > 0.0 && d2 > this.eStatesOthers.get(MAXDP)) {
                this.eStatesOthers.put(MAXDP, d2);
            }
            this.eStatesOthers.put(DELS, this.eStatesOthers.get(DELS) + i);
            double d4 = Math.abs(d3);
            if (d3 < 0.0) {
                if (d4 > this.eStatesOthers.get(MAXDN2)) {
                    this.eStatesOthers.put(MAXDN2, d4);
                }
            } else if (d3 > 0.0 && d3 > this.eStatesOthers.get(MAXDP2)) {
                this.eStatesOthers.put(MAXDP2, d3);
            }
            this.eStatesOthers.put(DELS2, this.eStatesOthers.get(DELS2) + d4);
            this.eStatesOthers.put(sumI, this.eStatesOthers.get(sumI) + Double.valueOf(dArray[d]));
            double d5 = ((DoubleResult)hydrogenEStateDescriptor.calculate(iAtom, iAtomContainer, nArray[d]).getValue()).doubleValue();
            if (object.getAtomTypeName().equals(SsOH)) {
                this.StoreValue(SHsOH, d5);
            } else if (object.getAtomTypeName().equals(SdNH)) {
                this.StoreValue(SHdNH, d5);
            } else if (object.getAtomTypeName().equals(SsSH)) {
                this.StoreValue(SHsSH, d5);
            } else if (object.getAtomTypeName().equals(SsNH2)) {
                this.StoreValue(SHsNH2, d5);
            } else if (object.getAtomTypeName().equals(SssNH)) {
                this.StoreValue(SHssNH, d5);
            } else if (object.getAtomTypeName().equals(SaaNH)) {
                this.StoreValue(SHaaNH, d5);
            } else if (object.getAtomTypeName().equals(SsNpH3)) {
                this.StoreValue(SHsNH3p, d5);
            } else if (object.getAtomTypeName().equals(SssNpH2)) {
                this.StoreValue(SHssNH2p, d5);
            } else if (object.getAtomTypeName().equals(SsssNpH)) {
                this.StoreValue(SHsssNHp, d5);
            } else if (object.getAtomTypeName().equals(StCH)) {
                this.StoreValue(SHtCH, d5);
            } else if (object.getAtomTypeName().equals(SdCH2)) {
                this.StoreValue(SHdCH2, d5);
            } else if (object.getAtomTypeName().equals(SdsCH)) {
                this.StoreValue(SHdsCH, d5);
            } else if (object.getAtomTypeName().equals(SaaCH)) {
                this.StoreValue(SHaaCH, d5);
            }
            if (iAtom.getSymbol().equals("C") && bl) {
                for (IAtom bl3 : iAtomContainer.getConnectedAtomsList(iAtom)) {
                    if (bl3.getSymbol().equals("F") || bl3.getSymbol().equals("Cl")) {
                        this.StoreValue(SHCHnX, d5);
                        this.StoreValue(SwHBd, d5);
                        break;
                    }
                    if (!bl3.getSymbol().equals("Br") && !bl3.getSymbol().equals("I")) continue;
                    this.StoreValue(SHCHnX, d5);
                    break;
                }
            }
            if (object.getAtomTypeName().equals(SsCH3) || object.getAtomTypeName().equals(SssCH2) || object.getAtomTypeName().equals(SsssCH)) {
                boolean bl2 = false;
                boolean bl3 = false;
                for (IAtom iAtom2 : iAtomContainer.getConnectedAtomsList(iAtom)) {
                    if (iAtom == iAtom2) continue;
                    if (!bl2 || !bl3) {
                        iAtomType = eStateAtomTypeMatcher.findMatchingAtomType(iAtomContainer, iAtom2);
                        if (!bl2 && (iAtomType.getAtomTypeName().equals(SsCH3) || iAtomType.getAtomTypeName().equals(SssCH2) || iAtomType.getAtomTypeName().equals(SsssCH) || iAtomType.getAtomTypeName().equals(SssssC))) {
                            this.StoreValue(SHCsats, d5);
                            bl2 = true;
                        }
                        if (bl3 || !iAtomType.getAtomTypeName().equals(SdCH2) && !iAtomType.getAtomTypeName().equals(StCH) && !iAtomType.getAtomTypeName().equals(SdsCH) && !iAtomType.getAtomTypeName().equals(SddC) && !iAtomType.getAtomTypeName().equals(StsC) && !iAtomType.getAtomTypeName().equals(SdssC)) continue;
                        this.StoreValue(SHCsatu, d5);
                        bl3 = true;
                        continue;
                    }
                    break;
                }
            } else if (object.getAtomTypeName().equals(SdsCH)) {
                for (IAtom bl3 : iAtomContainer.getConnectedAtomsList(iAtom)) {
                    if (iAtom == bl3 || !(i = eStateAtomTypeMatcher.findMatchingAtomType(iAtomContainer, bl3)).getAtomTypeName().equals(SaaCH) && !i.getAtomTypeName().equals(SsaaC) && !i.getAtomTypeName().equals(SaaaC)) continue;
                    this.StoreValue(SHAvin, d5);
                    break;
                }
            }
            if (object.getAtomTypeName().equals(SaaCH) || object.getAtomTypeName().equals(SdCH2) || object.getAtomTypeName().equals(SdsCH)) {
                this.StoreValue(SHother, d5);
            } else if ((iAtom.getSymbol().equals("B") || iAtom.getSymbol().equals("Si") || iAtom.getSymbol().equals("P") || iAtom.getSymbol().equals("Ge") || iAtom.getSymbol().equals("As") || iAtom.getSymbol().equals("Se") || iAtom.getSymbol().equals("Sn") || iAtom.getSymbol().equals("Pb")) && bl) {
                this.StoreValue(SHmisc, d5);
            }
            double d6 = ((DoubleResult)electrotopologicalStateDescriptor.calculate(iAtom, iAtomContainer, nArray[d]).getValue()).doubleValue();
            if (this.eStatesSum.containsKey(object.getAtomTypeName())) {
                this.StoreValue(object.getAtomTypeName(), d6);
            }
            if (object.getAtomTypeName().equals(SsOH) || object.getAtomTypeName().equals(SdNH) || object.getAtomTypeName().equals(SsNH2) || object.getAtomTypeName().equals(SssNH) || object.getAtomTypeName().equals(SaaNH) || object.getAtomTypeName().equals(SsSH) || object.getAtomTypeName().equals(StCH)) {
                this.StoreValue(SHBd, d5);
            }
            if (object.getAtomTypeName().equals(SsOH) || object.getAtomTypeName().equals(SdNH) || object.getAtomTypeName().equals(SsNH2) || object.getAtomTypeName().equals(SssNH) || object.getAtomTypeName().equals(SaaNH) || object.getAtomTypeName().equals(SsssN) || object.getAtomTypeName().equals(SsaaN) || object.getAtomTypeName().equals(SssO) || object.getAtomTypeName().equals(SaaO) || object.getAtomTypeName().equals(SdO) || object.getAtomTypeName().equals(SssS) || object.getAtomTypeName().equals(SaaS) || object.getAtomTypeName().equals(SsF) || object.getAtomTypeName().equals(SsCl)) {
                this.StoreValue(SHBa, d6);
                for (int j = 0; j < n; ++j) {
                    int n3;
                    IAtom iAtom2;
                    iAtom2 = iAtomContainer.getAtom(j);
                    if (iAtom == iAtom2 || !(iAtomType = eStateAtomTypeMatcher.findMatchingAtomType(iAtomContainer, iAtom2)).getAtomTypeName().equals(SsOH) && !iAtomType.getAtomTypeName().equals(SdNH) && !iAtomType.getAtomTypeName().equals(SsNH2) && !iAtomType.getAtomTypeName().equals(SssNH) && !iAtomType.getAtomTypeName().equals(SaaNH) && !iAtomType.getAtomTypeName().equals(SsSH) && !iAtomType.getAtomTypeName().equals(StCH) || (n3 = nArray[d][j]) < 2 || n3 > 10) continue;
                    String string = "SHBint" + n3;
                    double d7 = ((DoubleResult)hydrogenEStateDescriptor.calculate(iAtom2, iAtomContainer).getValue()).doubleValue();
                    this.StoreValue(string, Double.valueOf(d6) * Double.valueOf(d7));
                }
            }
            if (object.getAtomTypeName().equals(SdCH2) || object.getAtomTypeName().equals(StCH) || object.getAtomTypeName().equals(SdsCH) || object.getAtomTypeName().equals(SaaCH) || object.getAtomTypeName().equals(SddC) || object.getAtomTypeName().equals(StsC) || object.getAtomTypeName().equals(SdssC) || object.getAtomTypeName().equals(SsaaC) || object.getAtomTypeName().equals(SaaaC)) {
                this.StoreValue(SwHBa, d6);
            }
            if (d5 > this.eStatesOthers.get(hmax)) {
                this.eStatesOthers.put(hmax, d5);
            }
            if (d5 < this.eStatesOthers.get(hmin)) {
                this.eStatesOthers.put(hmin, d5);
            }
            if (d6 > this.eStatesOthers.get(gmax)) {
                this.eStatesOthers.put(gmax, d6);
            }
            if (!(d6 < this.eStatesOthers.get(gmin))) continue;
            this.eStatesOthers.put(gmin, d6);
        }
        double d8 = 0.432 * this.eStatesSum.get(SsCH3);
        d8 += 0.318 * this.eStatesSum.get(SdCH2);
        d8 += 0.482 * this.eStatesSum.get(SssCH2);
        d8 += 0.123 * this.eStatesSum.get(StCH);
        d8 += 0.28 * this.eStatesSum.get(SdsCH);
        d8 += 0.299 * this.eStatesSum.get(SaaCH);
        d8 += 0.425 * this.eStatesSum.get(SsssCH);
        d8 += 0.333 * this.eStatesSum.get(SddC);
        d8 += 0.125 * this.eStatesSum.get(StsC);
        d8 += -0.141 * this.eStatesSum.get(SdssC);
        d8 += 0.2 * this.eStatesSum.get(SsaaC);
        d8 += 0.334 * this.eStatesSum.get(SaaaC);
        d8 += 0.245 * this.eStatesSum.get(SssssC);
        d8 += 0.137 * this.eStatesSum.get(SsF);
        d8 += 0.309 * this.eStatesSum.get(SsSH);
        d8 += 0.314 * this.eStatesSum.get(SdS);
        d8 += 0.561 * this.eStatesSum.get(SssS);
        d8 += 0.821 * this.eStatesSum.get(SaaS);
        d8 += 0.307 * this.eStatesSum.get(SsCl);
        d8 += 0.755 * this.eStatesSum.get(SsBr);
        this.eStatesOthers.put(LipoaffinityIndex, d8 += 1.616 * this.eStatesSum.get(SsI));
        object = new DoubleArrayResult();
        for (Integer d82 : this.eStatesCount.values()) {
            ((DoubleArrayResult)object).add(d82.intValue());
        }
        for (Double d9 : this.eStatesSum.values()) {
            ((DoubleArrayResult)object).add(d9);
        }
        for (Double d10 : this.eStatesMin.values()) {
            if (d10 != Double.MAX_VALUE) {
                ((DoubleArrayResult)object).add(d10);
                continue;
            }
            ((DoubleArrayResult)object).add(0.0);
        }
        for (Double d11 : this.eStatesMax.values()) {
            if (d11 != Double.MIN_VALUE) {
                ((DoubleArrayResult)object).add(d11);
                continue;
            }
            ((DoubleArrayResult)object).add(0.0);
        }
        for (Double d9 : this.eStatesOthers.values()) {
            ((DoubleArrayResult)object).add(d9);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)object, this.names);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }

    private void StoreValue(String string, Double d) {
        this.eStatesCount.put(string, this.eStatesCount.get(string) + 1);
        this.eStatesSum.put(string, this.eStatesSum.get(string) + d);
        if (d > this.eStatesMax.get(string)) {
            this.eStatesMax.put(string, d);
        }
        if (d < this.eStatesMin.get(string)) {
            this.eStatesMin.put(string, d);
        }
    }
}

