/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.CompoundAbstractProcessing;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeFile;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import libpadeldescriptor.PaDELStandardize;
import org.openscience.cdk.interfaces.IAtomContainer;

public class CompoundStandardize
extends CompoundAbstractProcessing {
    public static final String PARAMETER_REMOVE_SALT = "remove_salt";
    public static final String PARAMETER_DETECT_AROMATICITY = "detect_aromaticity";
    public static final String PARAMETER_STANDARDIZE_TAUTOMERS = "standardize_tautomers";
    public static final String PARAMETER_TAUTOMER_FILE = "tautomer_file";
    public static final String PARAMETER_STANDARDIZE_NITRO = "standardize_nitro";
    public static final String PARAMETER_RETAIN_3D = "retain_3D";

    public CompoundStandardize(OperatorDescription operatorDescription) {
        super(operatorDescription);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeBoolean parameterTypeBoolean = null;
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_REMOVE_SALT, "Remove salt from a molecule. This option assumes that the largest fragment is the desired molecule.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_DETECT_AROMATICITY, "Remove existing aromaticity information and automatically detect aromaticity in the molecule before calculation of descriptors.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_STANDARDIZE_TAUTOMERS, "Standardize tautomers.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeFile(PARAMETER_TAUTOMER_FILE, "File containing SMIRKS tautomers. Leave blank if using default settings.", "txt", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_STANDARDIZE_NITRO, "Standardize nitro groups to N(:O):O.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_RETAIN_3D, "Retain 3D coordinates when standardizing structure. However, this may prevent some structures from being standardized.", false);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        return list;
    }

    public void doWork() throws OperatorException {
        Compounds compounds = (Compounds)this.molInput.getData();
        Compounds compounds2 = new Compounds();
        boolean bl = this.getParameterAsBoolean(PARAMETER_REMOVE_SALT);
        boolean bl2 = this.getParameterAsBoolean(PARAMETER_DETECT_AROMATICITY);
        boolean bl3 = this.getParameterAsBoolean(PARAMETER_STANDARDIZE_TAUTOMERS);
        boolean bl4 = this.getParameterAsBoolean(PARAMETER_STANDARDIZE_NITRO);
        boolean bl5 = this.getParameterAsBoolean(PARAMETER_RETAIN_3D);
        String string = this.getParameterAsString(PARAMETER_TAUTOMER_FILE);
        String[] stringArray = null;
        if (string != null && !string.trim().isEmpty()) {
            stringArray = PaDELStandardize.getTautomerList((File)new File(string));
        } else {
            try {
                stringArray = PaDELStandardize.getTautomerList((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("META-INF/tautomerlist.txt"));
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.SEVERE, "Cannot read in SMIRKS tautomers file", exception);
            }
        }
        PaDELStandardize paDELStandardize = new PaDELStandardize();
        paDELStandardize.setRemoveSalt(bl);
        paDELStandardize.setDearomatize(bl2);
        paDELStandardize.setStandardizeTautomers(bl3);
        paDELStandardize.setTautomerList(stringArray);
        paDELStandardize.setStandardizeNitro(bl4);
        paDELStandardize.setRetain3D(bl5);
        int n = compounds.size();
        for (int i = 0; i < n; ++i) {
            IAtomContainer iAtomContainer = compounds.getMolecule(i);
            try {
                iAtomContainer = paDELStandardize.Standardize(iAtomContainer);
                compounds.setMolecule(i, iAtomContainer);
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.FINE, null, exception);
            }
        }
        compounds.recalculateStatistics();
        this.molOriginal.deliver((IOObject)compounds2);
        this.molOutput.deliver((IOObject)compounds);
    }
}

