/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.table.AttributeFactory;
import com.rapidminer.example.table.DataRow;
import com.rapidminer.example.table.DoubleArrayDataRow;
import com.rapidminer.example.table.MemoryExampleTable;
import com.rapidminer.gui.wizards.ConfigurationListener;
import com.rapidminer.gui.wizards.MoleculeDescriptorsConfigurationWizardCreator;
import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.Operator;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.Compounds;
import com.rapidminer.operator.ports.InputPort;
import com.rapidminer.operator.ports.OutputPort;
import com.rapidminer.parameter.ParameterHandler;
import com.rapidminer.parameter.ParameterType;
import com.rapidminer.parameter.ParameterTypeBoolean;
import com.rapidminer.parameter.ParameterTypeCategory;
import com.rapidminer.parameter.ParameterTypeConfiguration;
import com.rapidminer.parameter.ParameterTypeFile;
import com.rapidminer.parameter.ParameterTypeInt;
import com.rapidminer.parameter.ParameterTypeString;
import com.rapidminer.parameter.conditions.BooleanParameterCondition;
import com.rapidminer.parameter.conditions.ParameterCondition;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import libpadeldescriptor.DescriptorStruct;
import libpadeldescriptor.PaDELStandardize;
import libpadeldescriptor.libPaDELDescriptorMasterGeneral;
import libpadeldescriptor.libPaDELDescriptorType;
import padeldescriptor.PaDELDescriptorPropertySheetPage2;
import padeldescriptor.PaDELDescriptorPropertySheetPage3;
import padeldescriptor.PaDELDescriptorPropertySheetPage4;
import padeldescriptor.PaDELDescriptorView;

public class CompoundDescriptors
extends Operator {
    public static final String PARAMETER_COMPUTE_2D = "compute_1D/2D";
    public static final String PARAMETER_COMPUTE_3D = "compute_3D";
    public static final String PARAMETER_COMPUTE_FINGERPRINTS = "compute_fingerprints";
    public static final String PARAMETER_USE_DESCRIPTOR_FILE = "use_descriptor_file";
    public static final String PARAMETER_DESCRIPTOR_FILE = "descriptor_file";
    public static final String PARAMETER_REMOVE_SALT = "remove_salt";
    public static final String PARAMETER_DETECT_AROMATICITY = "detect_aromaticity";
    public static final String PARAMETER_STANDARDIZE_TAUTOMERS = "standardize_tautomers";
    public static final String PARAMETER_TAUTOMER_FILE = "tautomer_file";
    public static final String PARAMETER_STANDARDIZE_NITRO = "standardize_nitro";
    public static final String PARAMETER_RETAIN_3D = "retain_3D";
    public static final String PARAMETER_CONVERT_3D = "convert_3D";
    public static final String[] convert3DStrings = new String[]{"No", "Yes (use MM2 forcefield)", "Yes (use MMFF94 forcefield)"};
    public static final String PARAMETER_LOG = "log_process";
    public static final String PARAMETER_LOG_FILE = "log_file";
    public static final String PARAMETER_MAX_THREADS = "max_threads";
    public static final String PARAMETER_MAX_WAITING_JOBS = "max_waiting_jobs";
    public static final String PARAMETER_MAX_RUN_TIME = "max_run_time";
    public static final String PARAMETER_HIDDEN_2D = "2D";
    public static final String PARAMETER_HIDDEN_3D = "3D";
    public static final String PARAMETER_HIDDEN_FINGERPRINTS = "fingerprints";
    public static final String PARAMETER_HIDDEN_2D_INACTIVE = "2DInactive";
    public static final String PARAMETER_HIDDEN_3D_INACTIVE = "3DInactive";
    public static final String PARAMETER_HIDDEN_FINGERPRINTS_INACTIVE = "fingerprintsInactive";
    protected final InputPort molInput = (InputPort)this.getInputPorts().createPort("mol");
    protected final OutputPort exampleSetOutput = (OutputPort)this.getOutputPorts().createPort("exa");
    protected final OutputPort molOriginal = (OutputPort)this.getOutputPorts().createPort("ori");
    public PaDELDescriptorPropertySheetPage2 descriptor2DConfig = new PaDELDescriptorPropertySheetPage2();
    public PaDELDescriptorPropertySheetPage3 descriptor3DConfig = new PaDELDescriptorPropertySheetPage3();
    public PaDELDescriptorPropertySheetPage4 fingerprintConfig = new PaDELDescriptorPropertySheetPage4();

    public CompoundDescriptors(OperatorDescription operatorDescription) {
        super(operatorDescription);
        this.getTransformer().addPassThroughRule(this.molInput, this.molOriginal);
    }

    public List<ParameterType> getParameterTypes() {
        List list = super.getParameterTypes();
        ParameterTypeBoolean parameterTypeBoolean = null;
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_COMPUTE_2D, "Calculate 1D and 2D descriptors.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_COMPUTE_3D, "Calculate 3D descriptors.", false);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_COMPUTE_FINGERPRINTS, "Calculate fingerprints.", false);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_USE_DESCRIPTOR_FILE, "Load descriptors types to calculate from file.", false);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeFile(PARAMETER_DESCRIPTOR_FILE, "Filename of descriptor types file. This file can be generated using PaDEL-Descriptor.", "xml", true);
        parameterTypeBoolean.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_DESCRIPTOR_FILE, true, true));
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeConfiguration(MoleculeDescriptorsConfigurationWizardCreator.class, (ConfigurationListener)this);
        parameterTypeBoolean.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_USE_DESCRIPTOR_FILE, true, false));
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_REMOVE_SALT, "Remove salt from a molecule. This option assumes that the largest fragment is the desired molecule.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_DETECT_AROMATICITY, "Remove existing aromaticity information and automatically detect aromaticity in the molecule before calculation of descriptors.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_STANDARDIZE_TAUTOMERS, "Standardize tautomers.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeFile(PARAMETER_TAUTOMER_FILE, "File containing SMIRKS tautomers.", "txt", false);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_STANDARDIZE_NITRO, "Standardize nitro groups to N(:O):O.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_RETAIN_3D, "Retain 3D coordinates when standardizing structure. However, this may prevent some structures from being standardized.", false);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeCategory(PARAMETER_CONVERT_3D, "Convert molecule to 3D.", convert3DStrings, 0);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeBoolean(PARAMETER_LOG, "Create a log file.", true);
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeFile(PARAMETER_LOG_FILE, "The path to the log file.", null, true);
        parameterTypeBoolean.registerDependencyCondition((ParameterCondition)new BooleanParameterCondition((ParameterHandler)this, PARAMETER_LOG, true, true));
        parameterTypeBoolean.setExpert(false);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeInt(PARAMETER_MAX_THREADS, "Maximum number of threads to use. Use -1 to use as many threads as the number of cpu cores.", -1, Integer.MAX_VALUE, -1);
        parameterTypeBoolean.setExpert(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeInt(PARAMETER_MAX_WAITING_JOBS, "Maximum number of jobs to store in queue for worker threads to process. Use -1 to set it to 50*Max threads.", -1, Integer.MAX_VALUE, -1);
        parameterTypeBoolean.setExpert(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeInt(PARAMETER_MAX_RUN_TIME, "Maximum running time per molecule (in milliseconds). Use -1 for unlimited.", -1, Integer.MAX_VALUE, -1);
        parameterTypeBoolean.setExpert(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeString(PARAMETER_HIDDEN_2D, PARAMETER_HIDDEN_2D, true);
        parameterTypeBoolean.setExpert(true);
        parameterTypeBoolean.setHidden(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeString(PARAMETER_HIDDEN_3D, PARAMETER_HIDDEN_3D, true);
        parameterTypeBoolean.setExpert(true);
        parameterTypeBoolean.setHidden(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeString(PARAMETER_HIDDEN_FINGERPRINTS, PARAMETER_HIDDEN_FINGERPRINTS, true);
        parameterTypeBoolean.setExpert(true);
        parameterTypeBoolean.setHidden(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeString(PARAMETER_HIDDEN_2D_INACTIVE, PARAMETER_HIDDEN_2D_INACTIVE, true);
        parameterTypeBoolean.setExpert(true);
        parameterTypeBoolean.setHidden(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeString(PARAMETER_HIDDEN_3D_INACTIVE, PARAMETER_HIDDEN_3D_INACTIVE, true);
        parameterTypeBoolean.setExpert(true);
        parameterTypeBoolean.setHidden(true);
        list.add(parameterTypeBoolean);
        parameterTypeBoolean = new ParameterTypeString(PARAMETER_HIDDEN_FINGERPRINTS_INACTIVE, PARAMETER_HIDDEN_FINGERPRINTS_INACTIVE, true);
        parameterTypeBoolean.setExpert(true);
        parameterTypeBoolean.setHidden(true);
        list.add(parameterTypeBoolean);
        return list;
    }

    public void doWork() throws OperatorException {
        long l;
        int n;
        Object object;
        Compounds compounds = (Compounds)this.molInput.getData();
        ArrayList arrayList = new ArrayList();
        boolean bl = this.getParameterAsBoolean(PARAMETER_COMPUTE_2D);
        boolean bl2 = this.getParameterAsBoolean(PARAMETER_COMPUTE_3D);
        boolean bl3 = this.getParameterAsBoolean(PARAMETER_COMPUTE_FINGERPRINTS);
        boolean bl4 = this.getParameterAsBoolean(PARAMETER_REMOVE_SALT);
        boolean bl5 = this.getParameterAsBoolean(PARAMETER_DETECT_AROMATICITY);
        boolean bl6 = this.getParameterAsBoolean(PARAMETER_STANDARDIZE_TAUTOMERS);
        boolean bl7 = this.getParameterAsBoolean(PARAMETER_STANDARDIZE_NITRO);
        boolean bl8 = this.getParameterAsBoolean(PARAMETER_RETAIN_3D);
        boolean bl9 = false;
        String string = "mm2";
        int n2 = this.getParameterAsInt(PARAMETER_CONVERT_3D);
        if (n2 == 0) {
            bl9 = false;
        } else {
            bl9 = true;
            string = n2 == 1 ? "mm2" : "mmff94";
        }
        boolean bl10 = this.getParameterAsBoolean(PARAMETER_LOG);
        String string2 = this.getParameterAsString(PARAMETER_LOG_FILE);
        libPaDELDescriptorMasterGeneral libPaDELDescriptorMasterGeneral2 = new libPaDELDescriptorMasterGeneral(compounds.getMolecules(), arrayList, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, string2);
        if (this.getParameterAsBoolean(PARAMETER_USE_DESCRIPTOR_FILE)) {
            try {
                libPaDELDescriptorMasterGeneral2.SetDescriptorTypes(this.getParameterAsString(PARAMETER_DESCRIPTOR_FILE));
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.SEVERE, null, exception);
            }
        } else {
            this.SetDescriptors();
            object = PaDELDescriptorView.GetDescriptors(this.descriptor2DConfig, this.descriptor3DConfig, this.fingerprintConfig);
            libPaDELDescriptorMasterGeneral2.SetDescriptorTypes(libPaDELDescriptorType.GetActiveDescriptorTypes((Set)object, (boolean)bl, (boolean)bl2, (boolean)bl3));
        }
        object = this.getParameterAsString(PARAMETER_TAUTOMER_FILE);
        String[] stringArray = null;
        if (object != null && !((String)object).trim().isEmpty()) {
            stringArray = PaDELStandardize.getTautomerList((File)new File((String)object));
        } else {
            try {
                stringArray = PaDELStandardize.getTautomerList((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("META-INF/tautomerlist.txt"));
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.SEVERE, "Cannot read in SMIRKS tautomers file", exception);
            }
        }
        libPaDELDescriptorMasterGeneral2.setTautomerList(stringArray);
        int n3 = this.getParameterAsInt(PARAMETER_MAX_THREADS);
        if (n3 > 0) {
            libPaDELDescriptorMasterGeneral2.setMaxThreads(n3);
        }
        if ((n = this.getParameterAsInt(PARAMETER_MAX_WAITING_JOBS)) > 0) {
            libPaDELDescriptorMasterGeneral2.setMaxJobsWaiting(n);
        }
        if ((l = (long)this.getParameterAsInt(PARAMETER_MAX_RUN_TIME)) > 0L) {
            libPaDELDescriptorMasterGeneral2.setMaxRunTime(l);
        }
        libPaDELDescriptorMasterGeneral2.setLogResults(bl10);
        libPaDELDescriptorMasterGeneral2.setForcefield(string);
        libPaDELDescriptorMasterGeneral2.Initialize();
        while (libPaDELDescriptorMasterGeneral2.HasWork()) {
            libPaDELDescriptorMasterGeneral2.DoWork();
        }
        LinkedList<Attribute> linkedList = new LinkedList<Attribute>();
        Attribute attribute = AttributeFactory.createAttribute((String)"Compound", (int)1);
        linkedList.add(attribute);
        List list = (List)arrayList.get(0);
        int n4 = list.size();
        for (int i = 0; i < n4; ++i) {
            linkedList.add(AttributeFactory.createAttribute((String)((String)list.get(i)), (int)4));
        }
        MemoryExampleTable memoryExampleTable = new MemoryExampleTable(linkedList);
        int n5 = arrayList.size();
        for (n4 = 1; n4 < n5; ++n4) {
            List list2 = (List)arrayList.get(n4);
            int n6 = list2.size() + 1;
            double[] dArray = new double[n6];
            dArray[0] = memoryExampleTable.findAttribute("Compound").getMapping().mapString(compounds.getMoleculeName(n4 - 1));
            int n7 = list2.size();
            for (int i = 0; i < n7; ++i) {
                if (!((String)list2.get(i)).equals("")) {
                    dArray[i + 1] = Double.parseDouble((String)list2.get(i));
                    if (!Double.isInfinite(dArray[i + 1])) continue;
                    dArray[i + 1] = Double.NaN;
                    continue;
                }
                dArray[i + 1] = Double.NaN;
            }
            memoryExampleTable.addDataRow((DataRow)new DoubleArrayDataRow(dArray));
        }
        this.molOriginal.deliver((IOObject)compounds);
        this.exampleSetOutput.deliver((IOObject)memoryExampleTable.createExampleSet(null, null, attribute));
    }

    public void SetDescriptors() {
        try {
            int n;
            int n2;
            String[] stringArray;
            String string = this.getParameterAsString(PARAMETER_HIDDEN_2D);
            String string2 = this.getParameterAsString(PARAMETER_HIDDEN_3D);
            String string3 = this.getParameterAsString(PARAMETER_HIDDEN_FINGERPRINTS);
            String string4 = this.getParameterAsString(PARAMETER_HIDDEN_2D_INACTIVE);
            String string5 = this.getParameterAsString(PARAMETER_HIDDEN_3D_INACTIVE);
            String string6 = this.getParameterAsString(PARAMETER_HIDDEN_FINGERPRINTS_INACTIVE);
            Method method = null;
            Class[] classArray = new Class[]{Boolean.TYPE};
            if (!string.equals("")) {
                stringArray = string.split("\\|");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    try {
                        method = this.descriptor2DConfig.data.getClass().getMethod("set" + stringArray[n], classArray);
                        if (method == null) continue;
                        method.invoke((Object)this.descriptor2DConfig.data, true);
                        this.descriptor2DConfig.sheet.readFromObject((Object)this.descriptor2DConfig.data);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.SEVERE, "Cannot find descriptor type.", exception);
                    }
                }
            }
            if (!string2.equals("")) {
                stringArray = string2.split("\\|");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    try {
                        method = this.descriptor3DConfig.data.getClass().getMethod("set" + stringArray[n], classArray);
                        if (method == null) continue;
                        method.invoke((Object)this.descriptor3DConfig.data, true);
                        this.descriptor3DConfig.sheet.readFromObject((Object)this.descriptor3DConfig.data);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.SEVERE, "Cannot find descriptor type.", exception);
                    }
                }
            }
            if (!string3.equals("")) {
                stringArray = string3.split("\\|");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    try {
                        method = this.fingerprintConfig.data.getClass().getMethod("set" + stringArray[n], classArray);
                        if (method == null) continue;
                        method.invoke((Object)this.fingerprintConfig.data, true);
                        this.fingerprintConfig.sheet.readFromObject((Object)this.fingerprintConfig.data);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.SEVERE, "Cannot find descriptor type.", exception);
                    }
                }
            }
            if (!string4.equals("")) {
                stringArray = string4.split("\\|");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    try {
                        method = this.descriptor2DConfig.data.getClass().getMethod("set" + stringArray[n], classArray);
                        if (method == null) continue;
                        method.invoke((Object)this.descriptor2DConfig.data, false);
                        this.descriptor2DConfig.sheet.readFromObject((Object)this.descriptor2DConfig.data);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.SEVERE, "Cannot find descriptor type.", exception);
                    }
                }
            }
            if (!string5.equals("")) {
                stringArray = string5.split("\\|");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    try {
                        method = this.descriptor3DConfig.data.getClass().getMethod("set" + stringArray[n], classArray);
                        if (method == null) continue;
                        method.invoke((Object)this.descriptor3DConfig.data, false);
                        this.descriptor3DConfig.sheet.readFromObject((Object)this.descriptor3DConfig.data);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.SEVERE, "Cannot find descriptor type.", exception);
                    }
                }
            }
            if (!string6.equals("")) {
                stringArray = string6.split("\\|");
                n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    try {
                        method = this.fingerprintConfig.data.getClass().getMethod("set" + stringArray[n], classArray);
                        if (method == null) continue;
                        method.invoke((Object)this.fingerprintConfig.data, false);
                        this.fingerprintConfig.sheet.readFromObject((Object)this.fingerprintConfig.data);
                        continue;
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.SEVERE, "Cannot find descriptor type.", exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void UpdateDescriptors() {
        String string = new String();
        String string2 = new String();
        String string3 = new String();
        String string4 = new String();
        String string5 = new String();
        String string6 = new String();
        Set<DescriptorStruct> set = PaDELDescriptorView.GetDescriptors(this.descriptor2DConfig, this.descriptor3DConfig, this.fingerprintConfig);
        for (DescriptorStruct descriptorStruct : set) {
            String string7 = descriptorStruct.getType();
            if (string7.equals(PARAMETER_HIDDEN_2D)) {
                if (descriptorStruct.isActive()) {
                    string = string + descriptorStruct.getName() + "|";
                } else {
                    string4 = string4 + descriptorStruct.getName() + "|";
                }
            }
            if (string7.equals(PARAMETER_HIDDEN_3D)) {
                if (descriptorStruct.isActive()) {
                    string2 = string2 + descriptorStruct.getName() + "|";
                } else {
                    string5 = string5 + descriptorStruct.getName() + "|";
                }
            }
            if (!string7.equals("Fingerprint")) continue;
            if (descriptorStruct.isActive()) {
                string3 = string3 + descriptorStruct.getName() + "|";
                continue;
            }
            string6 = string6 + descriptorStruct.getName() + "|";
        }
        this.setParameter(PARAMETER_HIDDEN_2D, string);
        this.setParameter(PARAMETER_HIDDEN_3D, string2);
        this.setParameter(PARAMETER_HIDDEN_FINGERPRINTS, string3);
        this.setParameter(PARAMETER_HIDDEN_2D_INACTIVE, string4);
        this.setParameter(PARAMETER_HIDDEN_3D_INACTIVE, string5);
        this.setParameter(PARAMETER_HIDDEN_FINGERPRINTS_INACTIVE, string6);
    }
}

