/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;

public class PaDELHBondDonorCountDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"nHBDon", "nHBDon_Lipinski"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("PaDELHBondDonorCountDescriptor", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        IntegerArrayResult integerArrayResult = new IntegerArrayResult(this.getDescriptorNames().length);
        int n = this.getDescriptorNames().length;
        for (int i = 0; i < n; ++i) {
            integerArrayResult.add(0);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), integerArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        IAtomContainer iAtomContainer2;
        int n = 0;
        int n2 = 0;
        try {
            iAtomContainer2 = iAtomContainer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this.getDummyDescriptorValue(cloneNotSupportedException);
        }
        for (int i = 0; i < iAtomContainer2.getAtomCount(); ++i) {
            IAtom iAtom = iAtomContainer2.getAtom(i);
            if (!iAtom.getSymbol().equals("O") && !iAtom.getSymbol().equals("N")) continue;
            Integer n3 = iAtom.getImplicitHydrogenCount();
            if (n3 == CDKConstants.UNSET) {
                n3 = 0;
            }
            n2 += n3.intValue();
            List<IAtom> list = iAtomContainer2.getConnectedAtomsList(iAtom);
            for (IAtom iAtom2 : list) {
                if (!iAtom2.getSymbol().equals("H")) continue;
                ++n2;
            }
            boolean bl = false;
            if (bl) continue;
            if (n3 > 0) {
                bl = true;
            }
            for (IAtom iAtom3 : list) {
                if (!iAtom3.getSymbol().equals("H")) continue;
                bl = true;
            }
            if (!bl || iAtom.getFormalCharge() < 0) continue;
            ++n;
        }
        IntegerArrayResult integerArrayResult = new IntegerArrayResult();
        integerArrayResult.add(n);
        integerArrayResult.add(n2);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), integerArrayResult, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(names.length);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }
}

