/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.math.qm;

import org.openscience.cdk.math.IFunction;
import org.openscience.cdk.math.Matrix;
import org.openscience.cdk.math.Vector;
import org.openscience.cdk.math.qm.IBasis;

public class FourierGridBasis
implements IBasis {
    private int N;
    private double minx;
    private double maxx;
    private double dx;
    private IFunction potential;
    private double Tl;
    private int N2;

    public FourierGridBasis(int N, double minx, double maxx, IFunction potential) {
        this.N = N;
        this.minx = minx;
        this.maxx = maxx;
        this.dx = (maxx - minx) / (double)N;
        this.potential = potential;
        this.Tl = 2.0 * (Math.PI / ((double)N * this.dx)) * (Math.PI / ((double)N * this.dx)) / 10.0;
        this.N2 = (N - 1) / 2;
    }

    public int getSize() {
        return this.N;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return -1.0;
    }

    public double getMaxY() {
        return 1.0;
    }

    public double getMinZ() {
        return -1.0;
    }

    public double getMaxZ() {
        return 1.0;
    }

    public double getValue(int index, double x, double y, double z) {
        if ((double)index * this.dx + this.minx <= x && x <= (double)index * this.dx + this.maxx + this.dx) {
            return 1.0;
        }
        return 0.0;
    }

    public Vector getValues(int index, Matrix m) {
        if (m.columns < 1) {
            return null;
        }
        Vector result = new Vector(m.columns);
        for (int i = 0; i < m.columns; ++i) {
            result.vector[i] = (double)index * this.dx + this.minx <= m.matrix[0][i] && m.matrix[0][i] <= (double)index * this.dx + this.maxx + this.dx ? 1.0 : 0.0;
        }
        return result;
    }

    public double calcS(int i, int j) {
        if (i == j) {
            return 1.0;
        }
        return 0.0;
    }

    public double calcJ(int i, int j) {
        double result = 0.0;
        for (int l = 1; l <= this.N2; ++l) {
            result += Math.cos((double)(l * 2) * Math.PI * (double)(i - j) / (double)this.N) * this.Tl * (double)l * (double)l;
        }
        return result * 2.0 / (double)this.N;
    }

    public double calcV(int i, int j) {
        if (i == j) {
            return this.potential.getValue(this.minx + this.dx * (double)i, 0.0, 0.0);
        }
        return 0.0;
    }

    public double calcI(int i, int j, int k, int l) {
        return 0.0;
    }
}

