/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fingerprint.ExtendedFingerprinterTest")
public class ExtendedFingerprinter
implements IFingerprinter {
    private final int RESERVED_BITS = 25;
    private Fingerprinter fingerprinter = null;

    public ExtendedFingerprinter() {
        this(1024, 8);
    }

    public ExtendedFingerprinter(int size) {
        this(size, 8);
    }

    public ExtendedFingerprinter(int size, int searchDepth) {
        this.fingerprinter = new Fingerprinter(size - 25, searchDepth);
    }

    @Override
    @TestMethod(value="testGetFingerprint_IAtomContainer")
    public BitSet getFingerprint(IAtomContainer container) throws CDKException {
        return this.getFingerprint(container, null, null);
    }

    @TestMethod(value="testGetFingerprint_IAtomContainer_IRingSet_List")
    public BitSet getFingerprint(IAtomContainer atomContainer, IRingSet ringSet, List<IRingSet> rslist) throws CDKException {
        int i;
        int i2;
        IAtomContainer container;
        try {
            container = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone input");
        }
        BitSet bitSet = this.fingerprinter.getFingerprint(container);
        int size = this.getSize();
        double weight = MolecularFormulaManipulator.getTotalNaturalAbundance(MolecularFormulaManipulator.getMolecularFormula(container));
        for (i2 = 1; i2 < 11; ++i2) {
            if (!(weight > (double)(100 * i2))) continue;
            bitSet.set(size - 26 + i2);
        }
        if (ringSet == null) {
            ringSet = new SSSRFinder(container).findSSSR();
            rslist = RingPartitioner.partitionRings(ringSet);
        }
        for (i2 = 0; i2 < 7; ++i2) {
            if (ringSet.getAtomContainerCount() <= i2) continue;
            bitSet.set(size - 15 + i2);
        }
        int maximumringsystemsize = 0;
        for (i = 0; i < rslist.size(); ++i) {
            if (rslist.get(i).getAtomContainerCount() <= maximumringsystemsize) continue;
            maximumringsystemsize = rslist.get(i).getAtomContainerCount();
        }
        for (i = 0; i < maximumringsystemsize && i < 9; ++i) {
            bitSet.set(size - 8 + i - 3);
        }
        return bitSet;
    }

    @Override
    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.fingerprinter.getSize() + 25;
    }
}

