/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.acceptance;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.acceptance.TestDatabaseModes;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.InfModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;

public class AllAccept
extends AssemblerTestBase {
    public AllAccept(String name) {
        super(name);
    }

    public static TestSuite suite() {
        TestSuite result = new TestSuite();
        result.addTestSuite(AllAccept.class);
        result.addTest((Test)new SetupDatabase((Test)new TestSuite(TestDatabaseModes.class)));
        return result;
    }

    public void testUnadornedInferenceModel() {
        Resource root = this.resourceInModel("x ja:reasoner R; R rdf:type ja:ReasonerFactory");
        Model m = Assembler.general.openModel(root);
        AllAccept.assertInstanceOf(InfModel.class, (Object)m);
        InfModel inf = (InfModel)m;
        AllAccept.assertIsoModels((Model)empty, (Model)inf.getRawModel());
        AllAccept.assertInstanceOf(GenericRuleReasoner.class, (Object)inf.getReasoner());
    }

    public void testWithContent() throws IOException {
        File f = FileUtils.tempFileName("assembler-acceptance-", ".n3");
        Model data = this.model("a P b; b Q c");
        FileOutputStream fs = new FileOutputStream(f);
        data.write(fs, "N3");
        fs.close();
        Resource root = this.resourceInModel("x rdf:type ja:MemoryModel; x ja:content y; y ja:externalContent file:" + f.getAbsolutePath());
        Model m = Assembler.general.openModel(root);
        AllAccept.assertIsoModels((Model)data, (Model)m);
    }

    public static class SetupDatabase
    extends TestSetup {
        public SetupDatabase(Test tests) {
            super(tests);
        }

        public void setUp() throws Exception {
            super.setUp();
            IDBConnection conn = TestConnection.makeAndCleanTestConnection();
            ModelRDB.createModel(conn, "square");
            ModelRDB.createModel(conn, "circle");
            ModelRDB.createModel(conn, "triangle");
            ModelRDB.createModel(conn, "hex");
            conn.close();
            IDBConnection x = ModelFactory.createSimpleRDBConnection();
            SetupDatabase.assertEquals((boolean)true, (boolean)x.containsModel("square"));
            SetupDatabase.assertEquals((boolean)false, (boolean)x.containsModel("line"));
            x.close();
        }
    }
}

