/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;

public class HalogenCountDescriptor
implements IMolecularDescriptor {
    public static final String[] names = new String[]{"nF", "nCl", "nBr", "nI", "nX"};

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("nX", this.getClass().getName(), "$Id: HalogenCountDescriptor.java 1 2010-05-01 22:05:01Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        if (iAtomContainer == null) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer was NULL"));
        }
        if (iAtomContainer.getAtomCount() == 0) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), new CDKException("The supplied AtomContainer did not have any atoms"));
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
            if (iAtomContainer.getAtom(i).getSymbol().equals("F")) {
                ++n;
                continue;
            }
            if (iAtomContainer.getAtom(i).getSymbol().equals("Cl")) {
                ++n2;
                continue;
            }
            if (iAtomContainer.getAtom(i).getSymbol().equals("Br")) {
                ++n3;
                continue;
            }
            if (iAtomContainer.getAtom(i).getSymbol().equals("I")) {
                ++n4;
                continue;
            }
            if (!iAtomContainer.getAtom(i).getSymbol().equals("At") && !iAtomContainer.getAtom(i).getSymbol().equals("Uus")) continue;
            ++n5;
        }
        n5 += n + n2 + n3 + n4;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        doubleArrayResult.add(n);
        doubleArrayResult.add(n2);
        doubleArrayResult.add(n3);
        doubleArrayResult.add(n4);
        doubleArrayResult.add(n5);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(names.length);
    }
}

