/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.processors.batch;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IBatchProcessor;
import ambit2.base.interfaces.IBatchStatistics;
import ambit2.base.interfaces.IProcessor;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.base.processors.ProcessorsChain;
import ambit2.base.processors.batch.DefaultBatchStatistics;
import java.util.Iterator;

public abstract class BatchProcessor<INPUT, Target>
extends DefaultAmbitProcessor<INPUT, IBatchStatistics>
implements IBatchProcessor<INPUT, Target, IBatchStatistics> {
    public static String PROPERTY_BATCHSTATS = "ambit2.core.processors.batch.IBatchStatistics";
    protected ProcessorsChain<Target, IBatchStatistics, IProcessor> processor;
    protected boolean cancelled = false;
    protected long timeout = 0L;
    private static final long serialVersionUID = -5659435501205598414L;

    public BatchProcessor() {
        this(null);
    }

    public BatchProcessor(ProcessorsChain<Target, IBatchStatistics, IProcessor> processorsChain) {
        this.setProcessorChain(processorsChain);
    }

    @Override
    public ProcessorsChain<Target, IBatchStatistics, IProcessor> getProcessorChain() {
        return this.processor;
    }

    @Override
    public void setProcessorChain(ProcessorsChain<Target, IBatchStatistics, IProcessor> processorsChain) {
        this.processor = processorsChain;
    }

    protected abstract void closeIterator(Iterator var1) throws AmbitException;

    @Override
    public IBatchStatistics process(INPUT INPUT) throws AmbitException {
        try {
            DefaultBatchStatistics defaultBatchStatistics = new DefaultBatchStatistics();
            defaultBatchStatistics.setResultCaption("Read");
            defaultBatchStatistics.frequency = 1L;
            Iterator iterator = this.getIterator(INPUT);
            ProcessorsChain<Object, IBatchStatistics, IProcessor> processorsChain = this.getProcessorChain();
            if (processorsChain == null) {
                throw new AmbitException("Processor not defined");
            }
            long l = System.currentTimeMillis();
            while (iterator.hasNext() && !this.cancelled) {
                if (defaultBatchStatistics.getRecords(IBatchStatistics.RECORDS_STATS.RECORDS_READ) % defaultBatchStatistics.frequency == 0L) {
                    this.propertyChangeSupport.firePropertyChange(PROPERTY_BATCHSTATS, null, defaultBatchStatistics);
                }
                Object Target = null;
                long l2 = System.currentTimeMillis();
                try {
                    Target = iterator.next();
                    defaultBatchStatistics.increment(IBatchStatistics.RECORDS_STATS.RECORDS_READ);
                    defaultBatchStatistics.incrementTimeElapsed(IBatchStatistics.RECORDS_STATS.RECORDS_READ, System.currentTimeMillis() - l2);
                }
                catch (Exception exception) {
                    defaultBatchStatistics.increment(IBatchStatistics.RECORDS_STATS.RECORDS_ERROR);
                    defaultBatchStatistics.incrementTimeElapsed(IBatchStatistics.RECORDS_STATS.RECORDS_ERROR, System.currentTimeMillis() - l2);
                    continue;
                }
                l2 = System.currentTimeMillis();
                try {
                    processorsChain.process(Target);
                    defaultBatchStatistics.increment(IBatchStatistics.RECORDS_STATS.RECORDS_PROCESSED);
                    defaultBatchStatistics.incrementTimeElapsed(IBatchStatistics.RECORDS_STATS.RECORDS_PROCESSED, System.currentTimeMillis() - l2);
                }
                catch (Exception exception) {
                    defaultBatchStatistics.increment(IBatchStatistics.RECORDS_STATS.RECORDS_ERROR);
                    defaultBatchStatistics.incrementTimeElapsed(IBatchStatistics.RECORDS_STATS.RECORDS_ERROR, System.currentTimeMillis() - l2);
                    continue;
                }
                long l3 = System.currentTimeMillis() - l;
                if (this.timeout <= 0L || l3 <= this.timeout) continue;
                defaultBatchStatistics.increment(IBatchStatistics.RECORDS_STATS.RECORDS_ERROR);
                defaultBatchStatistics.incrementTimeElapsed(IBatchStatistics.RECORDS_STATS.RECORDS_ERROR, System.currentTimeMillis() - l2);
                break;
            }
            this.propertyChangeSupport.firePropertyChange(PROPERTY_BATCHSTATS, null, defaultBatchStatistics);
            this.closeIterator(iterator);
            return defaultBatchStatistics;
        }
        catch (Exception exception) {
            throw new AmbitException(exception);
        }
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public void setTimeout(long l) {
        this.timeout = l;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }
}

