/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.smiles;

import ambit2.core.data.MoleculeTools;
import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.RingManipulator;

@TestClass(value="org.openscience.cdk.smiles.DeduceBondSystemToolTest")
public class DeduceBondSystemTool {
    protected long timeout = 100000L;
    private AllRingsFinder allRingsFinder;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(DeduceBondSystemTool.class);
    private List<Integer[]> listOfRings = null;
    private boolean interrupted;

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public DeduceBondSystemTool() {
        this.allRingsFinder = new AllRingsFinder();
    }

    public DeduceBondSystemTool(AllRingsFinder allRingsFinder) {
        this.allRingsFinder = allRingsFinder;
    }

    public boolean isOK(IMolecule iMolecule) throws CDKException {
        IRingSet iRingSet = this.allRingsFinder.findAllRings((IAtomContainer)iMolecule, Integer.valueOf(7));
        this.storeRingSystem(iMolecule, iRingSet);
        boolean bl = this.isStructureOK(iMolecule);
        IRingSet iRingSet2 = this.removeExtraRings(iMolecule);
        if (iRingSet2 == null) {
            throw new CDKException("error in AllRingsFinder.findAllRings");
        }
        int n = this.getBadCount(iMolecule, iRingSet2);
        return bl && n == 0;
    }

    @TestMethod(value="xtestQuinone,xtestPyrrole")
    public IMolecule fixAromaticBondOrders(IMolecule iMolecule) throws CDKException {
        IMolecule iMolecule2;
        Object object;
        IRingSet iRingSet = this.allRingsFinder.findAllRings((IAtomContainer)iMolecule, Integer.valueOf(7));
        this.storeRingSystem(iMolecule, iRingSet);
        IRingSet iRingSet2 = this.removeExtraRings(iMolecule);
        if (iRingSet2 == null) {
            throw new CDKException("failure in AllRingsFinder.findAllRings");
        }
        ArrayList arrayList = new ArrayList();
        this.FixPyridineNOxides(iMolecule, iRingSet2);
        for (int i = 0; i <= iRingSet2.getAtomContainerCount() - 1; ++i) {
            object = (IRing)iRingSet2.getAtomContainer(i);
            if (object.getAtomCount() == 5) {
                this.fiveMemberedRingPossibilities(iMolecule, (IRing)object, arrayList);
                continue;
            }
            if (object.getAtomCount() == 6) {
                this.sixMemberedRingPossibilities(iMolecule, (IRing)object, arrayList);
                continue;
            }
            if (object.getAtomCount() == 7) {
                this.sevenMemberedRingPossibilities(iMolecule, (IRing)object, arrayList);
                continue;
            }
            logger.debug((Object)("Found ring of size: " + object.getAtomCount()));
        }
        IMoleculeSet iMoleculeSet = MoleculeTools.newMoleculeSet(iMolecule.getBuilder());
        object = new int[arrayList.size()];
        if (arrayList.size() > 0 && (iMolecule2 = this.loop(System.currentTimeMillis(), iMolecule, 0, arrayList, (int[])object, iMoleculeSet, 0)) != null) {
            return iMolecule2;
        }
        int n = 99999999;
        int n2 = -1;
        for (int i = 0; i <= iMoleculeSet.getAtomContainerCount() - 1; ++i) {
            int n3;
            IMolecule iMolecule3 = iMoleculeSet.getMolecule(i);
            iRingSet2 = this.removeExtraRings(iMolecule3);
            if (iRingSet2 == null || (n3 = this.getBadCount(iMolecule3, iRingSet2)) >= n) continue;
            n = n3;
            n2 = i;
        }
        if (iMoleculeSet.getAtomContainerCount() > 0) {
            return iMoleculeSet.getMolecule(n2);
        }
        return iMolecule;
    }

    private void FixPyridineNOxides(IMolecule iMolecule, IRingSet iRingSet) {
        for (int i = 0; i < iMolecule.getAtomCount(); ++i) {
            IAtom iAtom = iMolecule.getAtom(i);
            if (!iAtom.getSymbol().equals("N") || iAtom.getFormalCharge() != null && iAtom.getFormalCharge() != 0 || !this.inRingSet(iAtom, iRingSet)) continue;
            List list = iMolecule.getConnectedAtomsList(iAtom);
            for (IAtom iAtom2 : list) {
                if (!iAtom2.getSymbol().equals("O") || iMolecule.getBond(iAtom, iAtom2).getOrder() != IBond.Order.DOUBLE) continue;
                iAtom.setFormalCharge(Integer.valueOf(1));
                iAtom2.setFormalCharge(Integer.valueOf(-1));
                iMolecule.getBond(iAtom, iAtom2).setOrder(IBond.Order.SINGLE);
            }
        }
    }

    private void applyBonds(IMolecule iMolecule, ArrayList arrayList) {
        for (int i = 0; i <= arrayList.size() - 1; ++i) {
            String string = (String)arrayList.get(i);
            String string2 = string.substring(0, string.indexOf("-"));
            String string3 = string.substring(string.indexOf("-") + 1, string.length());
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            IBond iBond = iMolecule.getBond(iMolecule.getAtom(n), iMolecule.getAtom(n2));
            iBond.setOrder(IBond.Order.DOUBLE);
        }
    }

    private void fiveMemberedRingPossibilities(IMolecule iMolecule, IRing iRing, List list) {
        int[] nArray = new int[5];
        for (int i = 0; i <= 4; ++i) {
            nArray[i] = iMolecule.getAtomNumber(iRing.getAtom(i));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = new ArrayList<String>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        ArrayList<String> arrayList10 = new ArrayList<String>();
        arrayList.add(nArray[1] + "-" + nArray[2]);
        arrayList.add(nArray[3] + "-" + nArray[4]);
        arrayList2.add(nArray[2] + "-" + nArray[3]);
        arrayList2.add(nArray[0] + "-" + nArray[4]);
        arrayList3.add(nArray[0] + "-" + nArray[1]);
        arrayList3.add(nArray[3] + "-" + nArray[4]);
        arrayList4.add(nArray[0] + "-" + nArray[4]);
        arrayList4.add(nArray[1] + "-" + nArray[2]);
        arrayList5.add(nArray[0] + "-" + nArray[1]);
        arrayList5.add(nArray[2] + "-" + nArray[3]);
        arrayList6.add(nArray[0] + "-" + nArray[1]);
        arrayList7.add(nArray[1] + "-" + nArray[2]);
        arrayList8.add(nArray[2] + "-" + nArray[3]);
        arrayList9.add(nArray[3] + "-" + nArray[4]);
        arrayList10.add(nArray[4] + "-" + nArray[0]);
        ArrayList<ArrayList<String>> arrayList11 = new ArrayList<ArrayList<String>>();
        arrayList11.add(arrayList);
        arrayList11.add(arrayList2);
        arrayList11.add(arrayList3);
        arrayList11.add(arrayList4);
        arrayList11.add(arrayList5);
        arrayList11.add(arrayList6);
        arrayList11.add(arrayList7);
        arrayList11.add(arrayList8);
        arrayList11.add(arrayList9);
        arrayList11.add(arrayList10);
        list.add(arrayList11);
    }

    private void sixMemberedRingPossibilities(IMolecule iMolecule, IRing iRing, List list) {
        IAtom[] iAtomArray = new IAtom[6];
        iAtomArray[0] = iRing.getAtom(0);
        int[] nArray = new int[6];
        for (int i = 0; i <= 5; ++i) {
            nArray[i] = iMolecule.getAtomNumber(iRing.getAtom(i));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList.add(nArray[0] + "-" + nArray[1]);
        arrayList.add(nArray[2] + "-" + nArray[3]);
        arrayList.add(nArray[4] + "-" + nArray[5]);
        arrayList2.add(nArray[1] + "-" + nArray[2]);
        arrayList2.add(nArray[3] + "-" + nArray[4]);
        arrayList2.add(nArray[5] + "-" + nArray[0]);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        ArrayList<String> arrayList8 = new ArrayList<String>();
        ArrayList<String> arrayList9 = new ArrayList<String>();
        ArrayList<String> arrayList10 = new ArrayList<String>();
        ArrayList<String> arrayList11 = new ArrayList<String>();
        ArrayList<String> arrayList12 = new ArrayList<String>();
        ArrayList<String> arrayList13 = new ArrayList<String>();
        ArrayList<String> arrayList14 = new ArrayList<String>();
        ArrayList<String> arrayList15 = new ArrayList<String>();
        ArrayList<String> arrayList16 = new ArrayList<String>();
        ArrayList<String> arrayList17 = new ArrayList<String>();
        ArrayList arrayList18 = new ArrayList();
        arrayList3.add(nArray[0] + "-" + nArray[1]);
        arrayList3.add(nArray[2] + "-" + nArray[3]);
        arrayList4.add(nArray[0] + "-" + nArray[1]);
        arrayList4.add(nArray[4] + "-" + nArray[5]);
        arrayList5.add(nArray[1] + "-" + nArray[2]);
        arrayList5.add(nArray[3] + "-" + nArray[4]);
        arrayList6.add(nArray[1] + "-" + nArray[2]);
        arrayList6.add(nArray[0] + "-" + nArray[5]);
        arrayList7.add(nArray[2] + "-" + nArray[3]);
        arrayList7.add(nArray[4] + "-" + nArray[5]);
        arrayList8.add(nArray[0] + "-" + nArray[5]);
        arrayList8.add(nArray[3] + "-" + nArray[4]);
        arrayList9.add(nArray[0] + "-" + nArray[1]);
        arrayList9.add(nArray[3] + "-" + nArray[4]);
        arrayList10.add(nArray[1] + "-" + nArray[2]);
        arrayList10.add(nArray[4] + "-" + nArray[5]);
        arrayList11.add(nArray[2] + "-" + nArray[3]);
        arrayList11.add(nArray[0] + "-" + nArray[5]);
        arrayList12.add(nArray[0] + "-" + nArray[1]);
        arrayList13.add(nArray[1] + "-" + nArray[2]);
        arrayList14.add(nArray[2] + "-" + nArray[3]);
        arrayList15.add(nArray[3] + "-" + nArray[4]);
        arrayList16.add(nArray[4] + "-" + nArray[5]);
        arrayList17.add(nArray[5] + "-" + nArray[0]);
        ArrayList arrayList19 = new ArrayList();
        arrayList19.add(arrayList);
        arrayList19.add(arrayList2);
        arrayList19.add(arrayList3);
        arrayList19.add(arrayList4);
        arrayList19.add(arrayList5);
        arrayList19.add(arrayList6);
        arrayList19.add(arrayList7);
        arrayList19.add(arrayList8);
        arrayList19.add(arrayList9);
        arrayList19.add(arrayList10);
        arrayList19.add(arrayList11);
        arrayList19.add(arrayList12);
        arrayList19.add(arrayList13);
        arrayList19.add(arrayList14);
        arrayList19.add(arrayList15);
        arrayList19.add(arrayList16);
        arrayList19.add(arrayList17);
        arrayList19.add(arrayList18);
        list.add(arrayList19);
    }

    private void sevenMemberedRingPossibilities(IMolecule iMolecule, IRing iRing, List list) {
        IAtom[] iAtomArray = new IAtom[7];
        iAtomArray[0] = iRing.getAtom(0);
        int[] nArray = new int[7];
        for (int i = 0; i <= 6; ++i) {
            nArray[i] = iMolecule.getAtomNumber(iRing.getAtom(i));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        arrayList.add(nArray[0] + "-" + nArray[1]);
        arrayList.add(nArray[2] + "-" + nArray[3]);
        arrayList.add(nArray[4] + "-" + nArray[5]);
        arrayList2.add(nArray[0] + "-" + nArray[1]);
        arrayList2.add(nArray[2] + "-" + nArray[3]);
        arrayList2.add(nArray[5] + "-" + nArray[6]);
        arrayList3.add(nArray[1] + "-" + nArray[2]);
        arrayList3.add(nArray[3] + "-" + nArray[4]);
        arrayList3.add(nArray[5] + "-" + nArray[6]);
        arrayList4.add(nArray[1] + "-" + nArray[2]);
        arrayList4.add(nArray[3] + "-" + nArray[4]);
        arrayList4.add(nArray[6] + "-" + nArray[0]);
        arrayList5.add(nArray[2] + "-" + nArray[3]);
        arrayList5.add(nArray[4] + "-" + nArray[5]);
        arrayList5.add(nArray[6] + "-" + nArray[0]);
        ArrayList<ArrayList<String>> arrayList6 = new ArrayList<ArrayList<String>>();
        arrayList6.add(arrayList);
        arrayList6.add(arrayList2);
        arrayList6.add(arrayList3);
        arrayList6.add(arrayList4);
        arrayList6.add(arrayList5);
        list.add(arrayList6);
    }

    private int getBadCount(IMolecule iMolecule, IRingSet iRingSet) {
        int n = 0;
        for (int i = 0; i <= iMolecule.getAtomCount() - 1; ++i) {
            IAtom iAtom = iMolecule.getAtom(i);
            if (!this.inRingSet(iAtom, iRingSet)) continue;
            if (iAtom.getSymbol().equals("N")) {
                if (iAtom.getFormalCharge() == 0) {
                    if (iMolecule.getBondOrderSum(iAtom) == 4.0) {
                        ++n;
                        continue;
                    }
                    if (iMolecule.getBondOrderSum(iAtom) != 5.0) continue;
                    int n2 = 0;
                    List list = iMolecule.getConnectedAtomsList(iAtom);
                    for (int j = 0; j <= list.size() - 1; ++j) {
                        if (iMolecule.getBond(iAtom, (IAtom)list.get(j)).getOrder() != IBond.Order.DOUBLE || !this.inRingSet((IAtom)list.get(j), iRingSet)) continue;
                        ++n2;
                    }
                    if (n2 != 2) continue;
                    ++n;
                    continue;
                }
                if (iAtom.getFormalCharge() != 1 || iMolecule.getBondOrderSum(iAtom) != 5.0) continue;
                ++n;
                continue;
            }
            if (!iAtom.getSymbol().equals("S") || !(iMolecule.getBondOrderSum(iAtom) > 2.0)) continue;
            ++n;
        }
        return n;
    }

    private boolean inRingSet(IAtom iAtom, IRingSet iRingSet) {
        for (int i = 0; i < iRingSet.getAtomContainerCount(); ++i) {
            IRing iRing = (IRing)iRingSet.getAtomContainer(i);
            if (!iRing.contains(iAtom)) continue;
            return true;
        }
        return false;
    }

    private IMolecule loop(long l, IMolecule iMolecule, int n, List list, int[] nArray, IMoleculeSet iMoleculeSet, int n2) throws CDKException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (l3 > this.timeout) {
            throw new CDKException(String.format("Timed out after %s ms.", this.timeout));
        }
        if (this.interrupted) {
            throw new CDKException("Process was interrupted.");
        }
        ArrayList arrayList = (ArrayList)list.get(n);
        IMolecule iMolecule2 = null;
        for (int i = 0; i <= arrayList.size() - 1; ++i) {
            nArray[n] = i;
            if (n == list.size() - 1) {
                IRingSet iRingSet;
                IMolecule iMolecule3 = null;
                try {
                    iMolecule3 = (IMolecule)iMolecule.clone();
                }
                catch (Exception exception) {
                    logger.error((Object)"Failed to clone molecule: ", new Object[]{exception.getMessage()});
                    logger.debug((Object)exception);
                }
                for (int j = 0; j <= list.size() - 1; ++j) {
                    ArrayList arrayList2 = (ArrayList)list.get(j);
                    ArrayList arrayList3 = (ArrayList)arrayList2.get(nArray[j]);
                    this.applyBonds(iMolecule3, arrayList3);
                }
                if (this.isStructureOK(iMolecule3) && (iRingSet = this.removeExtraRings(iMolecule3)) != null) {
                    int n3 = this.getBadCount(iMolecule3, iRingSet);
                    if (n3 == 0) {
                        return iMolecule3;
                    }
                    iMoleculeSet.addMolecule(iMolecule3);
                }
            }
            if (n + 1 <= list.size() - 1) {
                iMolecule2 = this.loop(l, iMolecule, n + 1, list, nArray, iMoleculeSet, n2 + 1);
            }
            if (!(iMolecule2 instanceof IMolecule)) continue;
            return iMolecule2;
        }
        return null;
    }

    private boolean isStructureOK(IMolecule iMolecule) {
        try {
            IRing iRing;
            int n;
            IAtom iAtom2;
            CDKAtomTypeMatcher cDKAtomTypeMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)iMolecule.getBuilder());
            for (IAtom iAtom2 : iMolecule.atoms()) {
                IAtomType iAtomType = cDKAtomTypeMatcher.findMatchingAtomType((IAtomContainer)iMolecule, iAtom2);
                if (iAtomType != null) continue;
                return false;
            }
            iAtom2 = this.recoverRingSystem(iMolecule);
            for (n = 0; n <= iMolecule.getAtomCount() - 1; ++n) {
                iMolecule.getAtom(n).setFlag(5, false);
            }
            for (n = 0; n <= iAtom2.getAtomContainerCount() - 1; ++n) {
                iRing = (IRing)iAtom2.getAtomContainer(n);
                iRing.setFlag(5, false);
            }
            CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)iMolecule);
            for (n = 0; n <= iAtom2.getAtomContainerCount() - 1; ++n) {
                iRing = (IRing)iAtom2.getAtomContainer(n);
                RingManipulator.markAromaticRings((IRing)iRing);
            }
            boolean[] blArray = this.findRingsToCheck((IRingSet)iAtom2);
            for (int i = 0; i <= iAtom2.getAtomContainerCount() - 1; ++i) {
                IRing iRing2 = (IRing)iAtom2.getAtomContainer(i);
                if (!blArray[i]) continue;
                for (int j = 0; j <= iRing2.getAtomCount() - 1; ++j) {
                    if (iRing2.getAtom(j).getImplicitHydrogenCount() == CDKConstants.UNSET || iRing2.getAtom(j).getImplicitHydrogenCount() >= 0) continue;
                    return false;
                }
                if (iRing2.getFlag(5)) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            logger.debug((Object)exception.toString());
            return false;
        }
    }

    private IRingSet removeExtraRings(IMolecule iMolecule) {
        try {
            SSSRFinder sSSRFinder = new SSSRFinder((IAtomContainer)iMolecule);
            IRingSet iRingSet = sSSRFinder.findSSSR();
            block2: for (int i = 0; i <= iRingSet.getAtomContainerCount() - 1; ++i) {
                IRing iRing = (IRing)iRingSet.getAtomContainer(i);
                if (iRing.getAtomCount() > 7 || iRing.getAtomCount() < 5) {
                    iRingSet.removeAtomContainer(i);
                    --i;
                    continue;
                }
                for (int j = 0; j <= iRing.getAtomCount() - 1; ++j) {
                    if (iRing.getAtom(j).getHybridization() != CDKConstants.UNSET && (iRing.getAtom(j).getHybridization() == IAtomType.Hybridization.SP2 || iRing.getAtom(j).getHybridization() == IAtomType.Hybridization.PLANAR3)) continue;
                    iRingSet.removeAtomContainer(i);
                    --i;
                    continue block2;
                }
            }
            return iRingSet;
        }
        catch (Exception exception) {
            return new RingSet();
        }
    }

    private boolean[] findRingsToCheck(IRingSet iRingSet) {
        int n;
        boolean[] blArray = new boolean[iRingSet.getAtomContainerCount()];
        for (n = 0; n <= blArray.length - 1; ++n) {
            blArray[n] = true;
        }
        block1: for (n = 0; n <= iRingSet.getAtomContainerCount() - 1; ++n) {
            IRing iRing = (IRing)iRingSet.getAtomContainer(n);
            if (iRing.getAtomCount() > 7) {
                blArray[n] = false;
                continue;
            }
            int n2 = 0;
            for (int i = 0; i <= iRing.getAtomCount() - 1; ++i) {
                if (iRing.getAtom(i).getHybridization() != CDKConstants.UNSET && iRing.getAtom(i).getHybridization() == IAtomType.Hybridization.SP2) continue;
                ++n2;
                if (!iRing.getAtom(i).getSymbol().equals("C")) continue;
                blArray[n] = false;
                continue block1;
            }
            if (n2 <= true) continue;
            blArray[n] = false;
        }
        return blArray;
    }

    private void storeRingSystem(IMolecule iMolecule, IRingSet iRingSet) {
        this.listOfRings = new ArrayList<Integer[]>();
        for (int i = 0; i < iRingSet.getAtomContainerCount(); ++i) {
            IRing iRing = (IRing)iRingSet.getAtomContainer(i);
            Integer[] integerArray = new Integer[iRing.getBondCount()];
            for (int j = 0; j < iRing.getBondCount(); ++j) {
                integerArray[j] = iMolecule.getBondNumber(iRing.getBond(j));
            }
            this.listOfRings.add(integerArray);
        }
    }

    private IRingSet recoverRingSystem(IMolecule iMolecule) {
        IRingSet iRingSet = MoleculeTools.newRingSet(iMolecule.getBuilder());
        for (Integer[] integerArray : this.listOfRings) {
            IRing iRing = MoleculeTools.newRing(iMolecule.getBuilder(), integerArray.length);
            Integer[] integerArray2 = integerArray;
            int n = integerArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = integerArray2[i];
                IBond iBond = iMolecule.getBond(n2);
                iRing.addBond(iBond);
                if (!iRing.contains(iBond.getAtom(0))) {
                    iRing.addAtom(iBond.getAtom(0));
                }
                if (iRing.contains(iBond.getAtom(1))) continue;
                iRing.addAtom(iBond.getAtom(1));
            }
            iRingSet.addAtomContainer((IAtomContainer)iRing);
        }
        return iRingSet;
    }

    public void setInterrupted(boolean bl) {
        this.interrupted = bl;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }
}

