/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure.key;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.processors.structure.key.IStructureKey;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SmilesKey
extends DefaultAmbitProcessor<IAtomContainer, String>
implements IStructureKey<IAtomContainer, String> {
    private static final long serialVersionUID = 8319267963784553472L;
    protected SmilesGenerator gen = new SmilesGenerator(true);
    protected Object key = "smiles";

    @Override
    public Object getKey() {
        return this.key;
    }

    public void setKey(Object object) {
        this.key = object;
    }

    public String process(IAtomContainer iAtomContainer) throws AmbitException {
        if (iAtomContainer == null || iAtomContainer.getAtomCount() == 0) {
            throw new AmbitException("Empty molecule!");
        }
        IAtomContainer iAtomContainer2 = null;
        try {
            iAtomContainer2 = (IAtomContainer)iAtomContainer.clone();
            iAtomContainer2 = AtomContainerManipulator.removeHydrogensPreserveMultiplyBonded((IAtomContainer)iAtomContainer2);
            return this.gen.createSMILES((IAtomContainer)((IMolecule)iAtomContainer2), false, new boolean[iAtomContainer2.getAtomCount()]);
        }
        catch (CDKException cDKException) {
            logger.warn((Object)cDKException);
            return this.gen.createSMILES((IAtomContainer)((IMolecule)iAtomContainer2));
        }
        catch (Exception exception) {
            throw new AmbitException((Throwable)exception);
        }
    }

    @Override
    public Object getQueryKey() {
        return "smiles";
    }

    @Override
    public Class getType() {
        return String.class;
    }
}

