/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.io.FileWithHeaderWriter;
import ambit2.core.io.XLSFileFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.formats.IResourceFormat;

public class XLSFileWriter
extends FileWithHeaderWriter {
    protected HSSFWorkbook workbook = new HSSFWorkbook();
    protected HSSFSheet sheet = this.workbook.createSheet();
    protected HSSFDataFormat dataformat = this.workbook.createDataFormat();
    protected HSSFCellStyle style = this.workbook.createCellStyle();
    protected OutputStream out;
    protected boolean writingStarted = false;

    public XLSFileWriter(OutputStream outputStream) throws Exception {
        this.style.setDataFormat(this.dataformat.getFormat("0.00"));
        this.out = outputStream;
    }

    @Override
    protected void writeHeader() throws IOException {
        HSSFRow hSSFRow = this.sheet.createRow(0);
        for (int i = 0; i < this.header.size(); ++i) {
            hSSFRow.createCell((short)(i + 1)).setCellValue(this.header.list.get(i).toString());
        }
        logger.debug((Object)"\tHeader written\t", new Object[]{this.header});
    }

    @Override
    public void writeMolecule(IMolecule iMolecule) {
        try {
            if (!this.writingStarted) {
                if (this.header == null) {
                    this.setHeader(iMolecule.getProperties());
                }
                this.writeHeader();
                this.writingStarted = true;
            }
            HSSFRow hSSFRow = this.sheet.createRow((int)((short)(this.sheet.getLastRowNum() + 1)));
            for (int i = 0; i < this.header.size(); ++i) {
                Object object = iMolecule.getProperty(this.header.list.get(i));
                if (i == this.smilesIndex && object == null) {
                    try {
                        object = this.sg.createSMILES((IAtomContainer)iMolecule);
                    }
                    catch (Exception exception) {
                        logger.error((Object)"Error while createSMILES\t", new Object[]{exception.getMessage()});
                        object = "";
                    }
                }
                if (object == null) continue;
                HSSFCell hSSFCell = hSSFRow.createCell((short)(i + 1));
                if (object instanceof Number) {
                    hSSFCell.setCellStyle(this.style);
                    hSSFCell.setCellType(0);
                    hSSFCell.setCellValue(((Number)object).doubleValue());
                    continue;
                }
                try {
                    double d = Double.parseDouble(object.toString());
                    hSSFCell.setCellStyle(this.style);
                    hSSFCell.setCellType(0);
                    hSSFCell.setCellValue(d);
                    continue;
                }
                catch (Exception exception) {
                    hSSFCell.setCellType(1);
                    hSSFCell.setCellValue(object.toString());
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"ERROR while writing Molecule: ", new Object[]{exception.getMessage()});
            logger.debug((Object)exception);
            exception.printStackTrace();
        }
    }

    public void setWriter(Writer writer) throws CDKException {
        throw new CDKException("Unsupported operation!");
    }

    public void setWriter(OutputStream outputStream) throws CDKException {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.out = outputStream;
    }

    public IResourceFormat getFormat() {
        return new XLSFileFormat();
    }

    public boolean accepts(Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (IChemFile.class.equals(classArray[i])) {
                return true;
            }
            if (IMoleculeSet.class.equals(classArray[i])) {
                return true;
            }
            if (!IMolecule.class.equals(classArray[i])) continue;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.workbook.write(this.out);
        this.out.close();
    }

    public String toString() {
        return " Microsoft Excel Workbook (.xls)";
    }
}

