/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.core.groups.ComponentGroup;
import ambit2.core.groups.ContainerGroup;
import ambit2.core.groups.DataGroup;
import ambit2.core.groups.GenericGroup;
import ambit2.core.groups.GroupException;
import ambit2.core.groups.GroupNotFoundException;
import ambit2.core.groups.ISGroup;
import ambit2.core.groups.MonomerGroup;
import ambit2.core.groups.MultipleGroup;
import ambit2.core.groups.StructureRepeatingUnit;
import ambit2.core.groups.SuperAtom;
import ambit2.core.groups.SuppleAtomContainer;
import ambit2.core.groups.UnsupportedGroupOperation;
import java.util.Hashtable;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class SGroupMDL2000Helper {
    public static SGROUP_LINE getValue(String string) throws IllegalArgumentException {
        return SGROUP_LINE.valueOf(string.substring(0, 6).replace(' ', '_'));
    }

    public static ISGroup createGroup(int n, SGROUP_TYPE sGROUP_TYPE) throws UnsupportedGroupOperation {
        switch (sGROUP_TYPE) {
            case SUP: {
                return new SuperAtom(sGROUP_TYPE.toString(), n);
            }
            case GEN: {
                return new GenericGroup(sGROUP_TYPE.toString(), n);
            }
            case SRU: {
                return new StructureRepeatingUnit(sGROUP_TYPE.toString(), n);
            }
            case MUL: {
                return new MultipleGroup(sGROUP_TYPE.toString(), n);
            }
            case MON: {
                return new MonomerGroup(sGROUP_TYPE.toString(), n);
            }
            case COM: {
                return new ComponentGroup(sGROUP_TYPE.toString(), n);
            }
            case MIX: {
                return new ContainerGroup(sGROUP_TYPE.toString(), n);
            }
            case FOR: {
                return new ContainerGroup(sGROUP_TYPE.toString(), n, ContainerGroup.SGROUP_MIXTURE.FORMULATION);
            }
            case COP: {
                return new ContainerGroup(sGROUP_TYPE.toString(), n, ContainerGroup.SGROUP_MIXTURE.COPOLYMER);
            }
            case DAT: {
                return new DataGroup(sGROUP_TYPE.toString(), n);
            }
        }
        throw new UnsupportedGroupOperation(sGROUP_TYPE.toString());
    }

    public static enum SGROUP_CONNECTIVITY {
        HH,
        HT,
        EU;

    }

    public static enum SGROUP_POLYMER_TYPE {
        ALT,
        RAN,
        BLO;

    }

    public static enum SGROUP_TYPE {
        SUP,
        MUL,
        SRU,
        MON,
        MER,
        COP,
        CRO,
        MOD,
        GRA,
        COM,
        MIX,
        FOR,
        DAT,
        ANY,
        GEN;

    }

    public static enum SGROUP_LINE {
        M__ALS{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  ALS");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                throw new GroupException("Not implemented " + (Object)((Object)this));
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new GroupException(this.toString());
            }
        }
        ,
        M__APO{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  APO");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 2);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new GroupException(this.toString());
            }
        }
        ,
        M__AAL{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  AAL");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                throw new GroupException("Not implemented " + (Object)((Object)this));
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new GroupException(this.toString());
            }
        }
        ,
        M__RGP{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  RGP");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 8);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                for (int i = 1; i < stringArray.length; i += 2) {
                    int n = Integer.parseInt(stringArray[i]) - 1;
                    IAtom iAtom = suppleAtomContainer.getAtom(n);
                    if (!(iAtom instanceof PseudoAtom)) {
                        throw new GroupException("Expected PseudoAtom but found " + iAtom.getSymbol());
                    }
                    ((PseudoAtom)iAtom).setLabel("R" + stringArray[i + 1]);
                }
            }
        }
        ,
        M__LOG{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  LOG");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                throw new GroupException("Not implemented " + (Object)((Object)this));
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new GroupException(this.toString());
            }
        }
        ,
        M__STY{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  STY");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 8);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                for (int i = 1; i < stringArray.length; i += 2) {
                    try {
                        ISGroup iSGroup = SGroupMDL2000Helper.createGroup(Integer.parseInt(stringArray[i]), SGROUP_TYPE.valueOf(stringArray[i + 1]));
                        if (iSGroup == null) continue;
                        hashtable.put(iSGroup.getNumber(), iSGroup);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        ,
        M__SST{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SST");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 8);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new UnsupportedGroupOperation(this.toString());
            }
        }
        ,
        M__SLB{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SLB");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 8);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new UnsupportedGroupOperation(this.toString());
            }
        }
        ,
        M__SCN{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SCN");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 8);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                int n = Integer.parseInt(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[i]));
                    if (iSGroup == null) {
                        throw new GroupNotFoundException(stringArray[1]);
                    }
                    iSGroup.setProperty("ambit2.groups.ISGroup.SGROUP_CONNECTIVITY", (Object)SGROUP_CONNECTIVITY.valueOf(stringArray[++i]));
                }
            }
        }
        ,
        M__SDS{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SDS");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                throw new UnsupportedGroupOperation("Not implemented " + (Object)((Object)this));
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new UnsupportedGroupOperation(this.toString());
            }
        }
        ,
        M__SAL{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SAL");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parseList(string, 15);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                for (int i = 2; i < stringArray.length; ++i) {
                    int n = Integer.parseInt(stringArray[i]) - 1;
                    suppleAtomContainer.addGroupAtom(iSGroup, suppleAtomContainer.getAtom(n));
                }
                iSGroup.finalizeAtomList((IAtomContainer)suppleAtomContainer);
            }
        }
        ,
        M__SBL{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SBL");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parseList(string, 15);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                for (int i = 2; i < stringArray.length; ++i) {
                    int n = Integer.parseInt(stringArray[i]) - 1;
                    suppleAtomContainer.addGroupBond(iSGroup, suppleAtomContainer.getBond(n));
                }
            }
        }
        ,
        M__SPA{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SPA");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parseList(string, 15);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                if (!(iSGroup instanceof MultipleGroup)) {
                    throw new UnsupportedGroupOperation("MultipleGroup expected!");
                }
                for (int i = 2; i < stringArray.length; ++i) {
                    int n = Integer.parseInt(stringArray[i]) - 1;
                    ((MultipleGroup)iSGroup).addParentAtom(suppleAtomContainer.getAtom(n));
                }
                ((MultipleGroup)iSGroup).finalizeParentAtomList((IAtomContainer)suppleAtomContainer);
            }
        }
        ,
        M__SMT{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SMT");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                String[] stringArray = new String[]{string.substring(7, 10).trim(), string.substring(11).trim()};
                return stringArray;
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                iSGroup.setSubscript(stringArray[1]);
            }
        }
        ,
        M__CRS{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  CRS");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                throw new GroupException("Not implemented " + (Object)((Object)this));
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new GroupException(this.toString());
            }
        }
        ,
        M__SDI{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SDI");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parseList(string, 4, 9);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                iSGroup.addBrackets(Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]), Double.parseDouble(stringArray[4]), Double.parseDouble(stringArray[5]));
            }
        }
        ,
        M__SBV{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SBV");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                int[] nArray = new int[]{11, 14, 24, 34};
                return this.parseByPosition(string, nArray);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
            }
        }
        ,
        M__SDT{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SDT");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                int[] nArray = new int[]{11, 41, 43, 63, 65};
                return this.parseByPosition(string, nArray);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                if (iSGroup instanceof DataGroup) {
                    DataGroup.SGROUP_FIELD[] sGROUP_FIELDArray = DataGroup.SGROUP_FIELD.values();
                    ((DataGroup)iSGroup).setName(stringArray[1]);
                    for (int i = 2; i < stringArray.length; ++i) {
                        iSGroup.setProperty((Object)sGROUP_FIELDArray[i - 2], stringArray[i]);
                    }
                } else {
                    new GroupException("Excepting DataGroup, found " + iSGroup.getClass().getName());
                }
            }
        }
        ,
        M__SDD{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SDD");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                int[] nArray = new int[]{11, 21, 31, 35, 36, 37, 38, 40, 44, 47, 50, 52, 54, 56};
                return this.parseByPosition(string, nArray);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                if (iSGroup instanceof DataGroup) {
                    DataGroup.DGROUP_DISPLAY[] dGROUP_DISPLAYArray = DataGroup.DGROUP_DISPLAY.values();
                    for (int i = 1; i < stringArray.length && i - 1 < dGROUP_DISPLAYArray.length; ++i) {
                        iSGroup.setProperty((Object)dGROUP_DISPLAYArray[i - 1], stringArray[i]);
                    }
                } else {
                    new GroupException("Excepting DataGroup, found " + iSGroup.getClass().getName());
                }
            }
        }
        ,
        M__SED{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SED");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                String[] stringArray = new String[]{string.substring(7, 10).trim(), string.substring(11).trim()};
                return stringArray;
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[0]));
                if (iSGroup == null) {
                    throw new GroupNotFoundException(stringArray[0]);
                }
                if (iSGroup instanceof DataGroup) {
                    if (DataGroup.MRV_MULTICENTER.equals(((DataGroup)iSGroup).getName())) {
                        ((DataGroup)iSGroup).setMulticenter(suppleAtomContainer.getAtom(Integer.parseInt(stringArray[1]) - 1));
                    }
                } else {
                    new GroupException("Excepting DataGroup, found " + iSGroup.getClass().getName());
                }
            }
        }
        ,
        M__$3D{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  $3D");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                throw new GroupException("Not implemented " + (Object)((Object)this));
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new GroupException(this.toString());
            }
        }
        ,
        M__SCD{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SCD");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                String[] stringArray = new String[]{string.substring(7, 10).trim(), string.substring(11).trim()};
                return stringArray;
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                throw new GroupException(this.toString());
            }
        }
        ,
        M__SPL{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SPL");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 8);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                int n = Integer.parseInt(stringArray[0]);
                for (int i = 1; i < stringArray.length; i += 2) {
                    ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[i]));
                    if (iSGroup == null) {
                        throw new GroupNotFoundException(stringArray[i]);
                    }
                    ISGroup iSGroup2 = hashtable.get(Integer.parseInt(stringArray[i + 1]));
                    if (iSGroup2 == null) {
                        throw new GroupNotFoundException(stringArray[i + 1]);
                    }
                    if (iSGroup2 instanceof ContainerGroup) {
                        ((ContainerGroup)iSGroup2).getComponents().add(iSGroup);
                        continue;
                    }
                    new GroupException("Excepting MixtureGroup, found " + iSGroup2.getClass().getName());
                }
            }
        }
        ,
        M__SNC{

            @Override
            public boolean isSgroupLine(String string) {
                return string.startsWith("M  SNC");
            }

            @Override
            protected String[] parse(String string) throws GroupException {
                return this.parsePairs(string, 8);
            }

            @Override
            public void updateSGroups(String string, SuppleAtomContainer suppleAtomContainer, Hashtable<Integer, ISGroup> hashtable) throws GroupException {
                String[] stringArray = this.parse(string);
                int n = Integer.parseInt(stringArray[0]);
                for (int i = 1; i < stringArray.length; i += 2) {
                    ISGroup iSGroup = hashtable.get(Integer.parseInt(stringArray[i]));
                    if (iSGroup == null) {
                        throw new GroupNotFoundException(stringArray[i]);
                    }
                    int n2 = Integer.parseInt(stringArray[i + 1]);
                    if (iSGroup instanceof ComponentGroup) {
                        ((ComponentGroup)iSGroup).setOrder(n2);
                        continue;
                    }
                    new GroupException("Excepting ComponentGroup, found " + iSGroup.getClass().getName());
                }
            }
        };


        public abstract boolean isSgroupLine(String var1);

        protected abstract String[] parse(String var1) throws GroupException;

        public abstract void updateSGroups(String var1, SuppleAtomContainer var2, Hashtable<Integer, ISGroup> var3) throws GroupException;

        protected String[] parsePairs(String string, int n) throws GroupException {
            int n2 = Integer.parseInt(string.substring(6, 9).trim());
            if (n2 > n * 2) {
                throw new GroupException("Max entries (" + n + ") exceeded (" + n2 + ")");
            }
            String[] stringArray = new String[n2 * 2 + 1];
            stringArray[0] = string.substring(6, 9).trim();
            int n3 = 9;
            for (int i = 1; i < n2 * 2 + 1; ++i) {
                stringArray[i] = string.substring(++n3, n3 + 3).trim();
                n3 += 3;
            }
            return stringArray;
        }

        protected String[] parseList(String string, int n) throws GroupException {
            return this.parseList(string, n, 3);
        }

        protected String[] parseList(String string, int n, int n2) throws GroupException {
            String string2 = string.substring(7, 10).trim();
            String string3 = string.substring(10, 13).trim();
            int n3 = Integer.parseInt(string3);
            if (n3 > n) {
                throw new GroupException("Max entries (" + n + ") exceeded (" + n3 + ")");
            }
            String[] stringArray = new String[n3 + 2];
            stringArray[0] = string2;
            stringArray[1] = string3;
            int n4 = 13;
            for (int i = 2; i < n3 + 2; ++i) {
                stringArray[i] = string.substring(++n4, n4 + n2).trim();
                n4 += n2;
            }
            return stringArray;
        }

        protected String[] parseByPosition(String string, int[] nArray) throws GroupException {
            String[] stringArray = new String[nArray.length + 1];
            stringArray[0] = string.substring(7, 10).trim();
            for (int i = 0; i < nArray.length && nArray[i] <= string.length(); ++i) {
                if (i == nArray.length - 1) {
                    stringArray[i + 1] = string.substring(nArray[i]).trim();
                    continue;
                }
                if (nArray[i + 1] > string.length()) {
                    stringArray[i + 1] = string.substring(nArray[i]).trim();
                    break;
                }
                stringArray[i + 1] = string.substring(nArray[i], nArray[i + 1]).trim();
            }
            return stringArray;
        }
    }
}

