/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.StructureRecord;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.core.io.RawIteratingReader;
import java.io.Reader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLV2000Format;

public class RawIteratingSDFReader
extends RawIteratingReader<IStructureRecord> {
    public static final String delimiter = "$$$$";
    protected final StructureRecord r = new StructureRecord();

    public RawIteratingSDFReader(Reader reader) throws CDKException {
        super(reader);
    }

    @Override
    public boolean isEndOfRecord(String string) {
        return string.contains(delimiter);
    }

    @Override
    public IResourceFormat getFormat() {
        return MDLV2000Format.getInstance();
    }

    @Override
    public IStructureRecord nextRecord() {
        Object object = this.next();
        if (object instanceof IStructureRecord) {
            return (IStructureRecord)object;
        }
        StructureRecord structureRecord = new StructureRecord(-1, -1, object.toString(), "SDF");
        structureRecord.setReference(this.reference);
        return structureRecord;
    }

    @Override
    public Object next() {
        Object object = super.next();
        this.r.setIdchemical(-1);
        this.r.setIdstructure(-1);
        this.r.setFormat("SDF");
        this.r.setContent(object.toString());
        this.r.setReference(this.getReference());
        return this.r;
    }
}

