/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.groups;

import ambit2.core.groups.IFiltered;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FilteredList<T>
implements List<T>,
IFiltered<T> {
    private static final long serialVersionUID = 1018513075305858000L;
    protected int size = 0;
    protected ArrayList<T> activeList;
    private ArrayList<T> content = new ArrayList();
    private ArrayList<T> filter = new ArrayList();

    public FilteredList() {
        this.setFiltered(false);
    }

    @Override
    public int size() {
        return this.activeList.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.activeList.iterator();
    }

    @Override
    public boolean isFiltered() {
        return this.activeList == this.filter;
    }

    @Override
    public void setFiltered(boolean bl) {
        this.activeList = bl ? this.filter : this.content;
    }

    @Override
    public boolean isEmpty() {
        return this.activeList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.activeList.contains(object);
    }

    @Override
    public Object[] toArray() {
        return this.activeList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.activeList.toArray(TArray);
    }

    @Override
    public boolean add(T t) {
        if (this.isFiltered()) {
            boolean bl = this.content.add(t);
            if (this.filter.indexOf(t) == -1) {
                return this.filter.add(t);
            }
            return bl;
        }
        return this.content.add(t);
    }

    @Override
    public boolean remove(Object object) {
        return this.delete(object);
    }

    public boolean delete(T t) {
        this.filter.remove(t);
        return this.content.remove(t);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.activeList.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        if (this.isFiltered()) {
            this.content.addAll(collection);
            return this.filter.addAll(collection);
        }
        return this.content.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        if (this.isFiltered()) {
            this.filter.addAll(n, collection);
        }
        return this.content.addAll(n, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.filter.removeAll(collection);
        return this.content.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.filter.retainAll(collection);
        return this.content.retainAll(collection);
    }

    @Override
    public void clear() {
        this.activeList.clear();
        if (!this.isFiltered()) {
            this.filter.clear();
        }
    }

    @Override
    public T get(int n) {
        return this.activeList.get(n);
    }

    @Override
    public T set(int n, T t) {
        ArrayList<T> arrayList = null;
        arrayList = this.isFiltered() ? this.content : this.filter;
        T t2 = this.activeList.get(n);
        this.activeList.set(n, t);
        int n2 = arrayList.indexOf(t2);
        if (n2 > -1) {
            arrayList.set(n2, t);
        } else if (arrayList == this.content) {
            throw new IllegalArgumentException("No such element");
        }
        return t;
    }

    @Override
    public void add(int n, T t) {
        this.content.add(n, t);
        if (this.filter.indexOf(t) == -1) {
            this.filter.add(n, t);
        }
    }

    @Override
    public void addToFilter(T t) {
        if (t == null) {
            return;
        }
        if (this.content.indexOf(t) == -1) {
            this.content.add(t);
        }
        if (this.filter.indexOf(t) == -1) {
            this.filter.add(t);
        }
    }

    @Override
    public void addToFilter(int n) {
        T t = this.get(n);
        if (t == null) {
            return;
        }
        if (this.filter.indexOf(t) == -1) {
            this.filter.add(t);
        }
    }

    @Override
    public void removeFromFilter(int n) {
        this.removeFromFilter(this.get(n));
    }

    @Override
    public void removeFromFilter(T t) {
        if (t == null) {
            return;
        }
        this.filter.remove(t);
    }

    @Override
    public void clearFilter() {
        this.filter.clear();
        this.setFiltered(false);
    }

    @Override
    public T remove(int n) {
        T t = null;
        if (this.isFiltered()) {
            t = this.filter.get(n);
            this.filter.remove(n);
        } else {
            t = this.content.get(n);
            this.content.remove(n);
        }
        return t;
    }

    @Override
    public int indexOf(Object object) {
        return this.activeList.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.activeList.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.activeList.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return this.activeList.listIterator(n);
    }

    @Override
    public List<T> subList(int n, int n2) {
        return this.activeList.subList(n, n2);
    }

    public int getNumber(T t) {
        for (int i = 0; i < this.activeList.size(); ++i) {
            if (t != this.activeList.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isVisible(T t) {
        return this.activeList.contains(t);
    }

    @Override
    public boolean isFiltered(T t) {
        return this.filter.contains(t);
    }
}

