/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.data.experiment;

import ambit2.base.data.AmbitBean;
import ambit2.base.exceptions.AmbitIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

public class TemplateField
extends AmbitBean {
    private static final long serialVersionUID = 7598061386536935899L;
    protected String units = "";
    protected boolean numeric = true;
    protected boolean isResult = false;
    protected String name = "DEFAULT";
    protected int id;

    public TemplateField() {
    }

    public TemplateField(String string) {
        this.setName(string);
    }

    public TemplateField(String string, String string2, boolean bl, boolean bl2) {
        this.setUnits(string2);
        this.setNumeric(bl);
        this.setResult(bl2);
        this.setName(string);
    }

    public TemplateField(String string, int n) {
        this.setName(string);
        this.setId(n);
    }

    public synchronized String getUnits() {
        return this.units;
    }

    public synchronized void setUnits(String string) {
        this.units = string;
    }

    public synchronized boolean isNumeric() {
        return this.numeric;
    }

    public synchronized void setNumeric(boolean bl) {
        this.numeric = bl;
    }

    public String getType() {
        if (this.numeric) {
            return "numeric";
        }
        return "string";
    }

    public String getMode() {
        if (this.isResult) {
            return "result";
        }
        return "condition";
    }

    public boolean isResult() {
        return this.isResult;
    }

    public void setResult(boolean bl) {
        this.isResult = bl;
    }

    public boolean save(OutputStream outputStream) throws AmbitIOException {
        return this.save(new OutputStreamWriter(outputStream));
    }

    public boolean save(Writer writer) throws AmbitIOException {
        try {
            writer.write("\n");
            writer.write("<field ");
            writer.write("name=\"");
            writer.write(this.getName());
            writer.write("\" units=\"");
            writer.write(this.getUnits());
            writer.write("\" numeric=");
            if (this.numeric) {
                writer.write("\"True\"");
            } else {
                writer.write("\"False\"");
            }
            writer.write(" result=");
            if (this.isResult) {
                writer.write("\"True\"");
            } else {
                writer.write("\"False\"");
            }
            writer.write("/>");
            return true;
        }
        catch (IOException iOException) {
            throw new AmbitIOException(((Object)((Object)this)).getClass().getName(), (Throwable)iOException);
        }
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public void setName(String string) {
        this.name = string.replace('\"', '\'');
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getName() {
        return this.name;
    }
}

