/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.element.AbstractLine3;
import org.xmlcml.cml.element.CMLPlane3;
import org.xmlcml.cml.element.CMLPoint3;
import org.xmlcml.cml.element.CMLTransform3;
import org.xmlcml.cml.element.CMLVector3;
import org.xmlcml.euclid.Line3;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Real;
import org.xmlcml.euclid.Util;
import org.xmlcml.euclid.Vector3;

public class CMLLine3
extends AbstractLine3 {
    public static final String NS = "cml:line3";
    public static final int POINT = 3;
    public static final int VECTOR = 0;

    public CMLLine3() {
    }

    public CMLLine3(CMLLine3 old) {
        super(old);
    }

    public Node copy() {
        return new CMLLine3(this);
    }

    public CMLElement makeElementInContext(Element parent) {
        return new CMLLine3();
    }

    public void finishMakingElement(Element parent) throws RuntimeException {
        if (this.getPoint3Attribute() == null) {
            throw new RuntimeException("point3 is now mandatory");
        }
        if (this.getVector3Attribute() == null) {
            throw new RuntimeException("vector3 is now mandatory");
        }
    }

    public CMLLine3(Line3 l) {
        this();
        this.setPoint3(l.getPoint().getArray());
        this.setVector3(l.getVector().getArray());
    }

    public CMLLine3(CMLPoint3 p, CMLVector3 v) throws RuntimeException {
        if (v.isZero()) {
            throw new RuntimeException("zero vector");
        }
        v.normalize();
        this.setPoint3(p.getXYZ3());
        this.setVector3(v.getXYZ3());
    }

    public CMLLine3(CMLPoint3 p1, CMLPoint3 p2) throws RuntimeException {
        CMLVector3 v = p1.subtract(p2);
        if (v.isZero()) {
            throw new RuntimeException("coincident points");
        }
        this.setPoint3(p1.getXYZ3());
        this.setVector3(v.getXYZ3());
    }

    public Line3 getEuclidLine3() throws RuntimeException {
        return new Line3(new Point3(this.getPoint3()), new Vector3(this.getVector3()));
    }

    public void setVector3(CMLVector3 v) {
        if (v.isZero()) {
            throw new RuntimeException("Cannot make line with zero vector");
        }
        CMLVector3 vv = new CMLVector3(v);
        vv.normalize();
        super.setVector3(vv.getXMLContent());
    }

    public boolean isEqualTo(CMLLine3 l2) {
        return Util.isEqual(this.getPoint3(), l2.getPoint3(), 1.0E-14) && Util.isEqual(this.getVector3(), l2.getVector3(), 1.0E-14);
    }

    public CMLLine3 subtract() {
        double[] vv = this.getVector3();
        for (int i = 0; i < vv.length; ++i) {
            vv[i] = -vv[i];
        }
        this.setVector3(vv);
        return this;
    }

    public CMLLine3 transform(CMLTransform3 t) {
        Line3 linee = this.getEuclidLine3();
        Line3 l = linee.transform(t.getEuclidTransform3());
        return new CMLLine3(l);
    }

    public boolean isParallelTo(CMLLine3 l2) {
        double[] v = this.getVector3();
        double[] v2 = l2.getVector3();
        return Util.isEqual(v, v2, 1.0E-14);
    }

    public boolean isAntiparallelTo(CMLLine3 l2) {
        double[] v = this.getVector3();
        Vector3 vv = new Vector3(v);
        vv = vv.multiplyBy(-1.0);
        return Util.isEqual(vv.getArray(), v, 1.0E-14);
    }

    public boolean containsPoint(CMLPoint3 p) {
        double d = p.distanceFromLine(this);
        return Real.isZero(d, Real.getEpsilon());
    }

    public CMLPoint3 getClosestPointTo(CMLPoint3 p2) {
        Line3 leucl3 = this.getEuclidLine3();
        Point3 pp = leucl3.getClosestPointTo(p2.getEuclidPoint3());
        return pp == null ? null : new CMLPoint3(pp.getArray());
    }

    public double getDistanceFromPoint(CMLPoint3 p) {
        Line3 leucl3 = this.getEuclidLine3();
        return leucl3.getDistanceFromPoint(p.getEuclidPoint3());
    }

    public CMLPoint3 getIntersectionWith(CMLPlane3 pl) {
        Line3 leucl3 = this.getEuclidLine3();
        Point3 pp = leucl3.getIntersectionWith(pl.getEuclidPlane3());
        return pp == null ? null : new CMLPoint3(pp.getArray());
    }

    public String getString() {
        String s = this.getEuclidLine3().toString();
        return s;
    }
}

