/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.Iterator;
import org.openscience.cdk.Atom;
import org.openscience.cdk.graph.AtomContainerPermutor;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

public class AtomContainerAtomPermutor
extends AtomContainerPermutor {
    public AtomContainerAtomPermutor(IAtomContainer ac) {
        this.setAtomContainer(ac);
        this.N = this.atomContainer.getAtomCount();
        this.initBookkeeping();
        this.initObjectArray();
    }

    public void initObjectArray() {
        Iterator<IAtom> atoms = this.atomContainer.atoms().iterator();
        this.objects = new Object[this.atomContainer.getAtomCount()];
        int count = -1;
        while (atoms.hasNext()) {
            this.objects[++count] = atoms.next();
        }
    }

    IAtomContainer makeResult() {
        IAtom[] atoms = new Atom[this.objects.length];
        for (int f = 0; f < this.objects.length; ++f) {
            atoms[f] = (Atom)this.objects[f];
        }
        IAtomContainer ac = this.atomContainer.getBuilder().newInstance(IAtomContainer.class, this.atomContainer);
        ac.setAtoms(atoms);
        IAtomContainer clone = null;
        try {
            clone = ac.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }
}

