/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.structgen;

import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.math.MathTools;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class RandomGenerator {
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(RandomGenerator.class);
    private IMolecule proposedStructure = null;
    private IMolecule molecule = null;
    private IMolecule trial = null;

    public RandomGenerator(IMolecule molecule) {
        this.setMolecule(molecule);
    }

    public IMolecule proposeStructure() {
        this.logger.debug("RandomGenerator->proposeStructure() Start");
        do {
            int f;
            try {
                this.trial = this.molecule.clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.error("Could not clone IAtomContainer!" + e.getMessage());
                this.trial = null;
            }
            this.mutate(this.trial);
            if (!this.logger.isDebugEnabled()) continue;
            String s = "BondCounts:    ";
            for (f = 0; f < this.trial.getAtomCount(); ++f) {
                s = s + this.trial.getConnectedBondsCount(this.trial.getAtom(f)) + " ";
            }
            this.logger.debug(s);
            s = "BondOrderSums: ";
            for (f = 0; f < this.trial.getAtomCount(); ++f) {
                s = s + this.trial.getBondOrderSum(this.trial.getAtom(f)) + " ";
            }
            this.logger.debug(s);
        } while (this.trial == null || !ConnectivityChecker.isConnected(this.trial));
        this.proposedStructure = this.trial;
        return this.proposedStructure;
    }

    public void acceptStructure() {
        if (this.proposedStructure != null) {
            this.molecule = this.proposedStructure;
        }
    }

    public void mutate(IAtomContainer ac) {
        this.logger.debug("RandomGenerator->mutate() Start");
        int nrOfAtoms = ac.getAtomCount();
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        double a11 = 0.0;
        double a12 = 0.0;
        double a22 = 0.0;
        double a21 = 0.0;
        double b11 = 0.0;
        double lowerborder = 0.0;
        double upperborder = 0.0;
        IAtom ax1 = null;
        IAtom ax2 = null;
        IAtom ay1 = null;
        IAtom ay2 = null;
        IBond b1 = null;
        IBond b2 = null;
        IBond b3 = null;
        IBond b4 = null;
        int[] choices = new int[3];
        int choiceCounter = 0;
        int nonZeroBondsCounter = 0;
        while (true) {
            nonZeroBondsCounter = 0;
            do {
                x1 = (int)(Math.random() * (double)nrOfAtoms);
                x2 = (int)(Math.random() * (double)nrOfAtoms);
                y1 = (int)(Math.random() * (double)nrOfAtoms);
                y2 = (int)(Math.random() * (double)nrOfAtoms);
                this.logger.debug("RandomGenerator->mutate(): x1, x2, y1, y2: " + x1 + ", " + x2 + ", " + y1 + ", " + y2);
            } while (x1 == x2 || x1 == y1 || x1 == y2 || x2 == y1 || x2 == y2 || y1 == y2);
            ax1 = ac.getAtom(x1);
            ay1 = ac.getAtom(y1);
            ax2 = ac.getAtom(x2);
            ay2 = ac.getAtom(y2);
            b1 = ac.getBond(ax1, ay1);
            if (b1 != null) {
                a11 = BondManipulator.destroyBondOrder(b1.getOrder());
                ++nonZeroBondsCounter;
            } else {
                a11 = 0.0;
            }
            b2 = ac.getBond(ax1, ay2);
            if (b2 != null) {
                a12 = BondManipulator.destroyBondOrder(b2.getOrder());
                ++nonZeroBondsCounter;
            } else {
                a12 = 0.0;
            }
            b3 = ac.getBond(ax2, ay1);
            if (b3 != null) {
                a21 = BondManipulator.destroyBondOrder(b3.getOrder());
                ++nonZeroBondsCounter;
            } else {
                a21 = 0.0;
            }
            b4 = ac.getBond(ax2, ay2);
            if (b4 != null) {
                a22 = BondManipulator.destroyBondOrder(b4.getOrder());
                ++nonZeroBondsCounter;
            } else {
                a22 = 0.0;
            }
            this.logger.debug("RandomGenerator->mutate()->The old bond orders: a11, a12, a21, a22: " + a11 + ", " + a12 + ", " + a21 + ", " + a22);
            if (nonZeroBondsCounter < 2) continue;
            double[] cmax = new double[]{0.0, a11 - a22, a11 + a12 - 3.0, a11 + a21 - 3.0};
            double[] cmin = new double[]{3.0, a11 + a12, a11 + a21, a11 - a22 + 3.0};
            lowerborder = MathTools.max(cmax);
            upperborder = MathTools.min(cmin);
            this.logger.debug("*** New Try ***");
            this.logger.debug("a11 = ", a11);
            this.logger.debug("upperborder = ", upperborder);
            this.logger.debug("lowerborder = ", lowerborder);
            choiceCounter = 0;
            for (double f = lowerborder; f <= upperborder; f += 1.0) {
                if (f == a11) continue;
                choices[choiceCounter] = (int)f;
                ++choiceCounter;
            }
            if (choiceCounter > 0) {
                b11 = choices[(int)(Math.random() * (double)choiceCounter)];
            }
            this.logger.debug("b11 = " + b11);
            if (b11 != a11 && b11 >= lowerborder && b11 <= upperborder) break;
        }
        double b12 = a11 + a12 - b11;
        double b21 = a11 + a21 - b11;
        double b22 = a22 - a11 + b11;
        if (b11 > 0.0) {
            if (b1 == null) {
                b1 = ac.getBuilder().newInstance(IBond.class, new Object[]{ax1, ay1, BondManipulator.createBondOrder(b11)});
                ac.addBond(b1);
            } else {
                b1.setOrder(BondManipulator.createBondOrder(b11));
            }
        } else if (b1 != null) {
            ac.removeBond(b1);
        }
        if (b12 > 0.0) {
            if (b2 == null) {
                b2 = ac.getBuilder().newInstance(IBond.class, new Object[]{ax1, ay2, BondManipulator.createBondOrder(b12)});
                ac.addBond(b2);
            } else {
                b2.setOrder(BondManipulator.createBondOrder(b12));
            }
        } else if (b2 != null) {
            ac.removeBond(b2);
        }
        if (b21 > 0.0) {
            if (b3 == null) {
                b3 = ac.getBuilder().newInstance(IBond.class, new Object[]{ax2, ay1, BondManipulator.createBondOrder(b21)});
                ac.addBond(b3);
            } else {
                b3.setOrder(BondManipulator.createBondOrder(b21));
            }
        } else if (b3 != null) {
            ac.removeBond(b3);
        }
        if (b22 > 0.0) {
            if (b4 == null) {
                b4 = ac.getBuilder().newInstance(IBond.class, new Object[]{ax2, ay2, BondManipulator.createBondOrder(b22)});
                ac.addBond(b4);
            } else {
                b4.setOrder(BondManipulator.createBondOrder(b22));
            }
        } else if (b4 != null) {
            ac.removeBond(b4);
        }
        this.logger.debug("a11 a12 a21 a22: " + a11 + " " + a12 + " " + a21 + " " + a22);
        this.logger.debug("b11 b12 b21 b22: " + b11 + " " + b12 + " " + b21 + " " + b22);
    }

    public void setMolecule(IMolecule molecule) {
        this.molecule = molecule;
    }

    public IMolecule getMolecule() {
        return this.molecule;
    }
}

