/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.ring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathEdge {
    private List<IAtom> atoms;

    public PathEdge(List<IAtom> atoms) {
        this.atoms = atoms;
    }

    public List<IAtom> getAtoms() {
        return this.atoms;
    }

    public IAtom getSource() {
        return this.atoms.get(0);
    }

    public IAtom getTarget() {
        return this.atoms.get(this.atoms.size() - 1);
    }

    public boolean isCycle() {
        return this.atoms.size() > 2 && this.atoms.get(0).equals(this.atoms.get(this.atoms.size() - 1));
    }

    public PathEdge splice(PathEdge other) {
        IAtom intersection = this.getIntersection(other.atoms);
        ArrayList<IAtom> newAtoms = new ArrayList<IAtom>(this.atoms);
        if (this.atoms.get(0) == intersection) {
            Collections.reverse(newAtoms);
        }
        if (other.atoms.get(0) == intersection) {
            for (int i = 1; i < other.atoms.size(); ++i) {
                newAtoms.add(other.atoms.get(i));
            }
        } else {
            for (int i = other.atoms.size() - 2; i >= 0; --i) {
                newAtoms.add(other.atoms.get(i));
            }
        }
        if (!this.isRealPath(newAtoms)) {
            return null;
        }
        return new PathEdge(newAtoms);
    }

    private boolean isRealPath(List<IAtom> atoms) {
        for (int i = 1; i < atoms.size() - 1; ++i) {
            for (int j = 1; j < atoms.size() - 1; ++j) {
                if (i == j || atoms.get(i) != atoms.get(j)) continue;
                return false;
            }
        }
        return true;
    }

    private IAtom getIntersection(List<IAtom> others) {
        if (this.atoms.get(this.atoms.size() - 1) == others.get(0) || this.atoms.get(this.atoms.size() - 1) == others.get(others.size() - 1)) {
            return this.atoms.get(this.atoms.size() - 1);
        }
        if (this.atoms.get(0) == others.get(0) || this.atoms.get(0) == others.get(others.size() - 1)) {
            return this.atoms.get(0);
        }
        throw new RuntimeException("Couldn't splice - no intersection.");
    }
}

