/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.similarity;

import java.util.BitSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;

@TestClass(value="org.openscience.cdk.similarity.TanimotoTest")
public class Tanimoto {
    @TestMethod(value="testTanimoto1,testTanimoto2")
    public static float calculate(BitSet bitset1, BitSet bitset2) throws CDKException {
        float _bitset1_cardinality = bitset1.cardinality();
        float _bitset2_cardinality = bitset2.cardinality();
        if (bitset1.size() != bitset2.size()) {
            throw new CDKException("Bisets must have the same bit length");
        }
        BitSet one_and_two = (BitSet)bitset1.clone();
        one_and_two.and(bitset2);
        float _common_bit_count = one_and_two.cardinality();
        return _common_bit_count / (_bitset1_cardinality + _bitset2_cardinality - _common_bit_count);
    }

    @TestMethod(value="testTanimoto3")
    public static float calculate(double[] features1, double[] features2) throws CDKException {
        if (features1.length != features2.length) {
            throw new CDKException("Features vectors must be of the same length");
        }
        int n = features1.length;
        double ab = 0.0;
        double a2 = 0.0;
        double b2 = 0.0;
        for (int i = 0; i < n; ++i) {
            ab += features1[i] * features2[i];
            a2 += features1[i] * features1[i];
            b2 += features2[i] * features2[i];
        }
        return (float)ab / (float)(a2 + b2 - ab);
    }
}

