/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.HINFormat;
import org.openscience.cdk.io.formats.IResourceFormat;

public class PaDELHINReader
extends DefaultChemObjectReader {
    private BufferedReader input;

    public PaDELHINReader(Reader reader) {
        this.input = new BufferedReader(reader);
    }

    public PaDELHINReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public PaDELHINReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return HINFormat.getInstance();
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class clazz) {
        Class<?>[] classArray;
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!IChemFile.class.equals(clazz2)) continue;
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null) {
            return this.accepts(clazz3);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T t) throws CDKException {
        if (t instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)t);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private String getMolName(String string) {
        if (string == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        if (stringArray.length == 3) {
            return stringArray[2];
        }
        return "";
    }

    private IChemFile readChemFile(IChemFile iChemFile) {
        int n;
        Object object;
        IChemSequence iChemSequence = iChemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel iChemModel = iChemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IMoleculeSet iMoleculeSet = iChemFile.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<IMolecule> arrayList2 = new ArrayList<IMolecule>();
        try {
            Object object2;
            while (!((String)(object2 = this.input.readLine())).startsWith("mol")) {
            }
            String string = this.getMolName((String)object2);
            object2 = this.input.readLine();
            while (object2 != null) {
                Object object3;
                String[] stringArray;
                if (((String)object2).startsWith(";")) continue;
                if (((String)object2).startsWith("mol")) {
                    string = this.getMolName((String)object2);
                    object2 = this.input.readLine();
                }
                IMolecule object4 = iChemFile.getBuilder().newInstance(IMolecule.class, new Object[0]);
                object4.setProperty("cdk:Title", string);
                object = new ArrayList();
                n = 0;
                while (object2 != null && !((String)object2).contains("endmol")) {
                    if (((String)object2).startsWith(";")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer((String)object2, " ");
                    int n2 = stringTokenizer.countTokens();
                    stringArray = new String[n2];
                    for (int i = 0; i < n2; ++i) {
                        stringArray[i] = stringTokenizer.nextToken();
                    }
                    object3 = stringArray[3];
                    double d = Double.parseDouble(stringArray[6]);
                    double d2 = Double.parseDouble(stringArray[7]);
                    double d3 = Double.parseDouble(stringArray[8]);
                    double d4 = Double.parseDouble(stringArray[9]);
                    int n3 = Integer.parseInt(stringArray[10]);
                    IAtom iAtom = iChemFile.getBuilder().newInstance(IAtom.class, object3, new Point3d(d2, d3, d4));
                    iAtom.setCharge(d);
                    IBond.Order order = IBond.Order.SINGLE;
                    for (int i = 11; i < 11 + n3 * 2; i += 2) {
                        int n4 = Integer.parseInt(stringArray[i]) - 1;
                        char c = stringArray[i + 1].charAt(0);
                        switch (c) {
                            case 's': {
                                order = IBond.Order.SINGLE;
                                break;
                            }
                            case 'd': {
                                order = IBond.Order.DOUBLE;
                                break;
                            }
                            case 't': {
                                order = IBond.Order.TRIPLE;
                                break;
                            }
                            case 'a': {
                                order = IBond.Order.SINGLE;
                                iAtom.setFlag(5, true);
                            }
                        }
                        ArrayList<Object> arrayList3 = new ArrayList<Object>(3);
                        arrayList3.add(n);
                        arrayList3.add(n4);
                        arrayList3.add((Object)order);
                        object.add(arrayList3);
                    }
                    object4.addAtom(iAtom);
                    ++n;
                    object2 = this.input.readLine();
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    stringArray = (String[])iterator.next();
                    object3 = object4.getAtom((Integer)stringArray.get(0));
                    IAtom iAtom = object4.getAtom((Integer)stringArray.get(1));
                    IBond.Order order = (IBond.Order)((Object)stringArray.get(2));
                    if (this.isConnected(object4, (IAtom)object3, iAtom)) continue;
                    IBond iBond = iChemFile.getBuilder().newInstance(IBond.class, new Object[]{object3, iAtom, order});
                    if (object3.getFlag(5) && iAtom.getFlag(5)) {
                        iBond.setFlag(5, true);
                    }
                    object4.addBond(iBond);
                }
                arrayList2.add(object4);
                while ((object2 = this.input.readLine()) != null && !((String)object2).startsWith("mol")) {
                    if (!((String)object2).startsWith("aromaticring")) continue;
                    arrayList.add(((String)object2).trim());
                }
            }
        }
        catch (IOException iOException) {
            iChemFile = null;
        }
        if (arrayList.size() > 0) {
            for (String string : arrayList) {
                object = string.split(" ");
                n = Integer.parseInt(object[1]);
                int n5 = 0;
                for (int i = 2; i < ((String[])object).length; i += 2) {
                    int n6 = Integer.parseInt(object[i]);
                    int n7 = Integer.parseInt(object[i + 1]);
                    ((IMolecule)arrayList2.get(n6 - 1)).getAtom(n7 - 1).setFlag(5, true);
                    ++n5;
                }
                assert (n5 == n);
            }
        }
        for (IMolecule iMolecule : arrayList2) {
            iMoleculeSet.addMolecule(iMolecule);
        }
        iChemModel.setMoleculeSet(iMoleculeSet);
        iChemSequence.addChemModel(iChemModel);
        iChemFile.addChemSequence(iChemSequence);
        return iChemFile;
    }

    private boolean isConnected(IAtomContainer iAtomContainer, IAtom iAtom, IAtom iAtom2) {
        for (IBond iBond : iAtomContainer.bonds()) {
            if (!iBond.contains(iAtom) || !iBond.contains(iAtom2)) continue;
            return true;
        }
        return false;
    }
}

