/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.processors.batch;

import ambit2.base.interfaces.IBatchStatistics;
import java.util.Observable;

public class DefaultBatchStatistics
extends Observable
implements IBatchStatistics {
    private static final long serialVersionUID = -8714835013929249115L;
    protected long[] records = new long[]{0L, 0L, 0L, 0L};
    protected long[] time_elapsed = new long[]{0L, 0L, 0L, 0L};
    protected long frequency = 50L;
    protected long last_time_print_stats = 0L;
    protected static final String blank = "";
    protected boolean inProgress = true;
    protected String resultCaption = "Found";

    @Override
    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long l) {
        this.frequency = l;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.records.length; ++i) {
            this.records[i] = 0L;
            this.time_elapsed[i] = 0L;
        }
        this.inProgress = true;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void completed() {
        this.inProgress = false;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public long getRecords(IBatchStatistics.RECORDS_STATS rECORDS_STATS) {
        return this.records[rECORDS_STATS.ordinal()];
    }

    @Override
    public void setRecords(IBatchStatistics.RECORDS_STATS rECORDS_STATS, long l) {
        this.records[rECORDS_STATS.ordinal()] = l;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void increment(IBatchStatistics.RECORDS_STATS rECORDS_STATS) {
        int n = rECORDS_STATS.ordinal();
        this.records[n] = this.records[n] + 1L;
        this.setChanged();
        this.notifyObservers();
    }

    public long getTimeElapsed() {
        return this.time_elapsed[IBatchStatistics.RECORDS_STATS.RECORDS_READ.ordinal()] + this.time_elapsed[IBatchStatistics.RECORDS_STATS.RECORDS_PROCESSED.ordinal()] + this.time_elapsed[IBatchStatistics.RECORDS_STATS.RECORDS_ERROR.ordinal()];
    }

    @Override
    public long getTimeElapsed(IBatchStatistics.RECORDS_STATS rECORDS_STATS) {
        return this.time_elapsed[rECORDS_STATS.ordinal()];
    }

    @Override
    public void setTimeElapsed(IBatchStatistics.RECORDS_STATS rECORDS_STATS, long l) {
        this.time_elapsed[rECORDS_STATS.ordinal()] = l;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void incrementTimeElapsed(IBatchStatistics.RECORDS_STATS rECORDS_STATS, long l) {
        int n = rECORDS_STATS.ordinal();
        this.time_elapsed[n] = this.time_elapsed[n] + l;
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public boolean isTimeToPrint(long l) {
        long l2 = System.currentTimeMillis();
        if (l2 - this.last_time_print_stats > l) {
            this.last_time_print_stats = l2;
            return true;
        }
        return false;
    }

    public String toString() {
        long l = this.getTimeElapsed();
        StringBuffer stringBuffer = new StringBuffer();
        for (IBatchStatistics.RECORDS_STATS rECORDS_STATS : IBatchStatistics.RECORDS_STATS.values()) {
            stringBuffer.append(rECORDS_STATS.toString());
            stringBuffer.append(' ');
            stringBuffer.append(Long.toString(this.getRecords(rECORDS_STATS)));
            stringBuffer.append(' ');
        }
        if (this.getRecords(IBatchStatistics.RECORDS_STATS.RECORDS_READ) > 0L) {
            stringBuffer.append("(");
            long l2 = l / this.getRecords(IBatchStatistics.RECORDS_STATS.RECORDS_READ);
            if (l2 > 1000L) {
                stringBuffer.append(l2 / 1000L);
                stringBuffer.append(" s per record)");
            } else {
                stringBuffer.append(l2);
                stringBuffer.append(" ms per record)");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public String getResultCaption() {
        return this.resultCaption;
    }

    @Override
    public void setResultCaption(String string) {
        this.resultCaption = string;
    }
}

