/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.groups;

import ambit2.core.data.MoleculeTools;
import ambit2.core.groups.FilteredList;
import ambit2.core.groups.IFiltered;
import ambit2.core.groups.ISGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;

public class SuppleAtomContainer
extends ChemObject
implements IMolecule,
IChemObjectListener,
Serializable,
Cloneable,
IFiltered<IAtom> {
    private static final long serialVersionUID = -3228354237961385902L;
    protected FilteredList<IAtom> atoms;
    protected FilteredList<IBond> bonds;
    protected List<ILonePair> lonePairs;
    protected List<ISingleElectron> singleElectrons;
    protected Map<IAtom, IAtomParity> atomParities;

    public SuppleAtomContainer() {
        this.init();
    }

    protected void init() {
        this.atoms = new FilteredList();
        this.bonds = new FilteredList();
        this.lonePairs = new ArrayList<ILonePair>();
        this.singleElectrons = new ArrayList<ISingleElectron>();
        this.atomParities = new Hashtable<IAtom, IAtomParity>();
    }

    public void add(IAtomContainer iAtomContainer) {
        int n;
        for (n = 0; n < iAtomContainer.getAtomCount(); ++n) {
            if (this.contains(iAtomContainer.getAtom(n))) continue;
            this.addAtom(iAtomContainer.getAtom(n));
        }
        for (n = 0; n < iAtomContainer.getBondCount(); ++n) {
            if (this.contains(iAtomContainer.getBond(n))) continue;
            this.addBond(iAtomContainer.getBond(n));
        }
        for (n = 0; n < iAtomContainer.getLonePairCount(); ++n) {
            if (this.contains(iAtomContainer.getLonePair(n))) continue;
            this.addLonePair(iAtomContainer.getLonePair(n));
        }
        for (n = 0; n < iAtomContainer.getSingleElectronCount(); ++n) {
            if (this.contains(iAtomContainer.getSingleElectron(n))) continue;
            this.addSingleElectron(iAtomContainer.getSingleElectron(n));
        }
        this.notifyChanged();
    }

    public void addAtom(IAtom iAtom) {
        if (this.contains(iAtom)) {
            return;
        }
        iAtom.addListener((IChemObjectListener)this);
        this.atoms.add(iAtom);
        this.addToFilter(iAtom);
        this.notifyChanged();
    }

    public void addAtomParity(IAtomParity iAtomParity) {
        this.atomParities.put(iAtomParity.getAtom(), iAtomParity);
    }

    public void addBond(IBond iBond) {
        iBond.addListener((IChemObjectListener)this);
        this.bonds.add(iBond);
        this.addToFilter(iBond);
        this.notifyChanged();
    }

    public void addBond(int n, int n2, IBond.Order order, IBond.Stereo stereo) {
        IBond iBond = MoleculeTools.newBond(this.getBuilder(), this.getAtom(n), this.getAtom(n2), order, stereo);
        if (this.contains(iBond)) {
            return;
        }
        this.addBond(iBond);
    }

    public void addBond(int n, int n2, IBond.Order order) {
        IBond iBond = MoleculeTools.newBond(this.getBuilder(), this.getAtom(n), this.getAtom(n2), order);
        if (this.contains(iBond)) {
            return;
        }
        this.addBond(iBond);
    }

    public void addElectronContainer(IElectronContainer iElectronContainer) {
        if (iElectronContainer instanceof IBond) {
            this.addBond((IBond)iElectronContainer);
        }
        if (iElectronContainer instanceof ILonePair) {
            this.addLonePair((ILonePair)iElectronContainer);
        }
        if (iElectronContainer instanceof ISingleElectron) {
            this.addSingleElectron((ISingleElectron)iElectronContainer);
        }
    }

    public void addLonePair(ILonePair iLonePair) {
        this.lonePairs.add(iLonePair);
        this.notifyChanged();
    }

    public void addLonePair(int n) {
        ILonePair iLonePair = MoleculeTools.newLonePair(this.getBuilder(), this.getAtom(n));
        iLonePair.addListener((IChemObjectListener)this);
        this.addLonePair(iLonePair);
    }

    public void addSingleElectron(ISingleElectron iSingleElectron) {
        this.singleElectrons.add(iSingleElectron);
        this.notifyChanged();
    }

    public void addSingleElectron(int n) {
        ISingleElectron iSingleElectron = MoleculeTools.newSingleElectron(this.getBuilder(), this.getAtom(n));
        iSingleElectron.addListener((IChemObjectListener)this);
        this.addSingleElectron(iSingleElectron);
    }

    public Iterable<IAtom> atoms() {
        return this.atoms;
    }

    public Iterable<IBond> bonds() {
        return this.bonds;
    }

    public boolean contains(IAtom iAtom) {
        return this.atoms.contains(iAtom);
    }

    public boolean contains(IBond iBond) {
        return this.bonds.contains(iBond);
    }

    public boolean contains(ILonePair iLonePair) {
        return this.contains(iLonePair.getAtom()) && this.lonePairs.contains(iLonePair);
    }

    public boolean contains(ISingleElectron iSingleElectron) {
        return this.contains(iSingleElectron.getAtom()) && this.singleElectrons.contains(iSingleElectron);
    }

    public boolean contains(IElectronContainer iElectronContainer) {
        if (iElectronContainer instanceof IBond) {
            return this.contains((IBond)iElectronContainer);
        }
        if (iElectronContainer instanceof ILonePair) {
            return this.contains((ILonePair)iElectronContainer);
        }
        if (iElectronContainer instanceof ISingleElectron) {
            return this.contains((ISingleElectron)iElectronContainer);
        }
        return false;
    }

    public Iterable<IElectronContainer> electronContainers() {
        return new Iterable<IElectronContainer>(){

            @Override
            public Iterator<IElectronContainer> iterator() {
                return new ElectronContainerIterator();
            }
        };
    }

    public IAtom getAtom(int n) {
        return this.atoms.get(n);
    }

    public int getAtomCount() {
        return this.atoms.size();
    }

    public int getAtomNumber(IAtom iAtom) {
        return this.atoms.getNumber(iAtom);
    }

    public IAtomParity getAtomParity(IAtom iAtom) {
        return this.atomParities.get(iAtom);
    }

    public IBond getBond(int n) {
        return this.bonds.get(n);
    }

    public IBond getBond(IAtom iAtom, IAtom iAtom2) {
        for (IBond iBond : this.bonds()) {
            if (!iBond.contains(iAtom) || iBond.getConnectedAtom(iAtom) != iAtom2) continue;
            return iBond;
        }
        return null;
    }

    public int getBondCount() {
        return this.bonds.size();
    }

    public int getBondNumber(IBond iBond) {
        return this.bonds.getNumber(iBond);
    }

    public int getBondNumber(IAtom iAtom, IAtom iAtom2) {
        return this.getBondNumber(this.getBond(iAtom, iAtom2));
    }

    public double getBondOrderSum(IAtom iAtom) {
        double d = 0.0;
        for (IBond iBond : this.bonds) {
            if (!iBond.contains(iAtom)) continue;
            if (iBond.getOrder() == IBond.Order.SINGLE) {
                d += 1.0;
                continue;
            }
            if (iBond.getOrder() == IBond.Order.DOUBLE) {
                d += 2.0;
                continue;
            }
            if (iBond.getOrder() == IBond.Order.TRIPLE) {
                d += 3.0;
                continue;
            }
            if (iBond.getOrder() != IBond.Order.QUADRUPLE) continue;
            d += 4.0;
        }
        return d;
    }

    public int getConnectedAtomsCount(IAtom iAtom) {
        int n = 0;
        Iterator<IBond> iterator = this.bonds.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().contains(iAtom)) continue;
            ++n;
        }
        return n;
    }

    public List<IAtom> getConnectedAtomsList(IAtom iAtom) {
        ArrayList<IAtom> arrayList = new ArrayList<IAtom>();
        for (IBond iBond : this.bonds) {
            if (!iBond.contains(iAtom)) continue;
            arrayList.add(iBond.getConnectedAtom(iAtom));
        }
        return arrayList;
    }

    public int getConnectedBondsCount(IAtom iAtom) {
        return this.getConnectedAtomsCount(iAtom);
    }

    public int getConnectedBondsCount(int n) {
        return this.getConnectedAtomsCount(this.getAtom(n));
    }

    public List<IBond> getConnectedBondsList(IAtom iAtom) {
        ArrayList<IBond> arrayList = new ArrayList<IBond>();
        for (IBond iBond : this.bonds) {
            if (!iBond.contains(iAtom)) continue;
            arrayList.add(iBond);
        }
        return arrayList;
    }

    public List<IElectronContainer> getConnectedElectronContainersList(IAtom iAtom) {
        ArrayList<IElectronContainer> arrayList = new ArrayList<IElectronContainer>();
        for (IBond object : this.bonds) {
            if (!object.contains(iAtom)) continue;
            arrayList.add((IElectronContainer)object);
        }
        for (ILonePair i : this.lonePairs) {
            if (!i.contains(iAtom)) continue;
            arrayList.add((IElectronContainer)i);
        }
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            if (!this.singleElectrons.get(i).contains(iAtom)) continue;
            arrayList.add((IElectronContainer)this.singleElectrons.get(i));
        }
        return arrayList;
    }

    public int getConnectedLonePairsCount(IAtom iAtom) {
        int n = 0;
        Iterator<ILonePair> iterator = this.lonePairs.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().contains(iAtom)) continue;
            ++n;
        }
        return n;
    }

    public List<ILonePair> getConnectedLonePairsList(IAtom iAtom) {
        ArrayList<ILonePair> arrayList = new ArrayList<ILonePair>();
        for (ILonePair iLonePair : this.lonePairs) {
            if (!iLonePair.contains(iAtom)) continue;
            arrayList.add(iLonePair);
        }
        return arrayList;
    }

    public int getConnectedSingleElectronsCount(IAtom iAtom) {
        int n = 0;
        for (ISingleElectron iSingleElectron : this.singleElectrons) {
            if (!iSingleElectron.contains(iAtom)) continue;
            ++n;
        }
        return n;
    }

    public List<ISingleElectron> getConnectedSingleElectronsList(IAtom iAtom) {
        ArrayList<ISingleElectron> arrayList = new ArrayList<ISingleElectron>();
        for (ISingleElectron iSingleElectron : this.singleElectrons) {
            if (!iSingleElectron.contains(iAtom)) continue;
            arrayList.add(iSingleElectron);
        }
        return arrayList;
    }

    public IElectronContainer getElectronContainer(int n) {
        if (n < this.bonds.size()) {
            return (IElectronContainer)this.bonds.get(n);
        }
        if ((n -= this.bonds.size()) < this.lonePairs.size()) {
            return (IElectronContainer)this.lonePairs.get(n);
        }
        if ((n -= this.lonePairs.size()) < this.singleElectrons.size()) {
            return (IElectronContainer)this.singleElectrons.get(n);
        }
        return null;
    }

    public int getElectronContainerCount() {
        return this.bonds.size() + this.lonePairs.size() + this.singleElectrons.size();
    }

    public IAtom getFirstAtom() {
        return this.atoms.get(0);
    }

    public IAtom getLastAtom() {
        return this.getAtomCount() > 0 ? this.atoms.get(this.getAtomCount() - 1) : null;
    }

    public ILonePair getLonePair(int n) {
        return this.lonePairs.get(n);
    }

    public int getLonePairCount() {
        return this.lonePairs.size();
    }

    public int getLonePairNumber(ILonePair iLonePair) {
        for (int i = 0; i < this.lonePairs.size(); ++i) {
            if (this.lonePairs.get(i) != iLonePair) continue;
            return i;
        }
        return -1;
    }

    public IBond.Order getMaximumBondOrder(IAtom iAtom) {
        IBond.Order order = IBond.Order.SINGLE;
        for (IBond iBond : this.bonds) {
            if (!iBond.contains(iAtom) || iBond.getOrder().ordinal() <= order.ordinal()) continue;
            order = iBond.getOrder();
        }
        return order;
    }

    public IBond.Order getMinimumBondOrder(IAtom iAtom) {
        IBond.Order order = IBond.Order.QUADRUPLE;
        for (IBond iBond : this.bonds) {
            if (!iBond.contains(iAtom) || iBond.getOrder().ordinal() >= order.ordinal()) continue;
            order = iBond.getOrder();
        }
        return order;
    }

    public ISingleElectron getSingleElectron(int n) {
        return this.singleElectrons.get(n);
    }

    public int getSingleElectronCount() {
        return this.singleElectrons.size();
    }

    public int getSingleElectronNumber(ISingleElectron iSingleElectron) {
        return this.singleElectrons.indexOf(iSingleElectron);
    }

    public Iterable<ILonePair> lonePairs() {
        return this.lonePairs;
    }

    public void remove(IAtomContainer iAtomContainer) {
        Iterator iterator = iAtomContainer.atoms().iterator();
        while (iterator.hasNext()) {
            this.removeAtom((IAtom)iterator.next());
        }
        Iterator iterator2 = iAtomContainer.bonds().iterator();
        while (iterator2.hasNext()) {
            this.removeBond((IBond)iterator2.next());
        }
        Iterator iterator3 = iAtomContainer.lonePairs().iterator();
        while (iterator3.hasNext()) {
            this.removeLonePair((ILonePair)iterator3.next());
        }
        Iterator iterator4 = iAtomContainer.singleElectrons().iterator();
        while (iterator4.hasNext()) {
            this.removeSingleElectron((ISingleElectron)iterator4.next());
        }
    }

    public void removeAllBonds() {
        for (IBond iBond : this.bonds()) {
            iBond.removeListener((IChemObjectListener)this);
        }
        this.bonds.clear();
        this.notifyChanged();
    }

    public void removeAllElectronContainers() {
        this.removeAllBonds();
        for (ILonePair iLonePair : this.lonePairs()) {
            iLonePair.removeListener((IChemObjectListener)this);
        }
        for (ISingleElectron iSingleElectron : this.singleElectrons) {
            iSingleElectron.removeListener((IChemObjectListener)this);
        }
        this.lonePairs.clear();
        this.singleElectrons.clear();
        this.notifyChanged();
    }

    public void removeAllElements() {
        this.removeAllElectronContainers();
        for (IAtom iAtom : this.atoms()) {
            iAtom.removeListener((IChemObjectListener)this);
        }
        this.atoms.clear();
        this.notifyChanged();
    }

    public void removeAtom(int n) {
        IAtom iAtom = this.getAtom(n);
        this.removeAtom(iAtom);
    }

    public void removeAtom(IAtom iAtom) {
        iAtom.removeListener((IChemObjectListener)this);
        boolean bl = this.atoms.remove(iAtom);
    }

    public void removeAtomAndConnectedElectronContainers(IAtom iAtom) {
        int n = this.getAtomNumber(iAtom);
        if (n != -1) {
            int n2;
            for (n2 = this.getBondCount() - 1; n2 >= 0; --n2) {
                if (!this.bonds.get(n2).contains(iAtom)) continue;
                this.removeBond(n2);
            }
            for (n2 = this.getLonePairCount() - 1; n2 >= 0; --n2) {
                if (!this.lonePairs.get(n2).contains(iAtom)) continue;
                this.removeLonePair(n2);
            }
            for (n2 = this.getSingleElectronCount() - 1; n2 >= 0; --n2) {
                if (!this.singleElectrons.get(n2).contains(iAtom)) continue;
                this.removeSingleElectron(n2);
            }
            this.removeAtom(n);
        }
        this.notifyChanged();
    }

    public IBond removeBond(int n) {
        IBond iBond = this.getBond(n);
        this.removeBond(iBond);
        return iBond;
    }

    public void removeBond(IBond iBond) {
        iBond.removeListener((IChemObjectListener)this);
        this.bonds.remove(iBond);
    }

    public IBond removeBond(IAtom iAtom, IAtom iAtom2) {
        IBond iBond = this.getBond(iAtom, iAtom2);
        this.removeBond(iBond);
        return iBond;
    }

    public IElectronContainer removeElectronContainer(int n) {
        IElectronContainer iElectronContainer = this.getElectronContainer(n);
        this.removeElectronContainer(iElectronContainer);
        return iElectronContainer;
    }

    public void removeElectronContainer(IElectronContainer iElectronContainer) {
        if (iElectronContainer instanceof IBond) {
            this.removeBond((IBond)iElectronContainer);
        } else if (iElectronContainer instanceof ILonePair) {
            this.removeLonePair((ILonePair)iElectronContainer);
        } else if (iElectronContainer instanceof ISingleElectron) {
            this.removeSingleElectron((ISingleElectron)iElectronContainer);
        }
    }

    public ILonePair removeLonePair(int n) {
        ILonePair iLonePair = this.lonePairs.get(n);
        iLonePair.removeListener((IChemObjectListener)this);
        this.lonePairs.remove(iLonePair);
        this.notifyChanged();
        return iLonePair;
    }

    public void removeLonePair(ILonePair iLonePair) {
        iLonePair.removeListener((IChemObjectListener)this);
        this.lonePairs.remove(iLonePair);
        this.notifyChanged();
    }

    public ISingleElectron removeSingleElectron(int n) {
        ISingleElectron iSingleElectron = this.singleElectrons.get(n);
        iSingleElectron.removeListener((IChemObjectListener)this);
        this.singleElectrons.remove(n);
        this.notifyChanged();
        return iSingleElectron;
    }

    public void removeSingleElectron(ISingleElectron iSingleElectron) {
        iSingleElectron.removeListener((IChemObjectListener)this);
        this.singleElectrons.remove(iSingleElectron);
        this.notifyChanged();
    }

    public void setAtom(int n, IAtom iAtom) {
        while (n >= this.atoms.size()) {
            this.atoms.add(null);
        }
        if (n < this.atoms.size()) {
            IAtom iAtom2 = this.atoms.get(n);
            if (iAtom2 != null) {
                iAtom2.removeListener((IChemObjectListener)this);
            }
            iAtom.addListener((IChemObjectListener)this);
            this.atoms.set(n, iAtom);
            this.notifyChanged();
        }
    }

    public void setAtoms(IAtom[] iAtomArray) {
        for (IAtom iAtom : this.atoms()) {
            this.removeAtom(iAtom);
        }
        for (IAtom iAtom : iAtomArray) {
            this.addAtom(iAtom);
        }
        this.notifyChanged();
    }

    public void setBonds(IBond[] iBondArray) {
        for (IBond iBond : this.bonds()) {
            this.removeBond(iBond);
        }
        for (IBond iBond : iBondArray) {
            this.addBond(iBond);
        }
    }

    public Iterable<ISingleElectron> singleElectrons() {
        return this.singleElectrons;
    }

    public void stateChanged(IChemObjectChangeEvent iChemObjectChangeEvent) {
        IAtom iAtom;
        Object object;
        this.notifyChanged(iChemObjectChangeEvent);
        if (iChemObjectChangeEvent.getSource() instanceof IAtom && (object = (iAtom = (IAtom)iChemObjectChangeEvent.getSource()).getProperty((Object)"ambit2.groups.ISGroup.visible")) != null) {
            if (((Boolean)object).booleanValue()) {
                this.addToFilter(iAtom);
            } else {
                this.removeFromFilter(iAtom);
            }
        }
        if (iChemObjectChangeEvent.getSource() instanceof IBond && (object = (iAtom = (IBond)iChemObjectChangeEvent.getSource()).getProperty((Object)"ambit2.groups.ISGroup.visible")) != null) {
            if (((Boolean)object).booleanValue()) {
                this.addToFilter((IBond)iAtom);
            } else {
                this.removeFromFilter((IBond)iAtom);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        IAtomContainer iAtomContainer = (IAtomContainer)super.clone();
        if (iAtomContainer instanceof SuppleAtomContainer) {
            ((SuppleAtomContainer)iAtomContainer).init();
        } else {
            iAtomContainer.removeAllElements();
        }
        for (int i = 0; i < this.getAtomCount(); ++i) {
            iAtomContainer.addAtom((IAtom)this.getAtom(i).clone());
        }
        for (int i = 0; i < this.getBondCount(); ++i) {
            IBond iBond = this.getBond(i);
            IBond iBond2 = (IBond)iBond.clone();
            IAtom[] iAtomArray = new IAtom[iBond.getAtomCount()];
            for (int j = 0; j < iBond.getAtomCount(); ++j) {
                iAtomArray[j] = iAtomContainer.getAtom(this.getAtomNumber(iBond.getAtom(j)));
            }
            iBond2.setAtoms(iAtomArray);
            iAtomContainer.addBond(iBond2);
        }
        for (int i = 0; i < this.getLonePairCount(); ++i) {
            ILonePair iLonePair = this.getLonePair(i);
            ILonePair iLonePair2 = (ILonePair)iLonePair.clone();
            iLonePair2.setAtom(iAtomContainer.getAtom(this.getAtomNumber(iLonePair.getAtom())));
            iAtomContainer.addLonePair(iLonePair2);
        }
        for (int i = 0; i < this.getSingleElectronCount(); ++i) {
            ISingleElectron iSingleElectron = this.getSingleElectron(i);
            ISingleElectron iSingleElectron2 = (ISingleElectron)iSingleElectron.clone();
            iSingleElectron2.setAtom(iAtomContainer.getAtom(this.getAtomNumber(iSingleElectron.getAtom())));
            iAtomContainer.addSingleElectron(iSingleElectron2);
        }
        return iAtomContainer;
    }

    @Override
    public void addToFilter(IAtom iAtom) {
        this.atoms.addToFilter(iAtom);
    }

    @Override
    public void addToFilter(IBond iBond) {
        this.bonds.addToFilter(iBond);
    }

    @Override
    public void clearFilter() {
        this.atoms.clearFilter();
        this.bonds.clearFilter();
    }

    @Override
    public boolean isVisible(IAtom iAtom) {
        return this.atoms.isVisible(iAtom);
    }

    @Override
    public boolean isFiltered(IAtom iAtom) {
        return this.atoms.isFiltered(iAtom);
    }

    @Override
    public boolean isFiltered(IBond iBond) {
        return this.bonds.isFiltered(iBond);
    }

    @Override
    public void removeFromFilter(IAtom iAtom) {
        this.atoms.removeFromFilter(iAtom);
    }

    @Override
    public void removeFromFilter(IBond iBond) {
        this.bonds.removeFromFilter(iBond);
    }

    @Override
    public boolean isFiltered() {
        return this.atoms.isFiltered();
    }

    @Override
    public void setFiltered(boolean bl) {
        this.atoms.setFiltered(bl);
        this.bonds.setFiltered(bl);
    }

    public void addGroupAtom(ISGroup iSGroup, IAtom iAtom) {
        iSGroup.addAtom(iAtom);
    }

    public void addGroupBond(ISGroup iSGroup, IBond iBond) {
        IBond iBond2 = iSGroup.addBond(iBond);
        this.setFiltered(false);
        if (!this.bonds.contains(iBond2)) {
            this.addBond(iBond2);
        }
    }

    public void addStereoElement(IStereoElement iStereoElement) {
    }

    public Iterable<IStereoElement> stereoElements() {
        return null;
    }

    private class ElectronContainerIterator
    implements Iterator<IElectronContainer> {
        private int pointer = 0;

        private ElectronContainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < SuppleAtomContainer.this.bonds.size() + SuppleAtomContainer.this.lonePairs.size() + SuppleAtomContainer.this.singleElectrons.size();
        }

        @Override
        public IElectronContainer next() {
            if (this.pointer < SuppleAtomContainer.this.bonds.size()) {
                return (IElectronContainer)SuppleAtomContainer.this.bonds.get(this.pointer++);
            }
            if (this.pointer < SuppleAtomContainer.this.bonds.size() + SuppleAtomContainer.this.lonePairs.size()) {
                return (IElectronContainer)SuppleAtomContainer.this.lonePairs.get(this.pointer++ - SuppleAtomContainer.this.bonds.size());
            }
            if (this.pointer < SuppleAtomContainer.this.bonds.size() + SuppleAtomContainer.this.lonePairs.size() + SuppleAtomContainer.this.singleElectrons.size()) {
                return (IElectronContainer)SuppleAtomContainer.this.singleElectrons.get(this.pointer++ - SuppleAtomContainer.this.bonds.size() - SuppleAtomContainer.this.lonePairs.size());
            }
            return null;
        }

        @Override
        public void remove() {
            if (this.pointer <= SuppleAtomContainer.this.bonds.size()) {
                SuppleAtomContainer.this.removeBond(--this.pointer);
            } else if (this.pointer <= SuppleAtomContainer.this.bonds.size() + SuppleAtomContainer.this.lonePairs.size()) {
                SuppleAtomContainer.this.removeLonePair(--this.pointer - SuppleAtomContainer.this.bonds.size());
            } else if (this.pointer <= SuppleAtomContainer.this.bonds.size() + SuppleAtomContainer.this.lonePairs.size() + SuppleAtomContainer.this.singleElectrons.size()) {
                SuppleAtomContainer.this.removeSingleElectron(--this.pointer - SuppleAtomContainer.this.bonds.size() - SuppleAtomContainer.this.lonePairs.size());
            }
        }
    }
}

