/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.ChemSequenceManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSetManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.tools.IDCreatorTest")
public abstract class IDCreator {
    private static int REACTION_COUNT = 0;
    private static int ATOM_COUNT = 0;
    private static int BOND_COUNT = 0;
    private static int ATOMCONTAINER_COUNT = 0;
    private static int ATOMCONTAINERSET_COUNT = 0;
    private static int REACTIONSET_COUNT = 0;
    private static int CHEMMODEL_COUNT = 0;
    private static int CHEMSEQUENCE_COUNT = 0;
    private static int CHEMFILE_COUNT = 0;
    private static final String REACTION_PREFIX = "r";
    private static final String ATOM_PREFIX = "a";
    private static final String BOND_PREFIX = "b";
    private static final String ATOMCONTAINER_PREFIX = "m";
    private static final String ATOMCONTAINERSET_PREFIX = "molSet";
    private static final String REACTIONSET_PREFIX = "rset";
    private static final String CHEMMODEL_PREFIX = "model";
    private static final String CHEMSEQUENCE_PREFIX = "seq";
    private static final String CHEMFILE_PREFIX = "file";
    public static final int SET_UNIQUE_POLICY = 0;
    public static final int OBJECT_UNIQUE_POLICY = 1;
    private static int policy = 0;

    public static void setIDPolicy(int policy) {
        IDCreator.policy = policy;
    }

    @TestMethod(value="testCreateIDs_IChemObject,testKeepingIDs,testNoDuplicateCreation,testCallingTwice")
    public static void createIDs(IChemObject chemObject) {
        if (chemObject == null) {
            return;
        }
        IDCreator.resetCounters();
        if (chemObject instanceof IAtomContainer) {
            IDCreator.createIDsForAtomContainer((IAtomContainer)chemObject, null);
        } else if (chemObject instanceof IAtomContainerSet) {
            IDCreator.createIDsForAtomContainerSet((IAtomContainerSet)chemObject, null);
        } else if (chemObject instanceof IReaction) {
            IDCreator.createIDsForReaction((IReaction)chemObject, null);
        } else if (chemObject instanceof IReactionSet) {
            IDCreator.createIDsForReactionSet((IReactionSet)chemObject, null);
        } else if (chemObject instanceof IChemFile) {
            IDCreator.createIDsForChemFile((IChemFile)chemObject, null);
        } else if (chemObject instanceof IChemSequence) {
            IDCreator.createIDsForChemSequence((IChemSequence)chemObject, null);
        } else if (chemObject instanceof IChemModel) {
            IDCreator.createIDsForChemModel((IChemModel)chemObject, null);
        }
    }

    private static void resetCounters() {
        ATOM_COUNT = 0;
        BOND_COUNT = 0;
        ATOMCONTAINER_COUNT = 0;
        ATOMCONTAINERSET_COUNT = 0;
        REACTION_COUNT = 0;
        REACTIONSET_COUNT = 0;
        CHEMMODEL_COUNT = 0;
        CHEMSEQUENCE_COUNT = 0;
        CHEMFILE_COUNT = 0;
    }

    private static int setID(String prefix, int identifier, IChemObject object, List<String> tabuList) {
        ++identifier;
        while (tabuList.contains(prefix + identifier)) {
            ++identifier;
        }
        object.setID(prefix + identifier);
        tabuList.add(prefix + identifier);
        return identifier;
    }

    private static void createIDsForAtomContainer(IAtomContainer container, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = AtomContainerManipulator.getAllIDs(container);
        }
        if (null == container.getID()) {
            ATOMCONTAINER_COUNT = IDCreator.setID(ATOMCONTAINER_PREFIX, ATOMCONTAINER_COUNT, container, tabuList);
        }
        List<String> internalTabuList = AtomContainerManipulator.getAllIDs(container);
        if (policy == 1) {
            ATOM_COUNT = 0;
            BOND_COUNT = 0;
        } else {
            internalTabuList = tabuList;
        }
        for (IAtom atom : container.atoms()) {
            if (null != atom.getID()) continue;
            ATOM_COUNT = IDCreator.setID(ATOM_PREFIX, ATOM_COUNT, atom, internalTabuList);
        }
        for (IBond bond : container.bonds()) {
            if (null != bond.getID()) continue;
            BOND_COUNT = IDCreator.setID(BOND_PREFIX, BOND_COUNT, bond, internalTabuList);
        }
    }

    private static void createIDsForAtomContainerSet(IAtomContainerSet containerSet, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = AtomContainerSetManipulator.getAllIDs(containerSet);
        }
        if (null == containerSet.getID()) {
            ATOMCONTAINERSET_COUNT = IDCreator.setID(ATOMCONTAINERSET_PREFIX, ATOMCONTAINERSET_COUNT, containerSet, tabuList);
        }
        if (policy == 1) {
            ATOM_COUNT = 0;
            BOND_COUNT = 0;
        }
        Iterator<IAtomContainer> acs = containerSet.atomContainers().iterator();
        while (acs.hasNext()) {
            IDCreator.createIDsForAtomContainer(acs.next(), tabuList);
        }
    }

    private static void createIDsForReaction(IReaction reaction, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ReactionManipulator.getAllIDs(reaction);
        }
        if (null == reaction.getID()) {
            REACTION_COUNT = IDCreator.setID(REACTION_PREFIX, REACTION_COUNT, reaction, tabuList);
        }
        if (policy == 1) {
            ATOM_COUNT = 0;
            BOND_COUNT = 0;
        }
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            IDCreator.createIDsForAtomContainer(reactant, tabuList);
        }
        for (IAtomContainer product : reaction.getReactants().atomContainers()) {
            IDCreator.createIDsForAtomContainer(product, tabuList);
        }
        Iterator<IAtomContainer> agents = reaction.getAgents().atomContainers().iterator();
        while (agents.hasNext()) {
            IDCreator.createIDsForAtomContainer(agents.next(), tabuList);
        }
    }

    private static void createIDsForReactionSet(IReactionSet reactionSet, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ReactionSetManipulator.getAllIDs(reactionSet);
        }
        if (null == reactionSet.getID()) {
            REACTIONSET_COUNT = IDCreator.setID(REACTIONSET_PREFIX, REACTIONSET_COUNT, reactionSet, tabuList);
        }
        Iterator<IReaction> reaction = reactionSet.reactions().iterator();
        while (reaction.hasNext()) {
            IDCreator.createIDsForReaction(reaction.next(), tabuList);
        }
    }

    private static void createIDsForChemFile(IChemFile file, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ChemFileManipulator.getAllIDs(file);
        }
        if (null == file.getID()) {
            CHEMFILE_COUNT = IDCreator.setID(CHEMFILE_PREFIX, CHEMFILE_COUNT, file, tabuList);
        }
        if (policy == 1) {
            CHEMSEQUENCE_COUNT = 0;
        }
        for (IChemSequence chemSequence : file.chemSequences()) {
            IDCreator.createIDsForChemSequence(chemSequence, tabuList);
        }
    }

    private static void createIDsForChemSequence(IChemSequence sequence, List<String> tabuList) {
        if (tabuList == null) {
            tabuList = ChemSequenceManipulator.getAllIDs(sequence);
        }
        if (null == sequence.getID()) {
            CHEMSEQUENCE_COUNT = IDCreator.setID(CHEMSEQUENCE_PREFIX, CHEMSEQUENCE_COUNT, sequence, tabuList);
        }
        if (policy == 1) {
            CHEMSEQUENCE_COUNT = 0;
        }
        for (IChemModel chemModel : sequence.chemModels()) {
            IDCreator.createIDsForChemModel(chemModel, tabuList);
        }
    }

    private static void createIDsForChemModel(IChemModel model, List<String> tabuList) {
        IReactionSet reactionSet;
        IMoleculeSet moleculeSet;
        ICrystal crystal;
        if (tabuList == null) {
            tabuList = ChemModelManipulator.getAllIDs(model);
        }
        if (null == model.getID()) {
            CHEMMODEL_COUNT = IDCreator.setID(CHEMMODEL_PREFIX, CHEMMODEL_COUNT, model, tabuList);
        }
        if ((crystal = model.getCrystal()) != null) {
            if (policy == 1) {
                ATOM_COUNT = 0;
                BOND_COUNT = 0;
            }
            IDCreator.createIDsForAtomContainer(crystal, tabuList);
        }
        if ((moleculeSet = model.getMoleculeSet()) != null) {
            if (policy == 1) {
                ATOMCONTAINERSET_COUNT = 0;
                ATOMCONTAINER_COUNT = 0;
            }
            IDCreator.createIDsForAtomContainerSet(moleculeSet, tabuList);
        }
        if ((reactionSet = model.getReactionSet()) != null) {
            if (policy == 1) {
                REACTIONSET_COUNT = 0;
                REACTION_COUNT = 0;
            }
            IDCreator.createIDsForReactionSet(reactionSet, tabuList);
        }
    }
}

