/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.fragments.EStateFragments;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;

@TestClass(value="org.openscience.cdk.fingerprint.EStateFingerprinterTest")
public class EStateFingerprinter
implements IFingerprinter {
    private static final String[] patterns = EStateFragments.getSmarts();

    @TestMethod(value="testFingerprint,testGetSize")
    public EStateFingerprinter() {
    }

    @TestMethod(value="testFingerprint")
    public BitSet getFingerprint(IAtomContainer atomContainer) throws CDKException {
        int bitsetLength = patterns.length;
        BitSet fingerPrint = new BitSet(bitsetLength);
        SMARTSQueryTool sqt = new SMARTSQueryTool("C");
        for (int i = 0; i < patterns.length; ++i) {
            sqt.setSmarts(patterns[i]);
            boolean status = sqt.matches(atomContainer);
            if (!status) continue;
            fingerPrint.set(i, true);
        }
        return fingerPrint;
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return patterns.length;
    }
}

