/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.StructureRecord;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.core.io.IRawReader;
import ambit2.core.processors.structure.MoleculeWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.IChemObjectReaderErrorHandler;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;
import org.openscience.cdk.io.listener.IChemObjectIOListener;
import org.openscience.cdk.io.setting.IOSetting;

public class RawIteratingWrapper<R extends IIteratingChemObjectReader>
implements IRawReader<IStructureRecord> {
    protected R reader;
    protected MoleculeWriter writer;
    protected LiteratureEntry reference;
    protected final IStructureRecord r = new StructureRecord();

    public RawIteratingWrapper(R r) {
        this.reader = r;
        this.writer = new MoleculeWriter();
    }

    public LiteratureEntry getReference() {
        return this.reference;
    }

    public void setReference(LiteratureEntry literatureEntry) {
        this.reference = literatureEntry;
    }

    public void setReader(InputStream inputStream) throws CDKException {
        throw new CDKException("Not implemented");
    }

    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Not implemented");
    }

    @Override
    public IStructureRecord nextRecord() {
        Object object = this.next();
        if (object instanceof IStructureRecord) {
            return (IStructureRecord)object;
        }
        try {
            StructureRecord structureRecord = new StructureRecord(-1, -1, this.writer.process((IAtomContainer)object), "SDF");
            structureRecord.setReference(this.reference);
            return structureRecord;
        }
        catch (Exception exception) {
            StructureRecord structureRecord = new StructureRecord(-1, -1, null, "SDF");
            structureRecord.setReference(this.reference);
            return structureRecord;
        }
    }

    public boolean accepts(Class clazz) {
        return this.reader.accepts(clazz);
    }

    public void addChemObjectIOListener(IChemObjectIOListener iChemObjectIOListener) {
        this.reader.addChemObjectIOListener(iChemObjectIOListener);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public IResourceFormat getFormat() {
        return this.reader.getFormat();
    }

    public IOSetting[] getIOSettings() {
        return this.reader.getIOSettings();
    }

    public void removeChemObjectIOListener(IChemObjectIOListener iChemObjectIOListener) {
        this.reader.removeChemObjectIOListener(iChemObjectIOListener);
    }

    public boolean hasNext() {
        return this.reader.hasNext();
    }

    protected Object transform(Object object) {
        if (object instanceof IAtomContainer) {
            try {
                this.r.clear();
                this.r.setFormat("SDF");
                this.r.setContent(this.writer.process((IAtomContainer)object));
                Object object2 = ((IAtomContainer)object).getProperty((Object)"REFERENCE");
                if (object2 instanceof LiteratureEntry) {
                    this.r.setReference((LiteratureEntry)object2);
                } else {
                    this.r.setReference(this.getReference());
                }
                return this.r;
            }
            catch (Exception exception) {
                this.r.clear();
                this.r.setFormat("SDF");
                this.r.setContent(null);
                this.r.setReference(this.getReference());
                return this.r;
            }
        }
        return object;
    }

    public Object next() {
        Object object = this.reader.next();
        return this.transform(object);
    }

    public void remove() {
        this.reader.remove();
    }

    public void setReaderMode(IChemObjectReader.Mode mode) {
        this.reader.setReaderMode(mode);
    }

    public void setErrorHandler(IChemObjectReaderErrorHandler iChemObjectReaderErrorHandler) {
        this.reader.setErrorHandler(iChemObjectReaderErrorHandler);
    }

    public void handleError(String string) throws CDKException {
        this.reader.handleError(string);
    }

    public void handleError(String string, Exception exception) throws CDKException {
        this.reader.handleError(string, exception);
    }

    public void handleError(String string, int n, int n2, int n3) throws CDKException {
        this.reader.handleError(string, n, n2, n3);
    }

    public void handleError(String string, int n, int n2, int n3, Exception exception) throws CDKException {
        this.reader.handleError(string, n, n2, n3, exception);
    }
}

