/*
 * Decompiled with CFR 0.152.
 */
package signature.display;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import signature.AbstractVertexSignature;
import signature.ColoredTree;
import signature.display.ColoredTreePanel;

public class SignatureViewer
extends JPanel
implements ActionListener {
    private ColoredTreePanel treePanel;
    private JTextField signatureStringField;
    private final int TREE_PANEL_WIDTH = 1200;
    private final int TREE_PANEL_HEIGHT = 500;

    public SignatureViewer() {
        this.setLayout(new BorderLayout());
        this.treePanel = new ColoredTreePanel(1200, 500);
        this.add((Component)this.treePanel, "Center");
        this.signatureStringField = new JTextField();
        this.signatureStringField.addActionListener(this);
        this.add((Component)this.signatureStringField, "South");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.signatureStringField) {
            String signatureString = this.signatureStringField.getText();
            ColoredTree tree = AbstractVertexSignature.parse(signatureString);
            this.treePanel.setDrawKey(true);
            this.treePanel.setTree(tree);
            this.repaint();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Signature Viewer");
        f.add(new SignatureViewer());
        f.pack();
        f.setVisible(true);
    }
}

