/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.junit;

import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.junit.Manifest;
import com.hp.hpl.jena.util.junit.ManifestItemHandler;
import com.hp.hpl.jena.util.junit.TestUtils;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.slf4j.LoggerFactory;

public abstract class TestFactoryManifest
implements ManifestItemHandler {
    private TestSuite currentTestSuite = null;
    private TestSuite testSuite = null;

    public TestSuite process(String filename) {
        return this.oneManifest(filename);
    }

    private TestSuite oneManifest(String filename) {
        TestSuite ts1 = new TestSuite();
        Manifest m = null;
        try {
            m = new Manifest(filename);
        }
        catch (JenaException ex) {
            LoggerFactory.getLogger(TestFactoryManifest.class).warn("Failed to load: " + filename + "\n" + ex.getMessage(), ex);
            ts1.setName("BROKEN");
            return ts1;
        }
        if (m.getName() != null) {
            ts1.setName(TestUtils.safeName(m.getName()));
        } else {
            ts1.setName("Unnamed Manifest");
        }
        Iterator<String> iter = m.includedManifests();
        while (iter.hasNext()) {
            TestSuite ts2;
            String n = iter.next();
            this.currentTestSuite = ts2 = this.oneManifest(n);
            ts1.addTest((Test)ts2);
        }
        this.currentTestSuite = ts1;
        m.apply(this);
        return ts1;
    }

    protected TestSuite getTestSuite() {
        return this.currentTestSuite;
    }

    public final boolean processManifestItem(Resource manifest, Resource item, String testName, Resource action, Resource result) {
        Test t = this.makeTest(manifest, item, testName, action, result);
        if (t != null) {
            this.currentTestSuite.addTest(t);
        }
        return true;
    }

    protected abstract Test makeTest(Resource var1, Resource var2, String var3, Resource var4, Resource var5);
}

