/*
 * Decompiled with CFR 0.152.
 */
package signature.display;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import signature.AbstractVertexSignature;
import signature.ColoredTree;
import signature.display.DisplayableColoredTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeDrawer {
    public static void makeTreeImages(List<String> signatureStrings, String directoryPath, int w, int h) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdir();
        }
        int i = 0;
        for (String signature : signatureStrings) {
            ColoredTree coloredTree = AbstractVertexSignature.parse(signature);
            File file = new File(directory, "signature_" + i + ".png");
            if (file.isDirectory()) {
                System.out.println("DIR");
                return;
            }
            TreeDrawer.makeImage(coloredTree, file, w, h);
            ++i;
        }
    }

    public static void makeImage(ColoredTree coloredTree, File file, int w, int h) {
        DisplayableColoredTree displayTree = new DisplayableColoredTree(coloredTree, w, h);
        BufferedImage image = new BufferedImage(w, h, 1);
        displayTree.paint(image.getGraphics());
        try {
            file.createNewFile();
            ImageIO.write((RenderedImage)image, "PNG", file);
            System.out.println("Made image " + file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }
}

