/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugChemModel
extends ChemModel
implements IChemModel {
    private static final long serialVersionUID = -920209300005079592L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugChemModel.class);

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public Object getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        this.logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.setProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public IMoleculeSet getMoleculeSet() {
        this.logger.debug("Getting setOfMolecules: ", super.getMoleculeSet());
        return super.getMoleculeSet();
    }

    @Override
    public void setMoleculeSet(IMoleculeSet setOfMolecules) {
        this.logger.debug("Setting setOfMolecules: ", setOfMolecules);
        super.setMoleculeSet(setOfMolecules);
    }

    @Override
    public IRingSet getRingSet() {
        this.logger.debug("Getting ringSet: ", super.getRingSet());
        return super.getRingSet();
    }

    @Override
    public void setRingSet(IRingSet ringSet) {
        this.logger.debug("Setting ringSet: ", ringSet);
        super.setRingSet(ringSet);
    }

    @Override
    public ICrystal getCrystal() {
        this.logger.debug("Getting crystal: ", super.getCrystal());
        return super.getCrystal();
    }

    @Override
    public void setCrystal(ICrystal crystal) {
        this.logger.debug("Setting crystal: ", crystal);
        super.setCrystal(crystal);
    }

    @Override
    public IReactionSet getReactionSet() {
        this.logger.debug("Getting setOfReactions: ", super.getReactionSet());
        return super.getReactionSet();
    }

    @Override
    public void setReactionSet(IReactionSet sor) {
        this.logger.debug("Setting setOfReactions: ", sor);
        super.setReactionSet(sor);
    }

    @Override
    @TestMethod(value="testIsEmpty_MoleculeSet,testIsEmpty_RingSet,testIsEmpty_Crystal,testIsEmpty_ReactionSet")
    public boolean isEmpty() {
        boolean res = true;
        if (this.setOfMolecules != null && !this.setOfMolecules.isEmpty()) {
            res = false;
        }
        if (this.setOfReactions != null && !this.setOfReactions.isEmpty()) {
            res = false;
        }
        if (this.ringSet != null && !this.ringSet.isEmpty()) {
            res = false;
        }
        if (this.crystal != null && !this.crystal.isEmpty()) {
            res = false;
        }
        this.logger.debug("Checking if chemModel is empty: ", res);
        return res;
    }
}

