/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.impl;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.RDFRDBException;
import com.hp.hpl.jena.db.impl.DriverRDB;
import com.hp.hpl.jena.db.impl.SQLCache;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class Driver_PostgreSQL
extends DriverRDB {
    public Driver_PostgreSQL() {
        String myPackageName = this.getClass().getPackage().getName();
        this.DATABASE_TYPE = "PostgreSQL";
        this.DRIVER_NAME = "org.postgresql.Driver";
        this.ID_SQL_TYPE = "INTEGER";
        this.URI_COMPRESS = false;
        this.INDEX_KEY_LENGTH = 250;
        this.INDEX_KEY_LENGTH_MAX = 250;
        this.LONG_OBJECT_LENGTH = 250;
        this.LONG_OBJECT_LENGTH_MAX = 250;
        this.TABLE_NAME_LENGTH_MAX = 63;
        this.IS_XACT_DB = true;
        this.PRE_ALLOCATE_ID = true;
        this.SKIP_DUPLICATE_CHECK = false;
        this.SQL_FILE = "etc/postgresql.sql";
        this.QUOTE_CHAR = (char)39;
        this.DB_NAMES_TO_UPPER = false;
        this.setTableNames(this.TABLE_NAME_PREFIX);
        this.m_psetClassName = myPackageName + ".PSet_TripleStore_RDB";
        this.m_psetReifierClassName = myPackageName + ".PSet_ReifStore_RDB";
        this.m_lsetClassName = myPackageName + ".SpecializedGraph_TripleStore_RDB";
        this.m_lsetReifierClassName = myPackageName + ".SpecializedGraphReifier_RDB";
    }

    public void setConnection(IDBConnection dbcon) {
        this.m_dbcon = dbcon;
        try {
            this.m_sql = new SQLCache(this.SQL_FILE, null, dbcon, this.ID_SQL_TYPE);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            logger.error("Unable to set connection for Driver:", e);
        }
    }

    public int graphIdAlloc(String graphName) {
        Object result = null;
        int dbid = 0;
        try {
            dbid = this.getInsertID(this.GRAPH_TABLE);
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement("insertGraph", this.GRAPH_TABLE);
            ps.setInt(1, dbid);
            ps.setString(2, graphName);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to get last inserted ID: " + e);
        }
        return dbid;
    }

    public void graphIdDealloc(int graphId) {
        Object result = null;
        try {
            PreparedStatement ps = this.m_sql.getPreparedSQLStatement("deleteGraph", this.GRAPH_TABLE);
            ps.setInt(1, graphId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RDFRDBException("Failed to delete graph ID: " + e);
        }
    }

    protected void getTblParams(String[] param) {
        if (this.LONG_OBJECT_LENGTH > 4000) {
            throw new RDFRDBException("Long object length specified (" + this.LONG_OBJECT_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        if (this.INDEX_KEY_LENGTH > 4000) {
            throw new RDFRDBException("Index key length specified (" + this.INDEX_KEY_LENGTH + ") exceeds maximum sane length of 4000.");
        }
        String spoColType = "VARCHAR(" + this.LONG_OBJECT_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        param[0] = spoColType;
        String headColType = "VARCHAR(" + this.INDEX_KEY_LENGTH + ")";
        this.STRINGS_TRIMMED = false;
        param[1] = headColType;
        param[2] = this.TABLE_NAME_PREFIX;
    }

    protected String[] getDbInitTablesParams() {
        String[] res = new String[3];
        this.getTblParams(res);
        this.EOS_LEN = this.EOS.length();
        return res;
    }

    protected String[] getCreateTableParams(int graphId, boolean isReif) {
        String[] parms = new String[3];
        String[] res = new String[2];
        this.getTblParams(parms);
        int tblCnt = this.getTableCount(graphId);
        res[0] = this.genTableName(graphId, tblCnt, isReif);
        res[1] = parms[0];
        return res;
    }

    public String genSQLStringMatchOp_IC(String fun) {
        return "I" + this.genSQLLikeKW();
    }
}

