/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts.processors;

import ambit2.base.exceptions.AmbitException;
import ambit2.base.processors.DefaultAmbitProcessor;
import ambit2.core.processors.structure.AtomConfigurator;
import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.QuerySequenceElement;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.SmartsScreeningKeys;
import java.util.BitSet;
import java.util.Vector;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;

public class StructureKeysBitSetGenerator
extends DefaultAmbitProcessor<IAtomContainer, BitSet> {
    protected IsomorphismTester isoTester = new IsomorphismTester();
    protected static Vector<QueryAtomContainer> smartsQueries = null;
    protected static Vector<Vector<QuerySequenceElement>> sequences = null;
    protected static Vector<String> smartsKeys;
    protected static int nKeys;
    protected AtomConfigurator cfg = new AtomConfigurator();
    protected CDKHueckelAromaticityDetector aromaticDetector = new CDKHueckelAromaticityDetector();
    protected boolean cleanKekuleBonds = true;
    private static final long serialVersionUID = 696373923085520847L;

    public boolean isCleanKekuleBonds() {
        return this.cleanKekuleBonds;
    }

    public void setCleanKekuleBonds(boolean cleanKekuleBonds) {
        this.cleanKekuleBonds = cleanKekuleBonds;
    }

    public StructureKeysBitSetGenerator() throws Exception {
        if (smartsQueries == null || sequences == null) {
            smartsQueries = new Vector();
            sequences = new Vector();
            SmartsScreeningKeys smartsScrKeys = new SmartsScreeningKeys();
            nKeys = smartsScrKeys.nKeys;
            this.prepareKeySequences(smartsScrKeys.getKeys(), smartsScrKeys.nKeys);
        }
    }

    public StructureKeysBitSetGenerator(Vector<String> externalSmartsKeys) throws Exception {
        this.setSmartsKeys(externalSmartsKeys);
    }

    public void setSmartsKeys(Vector<String> smartsKeys) {
        this.prepareKeySequences(smartsKeys, smartsKeys.size());
    }

    protected synchronized void prepareKeySequences(Vector<String> keys, int nKeys) {
        smartsKeys = keys;
        sequences.clear();
        smartsQueries.clear();
        SmartsParser parser = new SmartsParser();
        for (int i = 0; i < nKeys; ++i) {
            QueryAtomContainer query = parser.parse(smartsKeys.get(i));
            this.isoTester.setQuery(query);
            Vector<QuerySequenceElement> sequence = this.isoTester.transferSequenceToOwner();
            sequences.add(sequence);
            smartsQueries.add(query);
        }
    }

    public BitSet process(IAtomContainer target) throws AmbitException {
        try {
            IAtomContainer ac = this.cfg.process(target);
            CDKHueckelAromaticityDetector.detectAromaticity((IAtomContainer)ac);
            return this.getStructureKeyBits(ac);
        }
        catch (CDKException x) {
            throw new AmbitException(x.getMessage());
        }
        catch (AmbitException x) {
            throw x;
        }
        catch (Exception x) {
            throw new AmbitException((Throwable)x);
        }
    }

    protected synchronized BitSet getStructureKeyBits(IAtomContainer ac) {
        for (IBond bond : ac.bonds()) {
            if (!bond.getFlag(5)) continue;
            for (IAtom a : bond.atoms()) {
                a.setFlag(5, true);
            }
            if (!this.cleanKekuleBonds) continue;
            bond.setOrder(IBond.Order.SINGLE);
        }
        BitSet keys = new BitSet(nKeys);
        for (int i = 0; i < nKeys; ++i) {
            this.isoTester.setSequence(smartsQueries.get(i), sequences.get(i));
            boolean res = this.isoTester.hasIsomorphism(ac);
            keys.set(i, res);
        }
        return keys;
    }

    public static String getKey(int index) {
        return smartsKeys.get(index);
    }

    public static int indexOf(String key) {
        return smartsKeys.indexOf(key);
    }
}

