/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.processors.structure.key;

import ambit2.base.data.Property;
import ambit2.base.exceptions.AmbitException;
import ambit2.base.interfaces.IStructureRecord;
import ambit2.core.processors.structure.key.PropertyKey;

public class DSSToxRID
extends PropertyKey<Number> {
    private static final long serialVersionUID = 2117618200041344844L;

    public DSSToxRID() {
        super(Property.getInstance((String)"DSSTox_RID", (String)"DSSTox", (String)"http://www.epa.gov/NCCT/dsstox/StandardChemFieldDefTable.html#DSSTox_RID"));
    }

    @Override
    protected boolean isValid(Object object, Object object2) {
        if (object != null) {
            object = object.toString();
            if (this.key.getName().equals(object)) {
                try {
                    return Integer.parseInt(object2.toString()) > 0;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Number process(IStructureRecord iStructureRecord) throws AmbitException {
        Object Result2 = super.process(iStructureRecord);
        if (Result2 == null) {
            return null;
        }
        try {
            return new Integer(Result2.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new AmbitException((Throwable)numberFormatException);
        }
    }

    @Override
    public Object getQueryKey() {
        return this.getKey();
    }

    @Override
    public Class getType() {
        return Integer.class;
    }
}

