/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.groups;

import ambit2.core.groups.ISGroup;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;

public abstract class AbstractGroup
extends PseudoAtom
implements ISGroup {
    private static final long serialVersionUID = -151920308613450648L;
    protected List<IAtom> atoms = null;
    protected List<IBond> bonds = null;
    protected int number;

    public AbstractGroup() {
        this("Group");
    }

    public AbstractGroup(String string) {
        super(string);
    }

    public AbstractGroup(String string, int n) {
        this(string);
        this.setNumber(n);
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(int n) {
        this.number = n;
    }

    @Override
    public int compareTo(ISGroup iSGroup) {
        return this.getNumber() - iSGroup.getNumber();
    }

    public boolean equals(Object object) {
        if (object instanceof ISGroup) {
            return this.compareTo((ISGroup)object) == 0;
        }
        try {
            return this.getNumber() == Integer.parseInt(object.toString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public IAtom addAtom(IAtom iAtom) {
        if (this.atoms == null) {
            this.atoms = new ArrayList<IAtom>();
        }
        this.atoms.add(iAtom);
        return iAtom;
    }

    @Override
    public IBond addBond(IBond iBond) {
        if (this.bonds == null) {
            this.bonds = new ArrayList<IBond>();
        }
        this.bonds.add(iBond);
        return iBond;
    }

    @Override
    public void finalizeAtomList(IAtomContainer iAtomContainer) {
    }

    @Override
    public void setSubscript(String string) {
        this.setLabel(string);
    }

    @Override
    public String getSubscript() {
        return this.getLabel();
    }

    @Override
    public void addBrackets(double d, double d2, double d3, double d4) {
    }

    @Override
    public Iterable<IAtom> getAtoms(boolean bl) {
        if (bl) {
            return new Iterable<IAtom>(){

                @Override
                public Iterator<IAtom> iterator() {
                    return AbstractGroup.this.atoms.iterator();
                }
            };
        }
        return new SelfIterable<IAtom>(this);
    }

    @Override
    public Iterable<IBond> getBonds(boolean bl) {
        if (bl) {
            return new Iterable<IBond>(){

                @Override
                public Iterator<IBond> iterator() {
                    return new EmptyIterator<IBond>();
                }
            };
        }
        return new Iterable<IBond>(){

            @Override
            public Iterator<IBond> iterator() {
                return AbstractGroup.this.bonds.iterator();
            }
        };
    }

    public boolean isExpanded(IBond iBond) {
        return this.bonds.contains(iBond);
    }

    public static void setGroupVisible(IChemObject iChemObject, boolean bl) {
        iChemObject.setProperty((Object)"ambit2.groups.ISGroup.visible", (Object)new Boolean(bl));
    }

    public static boolean isGroupVisible(IChemObject iChemObject) {
        Object object = iChemObject.getProperty((Object)"ambit2.groups.ISGroup.visible");
        if (object == null || !(object instanceof Boolean)) {
            return false;
        }
        return (Boolean)object;
    }

    public void addBondsConnected2Atoms(IAtomContainer iAtomContainer, List<IAtom> list, List<IBond> list2) {
        for (int i = 0; i < list.size(); ++i) {
            IAtom iAtom = list.get(i);
            List list3 = iAtomContainer.getConnectedBondsList(iAtom);
            for (int j = 0; j < list3.size(); ++j) {
                IBond iBond = (IBond)list3.get(j);
                IAtom iAtom2 = iBond.getConnectedAtom(iAtom);
                if (!list.contains(iAtom2) || list2.contains(iBond)) continue;
                list2.add(iBond);
            }
        }
    }

    protected class EmptyIterator<T>
    implements Iterator<T> {
        protected EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class SelfIterable<T>
    implements Iterable<T> {
        protected T atom;

        public SelfIterable(T t) {
            this.atom = t;
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index++ == 0;
                }

                @Override
                public T next() {
                    return SelfIterable.this.atom;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

