/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.exceptions.AmbitIOException;
import ambit2.core.io.RawIteratingFolderReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipReader
extends RawIteratingFolderReader {
    static final int BUFFER = 2048;

    public ZipReader(File file) throws AmbitIOException {
        super(ZipReader.unzip(file, ZipReader.getTempFolder()));
    }

    public ZipReader(InputStream inputStream) throws AmbitIOException {
        super(ZipReader.unzip(inputStream, ZipReader.getTempFolder()));
    }

    public static File getTempFolder() throws AmbitIOException {
        try {
            File file = new File(String.format("%s/%s", System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString()));
            file.deleteOnExit();
            file.mkdir();
            return file;
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
    }

    public static File[] unzip(File file, File file2) throws AmbitIOException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            File[] fileArray = ZipReader.unzip(fileInputStream, file2);
            return fileArray;
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static File[] unzip(InputStream inputStream, File file) throws AmbitIOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            ZipEntry zipEntry;
            BufferedOutputStream bufferedOutputStream = null;
            ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(inputStream));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (zipEntry.isDirectory()) continue;
                byte[] byArray = new byte[2048];
                File file2 = new File(file, zipEntry.getName());
                try {
                    file2.getParentFile().mkdirs();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                file2.deleteOnExit();
                arrayList.add(file2);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 2048);
                while ((n = zipInputStream.read(byArray, 0, 2048)) != -1) {
                    bufferedOutputStream.write(byArray, 0, n);
                }
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            throw new AmbitIOException((Throwable)exception);
        }
        return arrayList == null ? null : (arrayList.size() == 0 ? null : arrayList.toArray(new File[arrayList.size()]));
    }
}

