/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.HINFormatTest")
public class HINFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    private HINFormat() {
    }

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new HINFormat();
        }
        return myself;
    }

    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "HyperChem HIN";
    }

    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return null;
    }

    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"hin"};
    }

    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.HINReader";
    }

    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return "org.openscience.cdk.io.HINWriter";
    }

    public boolean matches(int lineNumber, String line) {
        StringTokenizer tokenizer;
        return line.startsWith("atom ") && (line.endsWith(" s") || line.endsWith(" d") || line.endsWith(" t") || line.endsWith(" a")) && (tokenizer = new StringTokenizer(line, " ")).countTokens() % 2 == 0;
    }

    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 0x200;
    }

    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 26;
    }
}

