/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.SmartsConst;
import ambit2.smarts.SmartsExpressionToken;
import ambit2.smarts.SmartsHelper;
import ambit2.smarts.SmartsLogicalExpression;
import java.util.List;
import java.util.Vector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.smarts.SMARTSAtom;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class SmartsAtomExpression
extends SMARTSAtom {
    private static final long serialVersionUID = -123453467895564563L;
    public Vector<SmartsExpressionToken> tokens = new Vector();
    public Vector<String> recSmartsStrings = new Vector();
    public Vector<QueryAtomContainer> recSmartsContainers = new Vector();
    public Vector<Vector<IAtom>> recSmartsMatches = null;

    public boolean matches(IAtom atom) {
        SmartsLogicalExpression sle = new SmartsLogicalExpression();
        for (int i = 0; i < this.tokens.size(); ++i) {
            SmartsExpressionToken tok = this.tokens.get(i);
            if (tok.type < 1000) {
                sle.addArgument(this.getArgument(tok, atom));
                continue;
            }
            sle.addLogOperation(tok.type - 1000);
        }
        return sle.getValue();
    }

    public SmartsExpressionToken getLastToken() {
        return this.tokens.lastElement();
    }

    boolean getArgument(SmartsExpressionToken tok, IAtom atom) {
        switch (tok.type) {
            case 0: {
                return true;
            }
            case 1: {
                if (atom.getFlag(5)) {
                    if (tok.param == 0) {
                        return true;
                    }
                    return SmartsConst.elSymbols[tok.param].equals(atom.getSymbol());
                }
                return false;
            }
            case 2: {
                if (!atom.getFlag(5)) {
                    if (tok.param == 0) {
                        return true;
                    }
                    return SmartsConst.elSymbols[tok.param].equals(atom.getSymbol());
                }
                return false;
            }
            case 3: {
                return tok.param == atom.getFormalNeighbourCount();
            }
            case 8: {
                return tok.param == atom.getValency();
            }
            case 9: {
                Integer hci = atom.getImplicitHydrogenCount();
                int hc = 0;
                if (hci != null) {
                    hc = hci;
                }
                return tok.param == atom.getFormalNeighbourCount() + hc;
            }
            case 4: {
                Integer explicitH;
                Integer hci = atom.getImplicitHydrogenCount();
                int totalH = 0;
                if (hci != null) {
                    totalH = hci;
                }
                if ((explicitH = (Integer)atom.getProperty((Object)"ExplicitH")) != null) {
                    totalH += explicitH.intValue();
                }
                return tok.param == totalH;
            }
            case 6: {
                int[] atomRings = (int[])atom.getProperty((Object)"RingData");
                return this.match_R(atomRings, tok.param, atom);
            }
            case 7: {
                int[] atomRings2 = (int[])atom.getProperty((Object)"RingData");
                return this.match_r(atomRings2, tok.param, atom);
            }
            case 13: {
                if (atom.getMassNumber() == null) {
                    return false;
                }
                if (atom.getMassNumber() == 0) {
                    return false;
                }
                return atom.getMassNumber() == tok.param;
            }
            case 10: {
                return atom.getFormalCharge() == tok.param;
            }
            case 11: {
                return SmartsConst.elSymbols[tok.param].equals(atom.getSymbol());
            }
            case 12: {
                if (tok.param == 1001) {
                    if (atom.getStereoParity() == -1) {
                        return false;
                    }
                    if (atom.getStereoParity() == 1) {
                        return true;
                    }
                    return true;
                }
                if (tok.param == 1002) {
                    if (atom.getStereoParity() == -1) {
                        return true;
                    }
                    return atom.getStereoParity() != 1;
                }
                return true;
            }
            case 14: {
                if (this.recSmartsMatches == null) {
                    return true;
                }
                Vector<IAtom> atomMaps = this.recSmartsMatches.get(tok.param);
                for (int i = 0; i < atomMaps.size(); ++i) {
                    if (atomMaps.get(i) != atom) continue;
                    return true;
                }
                return false;
            }
            case 15: {
                return this.match_x(tok.param, atom);
            }
            case 16: {
                return this.match_iMOE(tok.param, atom);
            }
            case 17: {
                return this.match_GMOE(tok.param, atom);
            }
            case 18: {
                return this.match_XMOE(atom);
            }
            case 19: {
                return this.match_NMOE(atom);
            }
            case 20: {
                return this.match_vMOE(tok.param, atom);
            }
            case 21: {
                return this.match_OB_Hybr(tok.param, atom);
            }
        }
        return true;
    }

    String tokenToString(SmartsExpressionToken tok) {
        if (tok.type >= 1000) {
            return Character.toString(SmartsConst.LogOperationChars[tok.type - 1000]);
        }
        switch (tok.type) {
            case 0: {
                return "*";
            }
            case 1: {
                if (tok.param > 0) {
                    return SmartsConst.elSymbols[tok.param].toLowerCase();
                }
                return "a";
            }
            case 2: {
                if (tok.param > 0) {
                    return SmartsConst.elSymbols[tok.param];
                }
                return "A";
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 15: 
            case 20: {
                String s = Character.toString(SmartsConst.AtomPrimChars[tok.type]);
                if (tok.param != 1) {
                    s = s + tok.param;
                }
                return s;
            }
            case 21: {
                String sOBHybr = Character.toString(SmartsConst.AtomPrimChars[tok.type]);
                sOBHybr = sOBHybr + tok.param;
                return sOBHybr;
            }
            case 16: {
                return "i";
            }
            case 17: {
                String sG = "G";
                sG = sG + tok.param;
                return sG;
            }
            case 18: {
                return "#X";
            }
            case 19: {
                return "#N";
            }
            case 10: {
                String s1 = tok.param > 0 ? "+" : "-";
                if (Math.abs(tok.param) != 1) {
                    s1 = s1 + Math.abs(tok.param);
                }
                return s1;
            }
            case 11: {
                return "#" + tok.param;
            }
            case 12: {
                if (tok.param == 1) {
                    return "@";
                }
                return "@@";
            }
            case 13: {
                return "" + tok.param;
            }
            case 14: {
                if (this.recSmartsContainers.isEmpty()) {
                    return "$()";
                }
                SmartsHelper sw = new SmartsHelper(SilentChemObjectBuilder.getInstance());
                return "$(" + sw.toSmarts(this.recSmartsContainers.get(tok.param)) + ")";
            }
        }
        return "";
    }

    public boolean match_R(int[] atomRings, int param, IAtom atom) {
        if (atomRings == null) {
            return param == 0;
        }
        if (param == -1) {
            return atomRings.length > 0;
        }
        return param == atomRings.length;
    }

    public boolean match_r(int[] atomRings, int param, IAtom atom) {
        if (atomRings == null) {
            return param == 0;
        }
        if (param < 3) {
            return atomRings.length > 0;
        }
        for (int i = 0; i < atomRings.length; ++i) {
            if (atomRings[i] != param) continue;
            return true;
        }
        return false;
    }

    public boolean match_x(int param, IAtom atom) {
        int[] atomRings = (int[])atom.getProperty((Object)"RingData2");
        if (atomRings == null) {
            return false;
        }
        IAtomContainer mol = (IAtomContainer)atom.getProperty((Object)"ParentMoleculeData");
        List ca = mol.getConnectedAtomsList(atom);
        int rbonds = 0;
        for (int i = 0; i < ca.size(); ++i) {
            int[] atrings = (int[])((IAtom)ca.get(i)).getProperty((Object)"RingData2");
            if (atrings == null || !this.commonRingBond(atomRings, atrings)) continue;
            ++rbonds;
        }
        if (param == -1) {
            return rbonds > 0;
        }
        return param == rbonds;
    }

    public boolean match_iMOE(int param, IAtom atom) {
        if (atom.getFlag(5)) {
            return true;
        }
        IAtomContainer mol = (IAtomContainer)atom.getProperty((Object)"ParentMoleculeData");
        List ca = mol.getConnectedAtomsList(atom);
        for (int i = 0; i < ca.size(); ++i) {
            IBond b = mol.getBond(atom, (IAtom)ca.get(i));
            if (b.getOrder() != IBond.Order.DOUBLE && b.getOrder() != IBond.Order.TRIPLE) continue;
            return true;
        }
        return false;
    }

    public boolean match_GMOE(int param, IAtom atom) {
        if (param == 4) {
            return atom.getSymbol().equals("C") || atom.getSymbol().equals("Si") || atom.getSymbol().equals("Ge") || atom.getSymbol().equals("Sn") || atom.getSymbol().equals("Pb");
        }
        if (param == 6) {
            return atom.getSymbol().equals("O") || atom.getSymbol().equals("S") || atom.getSymbol().equals("Ge") || atom.getSymbol().equals("Te") || atom.getSymbol().equals("Po");
        }
        if (param == 7) {
            return atom.getSymbol().equals("F") || atom.getSymbol().equals("Cl") || atom.getSymbol().equals("Br") || atom.getSymbol().equals("I") || atom.getSymbol().equals("At");
        }
        return false;
    }

    public boolean match_XMOE(IAtom atom) {
        return !atom.getSymbol().equals("H") && !atom.getSymbol().equals("C");
    }

    public boolean match_NMOE(IAtom atom) {
        return atom.getSymbol().equals("O") || atom.getSymbol().equals("N") || atom.getSymbol().equals("F") || atom.getSymbol().equals("Cl") || atom.getSymbol().equals("Br");
    }

    public boolean match_vMOE(int param, IAtom atom) {
        int nB = 0;
        IAtomContainer mol = (IAtomContainer)atom.getProperty((Object)"ParentMoleculeData");
        List ca = mol.getConnectedAtomsList(atom);
        for (int i = 0; i < ca.size(); ++i) {
            IAtom a = (IAtom)ca.get(i);
            if (a.getSymbol().equals("H")) continue;
            ++nB;
        }
        return nB == param;
    }

    public boolean match_OB_Hybr(int param, IAtom atom) {
        if (atom.getFlag(5)) {
            return param == 2;
        }
        IAtomContainer mol = (IAtomContainer)atom.getProperty((Object)"ParentMoleculeData");
        List ca = mol.getConnectedAtomsList(atom);
        int nDB = 0;
        int nTB = 0;
        for (int i = 0; i < ca.size(); ++i) {
            IBond b = mol.getBond(atom, (IAtom)ca.get(i));
            if (b.getOrder() == IBond.Order.DOUBLE) {
                ++nDB;
                continue;
            }
            if (b.getOrder() != IBond.Order.TRIPLE) continue;
            ++nTB;
        }
        return param == 3 ? nDB == 0 && nTB == 0 : (param == 2 ? nDB == 1 && nTB == 0 : nDB == 2 || nTB == 1);
    }

    boolean commonRingBond(int[] atomRingData1, int[] atomRingData2) {
        for (int i = 0; i < atomRingData1.length; ++i) {
            int k = 0;
            while (k < atomRingData2.length) {
                if (atomRingData1[i] == atomRingData1[k]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.tokens.size(); ++i) {
            sb.append(this.tokenToString(this.tokens.get(i)));
        }
        sb.append("]");
        return sb.toString();
    }
}

