/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.interfaces.IAtomType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MM2BasedParameterSetReader {
    private String configFile = "org/openscience/cdk/modeling/forcefield/data/mm2.prm";
    private InputStream ins = null;
    private Map<String, Object> parameterSet = new Hashtable<String, Object>();
    private List<IAtomType> atomTypes = new Vector<IAtomType>();
    private StringTokenizer st;
    private String key = "";

    public Map<String, Object> getParamterSet() {
        return this.parameterSet;
    }

    public List<IAtomType> getAtomTypes() {
        return this.atomTypes;
    }

    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    private void setForceFieldDefinitions() throws Exception {
        String sid = this.st.nextToken();
        String svalue = this.st.nextToken();
        if (sid.equals(">bontunit")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">bond-cubic")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">bond-quartic")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">angleunit")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">angle-sextic")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">strbndunit")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">opbendunit")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">torsionunit")) {
            try {
                double value1 = new Double(svalue);
                this.key = sid.substring(1);
                this.parameterSet.put(this.key, new Double(value1));
            }
            catch (NumberFormatException nfe) {
                throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
            }
        }
        if (sid.equals(">vdwtype")) {
            this.key = sid.substring(1);
            this.parameterSet.put(this.key, svalue);
        } else if (sid.equals(">radiusrule")) {
            this.key = sid.substring(1);
            this.parameterSet.put(this.key, svalue);
        } else if (sid.equals(">radiustype")) {
            this.key = sid.substring(1);
            this.parameterSet.put(this.key, svalue);
        } else if (sid.equals(">radiussize")) {
            this.key = sid.substring(1);
            this.parameterSet.put(this.key, svalue);
        } else if (sid.equals(">epsilonrule")) {
            this.key = sid.substring(1);
            this.parameterSet.put(this.key, svalue);
        } else {
            if (sid.equals(">a-expterm")) {
                try {
                    this.key = sid.substring(1);
                    this.parameterSet.put(this.key, svalue);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
                }
            }
            if (sid.equals("b-expterm")) {
                try {
                    this.key = sid.substring(1);
                    this.parameterSet.put(this.key, svalue);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
                }
            }
            if (sid.equals(">c-expterm")) {
                try {
                    double value1 = new Double(svalue);
                    this.key = sid.substring(1);
                    this.parameterSet.put(this.key, new Double(value1));
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
                }
            }
            if (sid.equals(">vdw-14-scale")) {
                try {
                    double value1 = new Double(svalue);
                    this.key = sid.substring(1);
                    this.parameterSet.put(this.key, new Double(value1));
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
                }
            }
            if (sid.equals(">chg-14-scale")) {
                try {
                    double value1 = new Double(svalue);
                    this.key = sid.substring(1);
                    this.parameterSet.put(this.key, new Double(value1));
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
                }
            }
            if (sid.equals(">dielectric")) {
                try {
                    double value1 = new Double(svalue);
                    this.key = sid.substring(1);
                    this.parameterSet.put(this.key, new Double(value1));
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
                }
            }
        }
    }

    private void setAtomTypes() throws Exception {
        String name = "";
        String rootType = "";
        int an = 0;
        int rl = 255;
        int gl = 20;
        int bl = 147;
        int maxbond = 0;
        double mass = 0.0;
        this.st.nextToken();
        String sid = this.st.nextToken();
        rootType = this.st.nextToken();
        name = this.st.nextToken();
        String san = this.st.nextToken();
        String sam = this.st.nextToken();
        String smaxbond = this.st.nextToken();
        try {
            mass = new Double(sam);
            an = Integer.parseInt(san);
            maxbond = Integer.parseInt(smaxbond);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("AtomTypeTable.ReadAtypes: Malformed Number");
        }
        AtomType atomType = new AtomType(name, rootType);
        atomType.setAtomicNumber(an);
        atomType.setExactMass(mass);
        atomType.setFormalNeighbourCount(maxbond);
        atomType.setSymbol(rootType);
        Color co = new Color(rl, gl, bl);
        atomType.setProperty("org.openscience.cdk.renderer.color", co);
        atomType.setAtomTypeName(sid);
        this.atomTypes.add(atomType);
    }

    private void setvdWaals() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid = this.st.nextToken();
        String sradius = this.st.nextToken();
        String sepsi = this.st.nextToken();
        try {
            double epsi = new Double(sepsi);
            double radius = new Double(sradius);
            data.add(new Double(radius));
            data.add(new Double(epsi));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("VdWaalsTable.ReadvdWaals: Malformed Number");
        }
        this.key = "vdw" + sid;
        this.parameterSet.put(this.key, data);
    }

    private void setvdWaalpr() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("VdWaalsTable.ReadvdWaalsPR:Malformed Number due to" + nfe.toString());
        }
        this.key = "vdwpr" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    private void setBond() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setBond: Malformed Number");
        }
        this.key = "bond" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    private void setBond3() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setBond3: Malformed Number");
        }
        this.key = "bond3_" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    private void setBond4() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setBond4: Malformed Number");
        }
        this.key = "bond4_" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    private void setAngle() throws Exception {
        Vector data = new Vector();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        String value3 = this.st.nextToken();
        String value4 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            double va4 = new Double(value4);
            data.add(new Double(va1));
            data.add(new Double(va2));
            data.add(new Double(va3));
            data.add(new Double(va4));
            this.key = "angle" + sid1 + ";" + sid2 + ";" + sid3;
            if (this.parameterSet.containsKey(this.key)) {
                data = (Vector)this.parameterSet.get(this.key);
                data.add(new Double(va1));
                data.add(new Double(va2));
                data.add(new Double(va3));
                data.add(new Double(va4));
            }
            this.parameterSet.put(this.key, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setAngle: Malformed Number");
        }
    }

    private void setAngle3() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        String value3 = this.st.nextToken();
        String value4 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            double va4 = new Double(value4);
            data.add(new Double(va1));
            data.add(new Double(va2));
            data.add(new Double(va3));
            data.add(new Double(va4));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setAngle3: Malformed Number");
        }
        this.key = "angle3_" + sid1 + ";" + sid2 + ";" + sid3;
        this.parameterSet.put(this.key, data);
    }

    private void setAngle4() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        String value3 = this.st.nextToken();
        String value4 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            double va4 = new Double(value4);
            data.add(new Double(va1));
            data.add(new Double(va2));
            data.add(new Double(va3));
            data.add(new Double(va4));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setAngle4: Malformed Number");
        }
        this.key = "angle4_" + sid1 + ";" + sid2 + ";" + sid3;
        this.parameterSet.put(this.key, data);
    }

    private void setStrBnd() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String value1 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            data.add(new Double(va1));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setStrBnd: Malformed Number");
        }
        this.key = "strbnd" + sid1;
        this.parameterSet.put(this.key, data);
    }

    private void setOpBend() throws Exception {
        Vector data = new Vector();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            data.add(new Double(va1));
            this.key = "opbend" + sid1 + ";" + sid2;
            if (this.parameterSet.containsKey(this.key)) {
                data = (Vector)this.parameterSet.get(this.key);
                data.add(new Double(va1));
            }
            this.parameterSet.put(this.key, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setOpBend: Malformed Number");
        }
    }

    private void setTorsion() throws Exception {
        Vector data = new Vector();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String sid4 = this.st.nextToken();
        String value1 = this.st.nextToken();
        this.st.nextToken();
        this.st.nextToken();
        String value2 = this.st.nextToken();
        this.st.nextToken();
        this.st.nextToken();
        String value3 = this.st.nextToken();
        this.st.nextToken();
        this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            data.add(new Double(va1));
            data.add(new Double(va2));
            data.add(new Double(va3));
            this.key = "torsion" + sid1 + ";" + sid2 + ";" + sid3 + ";" + sid4;
            if (this.parameterSet.containsKey(this.key)) {
                data = (Vector)this.parameterSet.get(this.key);
                data.add(new Double(va1));
                data.add(new Double(va2));
                data.add(new Double(va3));
            }
            this.parameterSet.put(this.key, data);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setTorsion: Malformed Number");
        }
    }

    private void setTorsion4() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String sid3 = this.st.nextToken();
        String sid4 = this.st.nextToken();
        String value1 = this.st.nextToken();
        this.st.nextToken();
        this.st.nextToken();
        String value2 = this.st.nextToken();
        this.st.nextToken();
        this.st.nextToken();
        String value3 = this.st.nextToken();
        this.st.nextToken();
        this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            data.add(new Double(va1));
            data.add(new Double(va2));
            data.add(new Double(va3));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setTorsion4: Malformed Number");
        }
        this.key = "torsion4_" + sid1 + ";" + sid2 + ";" + sid3 + ";" + sid4;
        this.parameterSet.put(this.key, data);
    }

    private void setCharge() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String value1 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            data.add(new Double(va1));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setCharge: Malformed Number due to " + nfe.toString());
        }
        this.key = "charge" + sid1;
        this.parameterSet.put(this.key, data);
    }

    private void setDipole() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setDipole: Malformed Number");
        }
        this.key = "dipole" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    private void setDipole3() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setDipole3: Malformed Number");
        }
        this.key = "dipole3_" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    private void setPiAtom() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        String value3 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            double va3 = new Double(value3);
            data.add(new Double(va1));
            data.add(new Double(va2));
            data.add(new Double(va3));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setPiAtom: Malformed Number");
        }
        this.key = "piatom" + sid1;
        this.parameterSet.put(this.key, data);
    }

    private void setPiBond() throws Exception {
        Vector<Double> data = new Vector<Double>();
        this.st.nextToken();
        String sid1 = this.st.nextToken();
        String sid2 = this.st.nextToken();
        String value1 = this.st.nextToken();
        String value2 = this.st.nextToken();
        try {
            double va1 = new Double(value1);
            double va2 = new Double(value2);
            data.add(new Double(va1));
            data.add(new Double(va2));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("setPiBond: Malformed Number");
        }
        this.key = "pibond" + sid1 + ";" + sid2;
        this.parameterSet.put(this.key, data);
    }

    public void readParameterSets() throws Exception {
        if (this.ins == null) {
            this.ins = this.getClass().getResourceAsStream(this.configFile);
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting the default stream: " + this.configFile);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(this.ins), 1024);
        int[] a = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        try {
            String s;
            while ((s = r.readLine()) != null) {
                this.st = new StringTokenizer(s, "\t ;");
                int nt = this.st.countTokens();
                if (s.startsWith(">") & nt > 1) {
                    this.setForceFieldDefinitions();
                    a[0] = a[0] + 1;
                    continue;
                }
                if (s.startsWith("atom") & nt <= 8) {
                    a[0] = a[0] + 1;
                    this.setAtomTypes();
                    continue;
                }
                if (s.startsWith("vdw ") & nt <= 5) {
                    this.setvdWaals();
                    a[1] = a[1] + 1;
                    continue;
                }
                if (s.startsWith("vdwpr ") & nt <= 6) {
                    this.setvdWaalpr();
                    a[2] = a[2] + 1;
                    continue;
                }
                if (s.startsWith("bond ") & nt <= 7) {
                    this.setBond();
                    a[3] = a[3] + 1;
                    continue;
                }
                if (s.startsWith("bond4 ") & nt == 5) {
                    this.setBond4();
                    a[4] = a[4] + 1;
                    continue;
                }
                if (s.startsWith("bond3 ") & nt == 5) {
                    this.setBond3();
                    a[5] = a[5] + 1;
                    continue;
                }
                if (s.startsWith("angle ") & nt == 8) {
                    this.setAngle();
                    a[6] = a[6] + 1;
                    continue;
                }
                if (s.startsWith("angle4 ") & nt == 8) {
                    this.setAngle4();
                    a[17] = a[17] + 1;
                    continue;
                }
                if (s.startsWith("angle3 ") & nt == 8) {
                    this.setAngle3();
                    a[7] = a[7] + 1;
                    continue;
                }
                if (s.startsWith("strbnd ") & nt == 5) {
                    this.setStrBnd();
                    a[8] = a[8] + 1;
                    continue;
                }
                if (s.startsWith("opbend ") & nt == 4) {
                    this.setOpBend();
                    a[9] = a[9] + 1;
                    continue;
                }
                if (s.startsWith("torsion ") & nt == 14) {
                    this.setTorsion();
                    a[10] = a[10] + 1;
                    continue;
                }
                if (s.startsWith("torsion4 ") & nt == 14) {
                    this.setTorsion4();
                    a[11] = a[11] + 1;
                    continue;
                }
                if (s.startsWith("charge ") & nt == 3) {
                    this.setCharge();
                    a[12] = a[12] + 1;
                    continue;
                }
                if (s.startsWith("dipole ") & nt == 5) {
                    this.setDipole();
                    a[13] = a[13] + 1;
                    continue;
                }
                if (s.startsWith("dipole3 ") & nt == 5) {
                    this.setDipole3();
                    a[14] = a[14] + 1;
                    continue;
                }
                if (s.startsWith("piatom ") & nt == 5) {
                    this.setPiAtom();
                    a[15] = a[15] + 1;
                    continue;
                }
                if (!(s.startsWith("pibond ") & nt == 5)) continue;
                this.setPiBond();
                a[16] = a[16] + 1;
            }
            this.ins.close();
        }
        catch (IOException e) {
            throw new IOException("There was a problem parsing the mm2 forcefield due to:" + e.toString());
        }
    }
}

