/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import libpadeldescriptor.CDK_Descriptor;
import libpadeldescriptor.CDK_Fingerprint;
import libpadeldescriptor.CDK_FingerprintCount;
import libpadeldescriptor.PaDELStandardize;
import libpadeldescriptor.libPaDELDescriptorJob;
import libpadeldescriptor.libPaDELDescriptorMaster;
import libpadeldescriptor.libPaDELDescriptorMasterGeneral;
import libpadeldescriptor.libPaDELDescriptorType;
import libpadeljobs.Worker;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.modeling.builder3d.ModelBuilder3D;
import org.openscience.cdk.modeling.builder3d.TemplateHandler3D;

public class libPaDELDescriptorWorker
extends Worker<libPaDELDescriptorJob> {
    protected libPaDELDescriptorMaster master = null;
    protected libPaDELDescriptorMasterGeneral masterG = null;
    protected int channelID;
    protected Set<String> descriptorTypes;
    protected List<CDK_Descriptor> cdk_descriptors;
    protected List<CDK_Fingerprint> cdk_fingerprints;
    protected List<CDK_FingerprintCount> cdk_fingerprints_count;

    public libPaDELDescriptorWorker(libPaDELDescriptorMaster libPaDELDescriptorMaster2, int n, LinkedBlockingQueue<libPaDELDescriptorJob> linkedBlockingQueue, LinkedBlockingQueue<libPaDELDescriptorJob> linkedBlockingQueue2, LinkedBlockingQueue<libPaDELDescriptorJob> linkedBlockingQueue3, Set<String> set) {
        super(linkedBlockingQueue, linkedBlockingQueue2, linkedBlockingQueue3);
        this.master = libPaDELDescriptorMaster2;
        this.channelID = n;
        this.descriptorTypes = set;
    }

    public libPaDELDescriptorWorker(libPaDELDescriptorMasterGeneral libPaDELDescriptorMasterGeneral2, int n, LinkedBlockingQueue<libPaDELDescriptorJob> linkedBlockingQueue, LinkedBlockingQueue<libPaDELDescriptorJob> linkedBlockingQueue2, LinkedBlockingQueue<libPaDELDescriptorJob> linkedBlockingQueue3, Set<String> set) {
        super(linkedBlockingQueue, linkedBlockingQueue2, linkedBlockingQueue3);
        this.masterG = libPaDELDescriptorMasterGeneral2;
        this.channelID = n;
        this.descriptorTypes = set;
    }

    public void DoJob() {
        Object object;
        double d;
        Object object2;
        this.cdk_descriptors = new ArrayList<CDK_Descriptor>();
        this.cdk_fingerprints = new ArrayList<CDK_Fingerprint>();
        this.cdk_fingerprints_count = new ArrayList<CDK_FingerprintCount>();
        libPaDELDescriptorType.SetDescriptorTypes(this.descriptorTypes, null, this.cdk_descriptors, this.cdk_fingerprints, this.cdk_fingerprints_count);
        if (this.master != null) {
            object2 = "Processing " + ((libPaDELDescriptorJob)this.job).getName() + " in " + ((libPaDELDescriptorJob)this.job).getFilename() + " (" + ((libPaDELDescriptorJob)this.job).getId() + "/" + this.master.GetMaxMolecules() + "). ";
            if (this.master.getMolProcessed() > 0) {
                d = (double)(System.nanoTime() - this.master.getStartTime()) / 1.0E9 / (double)this.master.getMolProcessed();
                object2 = (String)object2 + "Average speed: " + new DecimalFormat("#0.00").format(d) + " s/mol.";
            }
            this.master.addMessage(this.channelID, (String)object2);
        }
        if (this.masterG != null) {
            object2 = "Processing " + ((libPaDELDescriptorJob)this.job).getName() + " (" + ((libPaDELDescriptorJob)this.job).getId() + "/" + this.masterG.GetMaxMolecules() + "). ";
            if (this.masterG.getMolProcessed() > 0) {
                d = (double)(System.nanoTime() - this.masterG.getStartTime()) / 1.0E9 / (double)this.masterG.getMolProcessed();
                object2 = (String)object2 + "Average speed: " + new DecimalFormat("#0.00").format(d) + " s/mol.";
            }
            this.masterG.addMessage(this.channelID, (String)object2);
        }
        object2 = ((libPaDELDescriptorJob)this.job).getStructure();
        PaDELStandardize paDELStandardize = new PaDELStandardize();
        paDELStandardize.setRemoveSalt(((libPaDELDescriptorJob)this.job).isRemoveSalt());
        paDELStandardize.setDearomatize(((libPaDELDescriptorJob)this.job).detectAromaticity);
        paDELStandardize.setStandardizeTautomers(((libPaDELDescriptorJob)this.job).isStandardizeTautomers());
        paDELStandardize.setTautomerList(((libPaDELDescriptorJob)this.job).getTautomerList());
        paDELStandardize.setStandardizeNitro(((libPaDELDescriptorJob)this.job).isStandardizeNitro());
        paDELStandardize.setRetain3D(((libPaDELDescriptorJob)this.job).isRetain3D());
        try {
            object2 = paDELStandardize.Standardize((IAtomContainer)object2);
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.FINE, null, exception);
        }
        if (((libPaDELDescriptorJob)this.job).isConvertTo3D()) {
            try {
                object = TemplateHandler3D.getInstance();
                Iterator<Thread> iterator = ModelBuilder3D.getInstance((TemplateHandler3D)object, ((libPaDELDescriptorJob)this.job).getForcefield());
                object2 = ((ModelBuilder3D)((Object)iterator)).generate3DCoordinates((IMolecule)object2, true);
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.FINE, null, exception);
            }
        }
        object = new ArrayList();
        if (((libPaDELDescriptorJob)this.job).getMaxRunTime() <= 0L) {
            for (CDK_Descriptor thread : this.cdk_descriptors) {
                try {
                    thread.setMolecule(object2.clone());
                    thread.run();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, null, exception);
                }
                ((ArrayList)object).addAll(Arrays.asList(thread.descriptorValues_));
            }
            for (CDK_Fingerprint cDK_Fingerprint : this.cdk_fingerprints) {
                try {
                    cDK_Fingerprint.setMolecule(object2.clone());
                    cDK_Fingerprint.run();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, null, exception);
                }
                ((ArrayList)object).addAll(Arrays.asList(cDK_Fingerprint.descriptorValues_));
            }
            for (CDK_FingerprintCount cDK_FingerprintCount : this.cdk_fingerprints_count) {
                try {
                    cDK_FingerprintCount.setMolecule(object2.clone());
                    cDK_FingerprintCount.run();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, null, exception);
                }
                ((ArrayList)object).addAll(Arrays.asList(cDK_FingerprintCount.descriptorValues_));
            }
        } else {
            long l = System.nanoTime();
            for (CDK_Descriptor cDK_Descriptor : this.cdk_descriptors) {
                try {
                    cDK_Descriptor.setMolecule(object2.clone());
                    cDK_Descriptor.start();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, null, exception);
                }
            }
            for (CDK_Fingerprint cDK_Fingerprint : this.cdk_fingerprints) {
                try {
                    cDK_Fingerprint.setMolecule(object2.clone());
                    cDK_Fingerprint.start();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, null, exception);
                }
            }
            for (CDK_FingerprintCount cDK_FingerprintCount : this.cdk_fingerprints_count) {
                try {
                    cDK_FingerprintCount.setMolecule(object2.clone());
                    cDK_FingerprintCount.start();
                }
                catch (Exception exception) {
                    Logger.getLogger("global").log(Level.FINE, null, exception);
                }
            }
            long l2 = ((libPaDELDescriptorJob)this.job).maxRunTime * 1000000L;
            boolean bl = true;
            while (System.nanoTime() - l < l2) {
                bl = true;
                for (CDK_Descriptor cDK_Descriptor : this.cdk_descriptors) {
                    if (!cDK_Descriptor.isAlive()) continue;
                    bl = false;
                    break;
                }
                for (CDK_Fingerprint cDK_Fingerprint : this.cdk_fingerprints) {
                    if (!cDK_Fingerprint.isAlive()) continue;
                    bl = false;
                    break;
                }
                for (CDK_FingerprintCount cDK_FingerprintCount : this.cdk_fingerprints_count) {
                    if (!cDK_FingerprintCount.isAlive()) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
            }
            if (!bl) {
                for (CDK_Descriptor cDK_Descriptor : this.cdk_descriptors) {
                    if (!cDK_Descriptor.isAlive()) continue;
                    cDK_Descriptor.interrupt();
                }
                for (CDK_Fingerprint cDK_Fingerprint : this.cdk_fingerprints) {
                    if (!cDK_Fingerprint.isAlive()) continue;
                    cDK_Fingerprint.interrupt();
                }
                for (CDK_FingerprintCount cDK_FingerprintCount : this.cdk_fingerprints_count) {
                    if (!cDK_FingerprintCount.isAlive()) continue;
                    cDK_FingerprintCount.interrupt();
                }
            }
            for (CDK_Descriptor cDK_Descriptor : this.cdk_descriptors) {
                ((ArrayList)object).addAll(Arrays.asList(cDK_Descriptor.descriptorValues_));
            }
            for (CDK_Fingerprint cDK_Fingerprint : this.cdk_fingerprints) {
                ((ArrayList)object).addAll(Arrays.asList(cDK_Fingerprint.descriptorValues_));
            }
            for (CDK_FingerprintCount cDK_FingerprintCount : this.cdk_fingerprints_count) {
                ((ArrayList)object).addAll(Arrays.asList(cDK_FingerprintCount.descriptorValues_));
            }
        }
        ((libPaDELDescriptorJob)this.job).setDescriptors((ArrayList<String>)object);
    }
}

