/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Element;
import nu.xom.Node;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractCellParameter;
import org.xmlcml.cml.element.CMLCrystal;
import org.xmlcml.cml.element.CMLScalar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMLCellParameter
extends AbstractCellParameter {
    public static final String NS = "cml:cellParameter";
    public static final String[] dictRef = new String[]{"cml:a", "cml:b", "cml:c", "cml:alpha", "cml:beta", "cml:gamma"};

    public CMLCellParameter() {
    }

    public CMLCellParameter(CMLCellParameter old) {
        super(old);
    }

    @Override
    public Node copy() {
        return new CMLCellParameter(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLCellParameter();
    }

    public CMLCellParameter(CMLScalar[] scalar, Type type) {
        this();
        if (scalar == null || scalar.length != 3) {
            throw new RuntimeException("bad args to constructor" + scalar);
        }
        double[] values = new double[3];
        String units = null;
        double[] error = new double[3];
        boolean hasError = false;
        for (int i = 0; i < 3; ++i) {
            values[i] = scalar[i].getDouble();
            if (units == null) {
                units = scalar[i].getUnits();
            }
            error[i] = Double.NaN;
            if (scalar[i].getErrorValueAttribute() == null) continue;
            error[i] = scalar[i].getErrorValue();
            hasError = true;
        }
        if (units != null) {
            this.setUnits(units);
        }
        if (hasError) {
            this.setError(error);
        }
        if (type == null) {
            throw new RuntimeException("Null type");
        }
        if (type.equals((Object)Type.LENGTH) || type.equals((Object)Type.ANGLE)) {
            this.setType(type.s);
            this.setXMLContent(values);
        }
    }

    public CMLCellParameter(List<CMLScalar> scalar, Type type) {
        this(scalar.toArray(new CMLScalar[0]), type);
    }

    public static CMLCellParameter getCellParameter(List<CMLCellParameter> cellParameters, Type type) {
        CMLCellParameter cellParameter = null;
        if (cellParameters != null && cellParameters.size() == 2) {
            CMLCellParameter length = null;
            CMLCellParameter angle = null;
            for (CMLCellParameter cellP : cellParameters) {
                if (Type.LENGTH.s.equals(cellP.getType())) {
                    length = cellP;
                    continue;
                }
                if (Type.ANGLE.s.equals(cellP.getType())) {
                    angle = cellP;
                    continue;
                }
                if (cellP.getType() == null) {
                    throw new RuntimeException("cellParameter requires type attribute");
                }
                throw new RuntimeException("unknown type on cellParameter: " + cellP.getType());
            }
            if (length != null && angle != null) {
                cellParameter = Type.LENGTH.equals((Object)type) ? length : angle;
            }
        }
        return cellParameter;
    }

    public static CMLCellParameter getCellParameter(CMLElements<CMLCellParameter> cellParameters, Type type) {
        ArrayList<CMLCellParameter> cellParams = new ArrayList<CMLCellParameter>();
        for (CMLCellParameter cellParam : cellParameters) {
            cellParams.add(cellParam);
        }
        return CMLCellParameter.getCellParameter(cellParams, type);
    }

    public static List<CMLScalar> createCMLScalars(List<CMLCellParameter> cellParameterElements) {
        ArrayList<CMLScalar> cellParams = new ArrayList<CMLScalar>();
        CMLCellParameter length = CMLCellParameter.getCellParameter(cellParameterElements, Type.LENGTH);
        CMLCellParameter angle = CMLCellParameter.getCellParameter(cellParameterElements, Type.ANGLE);
        if (length != null && angle != null) {
            int i;
            double[] error = length.getError();
            for (i = 0; i < 3; ++i) {
                cellParams.add(CMLCrystal.createScalar(dictRef[i], length.getXMLContent()[i], length.getUnits(), error == null ? Double.NaN : error[i]));
            }
            error = angle.getError();
            for (i = 3; i < 6; ++i) {
                cellParams.add(CMLCrystal.createScalar(dictRef[i], angle.getXMLContent()[i - 3], angle.getUnits(), error == null ? Double.NaN : error[i - 3]));
            }
        }
        return cellParams;
    }

    public static List<CMLScalar> createCMLScalars(CMLElements<CMLCellParameter> cellParameterElements) {
        ArrayList<CMLCellParameter> cellParams = new ArrayList<CMLCellParameter>();
        for (CMLCellParameter param : cellParameterElements) {
            cellParams.add(param);
        }
        return CMLCellParameter.createCMLScalars(cellParams);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        LENGTH("length"),
        ANGLE("angle");

        public final String s;

        private Type(String s) {
            this.s = s;
        }
    }
}

