/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

public class MolFileFilter
extends FileFilter {
    public static final String[] supported_extensions = new String[]{".sdf", ".csv", ".txt", ".mol", ".mol2", ".smi", ".cml", ".hin", ".ichi", ".inchi", ".pdb", ".xyz", ".xls", ".xls", ".echaxml", ".xml"};
    public static final String[] supported_exts_description = new String[]{"SDF files (*.sdf)", "Comma delimited (*.csv)", "Text files (*.txt)", "MOL files (*.mol)", "MOL2 files (*.mol2)", "SMILES files (*.smi)", "CML files (*.cml)", "HIN files (*.hin)", "ICHI files (*.ichi)", "INChI files (*.inchi)", "PDB files (*.pdb)", "XYZ files (*.xyz)", "Microsoft Office Excel file (*.xls)", "EURAS Excel file with BCF data (*.xls)", "ECHA preregistration list XML format (*.echaxml)", "ToxML (*.xml)"};
    public static final String[] toxTree_ext = new String[]{".tml", ".tree", ".fml"};
    public static final String[] toxTree_ext_descr = new String[]{"XML Decision tree files (*.tml)", "Binary decision tree files (*.tree)", "Set of decision trees files (*.fml)"};
    public static final String[] toxTree_ext_save = new String[]{".tml", ".tree", ".fml", ".csv", ".txt", ".html", ".pdf"};
    public static final String[] toxTree_ext_descr_save = new String[]{"XML Decision tree files (*.tml)", "Binary decision tree files (*.tree)", "Set of decision trees files (*.fml)", "Comma delimited files (*.csv)", "Text files (*.txt)", "HTML files (*.html)", "PDF files (*.pdf)"};
    public static final String[] toxForest_ext = new String[]{".fml", ".forest"};
    public static final String[] toxForest_ext_descr = new String[]{"Set of decision trees files (*.fml)", "Set of decision trees binary files (*.forest)"};
    protected String extension = ".sdf";
    protected String description = "SDF file";

    public MolFileFilter() {
    }

    public MolFileFilter(String string, String string2) {
        this.extension = string.toLowerCase();
        this.description = string2;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(this.extension);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static String getSuffix(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n).toLowerCase();
        }
        return string2;
    }

    public static String getSuffix(File file) {
        return MolFileFilter.getSuffix(file.getPath());
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }
}

