/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.io;

import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.base.processors.CASProcessor;
import ambit2.core.io.DelimitedFileFormat;
import ambit2.core.io.IteratingFilesWithHeaderReader;
import ambit2.core.io.QuotedTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.inchi.InChIGeneratorFactory;
import org.openscience.cdk.inchi.InChIToStructure;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.iterator.IIteratingChemObjectReader;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.io.setting.StringIOSetting;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public class IteratingDelimitedFileReader
extends IteratingFilesWithHeaderReader<String>
implements IIteratingChemObjectReader {
    public static String defaultSMILESHeader = "SMILES";
    public static String optionalSMILESHeader = "CANONICAL_SMILES";
    protected String commentChar = "#";
    private BufferedReader input;
    private boolean nextAvailableIsKnown;
    private boolean hasNext;
    private IAtomContainer nextMolecule;
    protected DelimitedFileFormat format;
    protected Object[] values;
    protected CASProcessor casTransformer = new CASProcessor();

    public String getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(String string) {
        this.commentChar = string;
    }

    public IteratingDelimitedFileReader(Reader reader) throws CDKException {
        this(reader, new DelimitedFileFormat());
    }

    public IteratingDelimitedFileReader(Reader reader, DelimitedFileFormat delimitedFileFormat) throws CDKException {
        this.format = delimitedFileFormat;
        this.setReader(reader);
    }

    public void setReader(InputStream inputStream) throws CDKException {
        this.setReader(new InputStreamReader(inputStream));
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(reader);
        this.nextMolecule = null;
        this.nextAvailableIsKnown = false;
        this.hasNext = false;
    }

    @Override
    protected LiteratureEntry getReference() {
        return LiteratureEntry.getInstance((String)((Object)((Object)this)).getClass().getName(), (String)((Object)((Object)this)).getClass().getName());
    }

    public IteratingDelimitedFileReader(InputStream inputStream) throws UnsupportedEncodingException, CDKException {
        this(new InputStreamReader(inputStream, "UTF-8"));
    }

    public IteratingDelimitedFileReader(InputStream inputStream, DelimitedFileFormat delimitedFileFormat) throws UnsupportedEncodingException, CDKException {
        this(new InputStreamReader(inputStream, "UTF-8"), delimitedFileFormat);
    }

    public IResourceFormat getFormat() {
        return this.format;
    }

    public boolean hasNext() {
        if (this.isHeaderEmpty()) {
            this.fireIOSettingQuestion((IOSetting)new StringIOSetting("", 1, Property.IO_QUESTION.IO_START.toString(), ""));
            this.processHeader(this.input);
            this.fireIOSettingQuestion((IOSetting)new StringIOSetting("", 1, Property.IO_QUESTION.IO_STOP.toString(), ""));
        }
        if (!this.nextAvailableIsKnown) {
            block17: {
                this.hasNext = false;
                try {
                    if (this.input.ready()) {
                        this.extractRowKeyAndData(this.input.readLine().trim());
                        this.nextMolecule = null;
                        if (this.inchiIndex >= 0) {
                            try {
                                if (this.inchiFactory == null) {
                                    this.inchiFactory = InChIGeneratorFactory.getInstance();
                                }
                                InChIToStructure inChIToStructure = this.inchiFactory.getInChIToStructure(this.values[this.inchiIndex].toString(), SilentChemObjectBuilder.getInstance());
                                this.nextMolecule = inChIToStructure.getAtomContainer();
                            }
                            catch (Exception exception) {
                                this.nextMolecule = null;
                            }
                        }
                        if (this.nextMolecule == null && this.smilesIndex >= 0) {
                            try {
                                this.nextMolecule = this.values[this.smilesIndex] == null ? (IAtomContainer)SilentChemObjectBuilder.getInstance().newInstance(IMolecule.class, new Object[0]) : this.sp.parseSmiles(this.values[this.smilesIndex].toString());
                            }
                            catch (InvalidSmilesException invalidSmilesException) {
                                logger.warn((Object)"Empty molecule!");
                                this.nextMolecule = (IAtomContainer)SilentChemObjectBuilder.getInstance().newInstance(IMolecule.class, new Object[0]);
                                this.nextMolecule.setProperty((Object)"SMILES", (Object)"Invalid SMILES");
                            }
                        }
                        if (this.nextMolecule == null) {
                            this.nextMolecule = (IAtomContainer)SilentChemObjectBuilder.getInstance().newInstance(IMolecule.class, new Object[0]);
                        }
                        for (int i = 0; i < this.values.length; ++i) {
                            if (this.values[i] != null) {
                                String string = this.casTransformer.process(this.values[i].toString());
                                if (CASProcessor.isValidFormat((String)string)) {
                                    this.values[i] = string;
                                }
                                this.nextMolecule.setProperty(this.getHeaderColumn(i), (Object)this.values[i].toString().trim());
                                continue;
                            }
                            this.nextMolecule.removeProperty(this.getHeaderColumn(i));
                        }
                        this.hasNext = true;
                        break block17;
                    }
                    this.hasNext = false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    logger.error((Object)("Error while reading next molecule: " + exception.getMessage()));
                    logger.error((Object)this.values);
                    logger.debug((Object)exception);
                    this.hasNext = true;
                }
            }
            if (!this.hasNext) {
                this.nextMolecule = null;
            }
            this.nextAvailableIsKnown = true;
        }
        return this.hasNext;
    }

    public Object next() {
        if (!this.nextAvailableIsKnown) {
            this.hasNext();
        }
        this.nextAvailableIsKnown = false;
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        return this.nextMolecule;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected void processComment(String string) {
    }

    protected void processHeader(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            while (string.startsWith(this.commentChar)) {
                this.processComment(string);
                string = bufferedReader.readLine();
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, new String(this.format.getFieldDelimiter()));
            while (stringTokenizer.hasMoreTokens()) {
                this.addHeaderColumn(stringTokenizer.nextToken().trim());
            }
            for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                String string2 = ((String)this.getHeaderColumn(i)).toUpperCase();
                if (string2.equals(defaultSMILESHeader)) {
                    this.smilesIndex = i;
                    break;
                }
                if (this.smilesIndex >= 0 || !string2.equals(optionalSMILESHeader)) continue;
                this.smilesIndex = i;
                break;
            }
            this.values = new Object[this.getNumberOfColumns()];
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    protected String removeStringDelimiters(String string) {
        char c = this.format.getTextDelimiter();
        String string2 = string.trim();
        if (string2.length() == 0) {
            return "";
        }
        if (string2.charAt(0) == c) {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == c) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public void extractRowKeyAndData(String string) {
        QuotedTokenizer quotedTokenizer = new QuotedTokenizer(string, this.format.getFieldDelimiter().charAt(0));
        for (int i = 0; quotedTokenizer.hasMoreTokens() && i < this.values.length; ++i) {
            String string2 = quotedTokenizer.nextToken();
            if (string2 != null) {
                this.values[i] = this.removeStringDelimiters(string2);
                if (!string2.startsWith("InChI=")) continue;
                this.inchiIndex = i;
                continue;
            }
            this.values[i] = "";
        }
    }

    public String toString() {
        return "Reading compounds from " + this.format.toString();
    }

    @Override
    protected ArrayList<String> createHeader() {
        return new ArrayList<String>();
    }

    @Override
    protected String createPropertyByColumnName(String string) {
        return string;
    }
}

