/*
 * Decompiled with CFR 0.152.
 */
package ambit2.core.external;

import ambit2.base.external.CommandShell;
import ambit2.base.external.ShellException;
import ambit2.core.data.MoleculeTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.silent.SilentChemObjectBuilder;

public abstract class ShellSDFoutput<INPUT>
extends CommandShell<INPUT, IMolecule> {
    private static final long serialVersionUID = 8770974107691241294L;
    protected boolean readOutput;

    protected void initialize() throws ShellException {
        super.initialize();
        this.setReadOutput(false);
    }

    protected synchronized IMolecule parseOutput(String string, INPUT INPUT) throws ShellException {
        try {
            if (this.isReadOutput()) {
                MDLV2000Reader mDLV2000Reader = new MDLV2000Reader((InputStream)new FileInputStream(string + File.separator + this.getOutputFile()));
                IMolecule iMolecule = MoleculeTools.newMolecule(SilentChemObjectBuilder.getInstance());
                mDLV2000Reader.read((IChemObject)iMolecule);
                mDLV2000Reader.close();
                return iMolecule;
            }
            return (IMolecule)this.transform(INPUT);
        }
        catch (Exception exception) {
            throw new ShellException((CommandShell)this, (Throwable)exception);
        }
    }

    public boolean isReadOutput() {
        return this.readOutput;
    }

    public void setReadOutput(boolean bl) {
        this.readOutput = bl;
    }
}

