/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.tree.BooleanArrayDifference;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;

@TestClass(value="org.openscience.cdk.tools.diff.ChemObjectDiffTest")
public class ChemObjectDiff {
    private ChemObjectDiff() {
    }

    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference difference = ChemObjectDiff.difference(first, second);
        if (difference == null) {
            return "";
        }
        return difference.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IChemObject) || !(second instanceof IChemObject)) {
            return null;
        }
        IChemObject firstElem = first;
        IChemObject secondElem = second;
        ChemObjectDifference coDiff = new ChemObjectDifference("ChemObjectDiff");
        boolean[] firstFlags = firstElem.getFlags();
        boolean[] secondFlags = secondElem.getFlags();
        coDiff.addChild(BooleanArrayDifference.construct("flag", firstFlags, secondFlags));
        if (coDiff.childCount() > 0) {
            return coDiff;
        }
        return null;
    }
}

