/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.graph.invariant.MorganNumbersToolsTest")
public class MorganNumbersTools {
    @TestMethod(value="testGetMorganNumbers_IAtomContainer")
    public static long[] getMorganNumbers(IAtomContainer atomContainer) {
        int N = atomContainer.getAtomCount();
        long[] morganMatrix = new long[N];
        long[] tempMorganMatrix = new long[N];
        List[] atoms = new List[N];
        HashMap[] atomIndices = new HashMap[N];
        for (int f = 0; f < N; ++f) {
            morganMatrix[f] = atomContainer.getConnectedBondsCount(f);
            tempMorganMatrix[f] = atomContainer.getConnectedBondsCount(f);
            atoms[f] = atomContainer.getConnectedAtomsList(atomContainer.getAtom(f));
            atomIndices[f] = new HashMap();
            for (IAtom atom : atoms[f]) {
                atomIndices[f].put(atom, atomContainer.getAtomNumber(atom));
            }
        }
        for (int e = 0; e < N; ++e) {
            for (int f = 0; f < N; ++f) {
                morganMatrix[f] = 0L;
                for (IAtom atom : atoms[f]) {
                    int n = f;
                    morganMatrix[n] = morganMatrix[n] + tempMorganMatrix[(Integer)atomIndices[f].get(atom)];
                }
            }
            System.arraycopy(morganMatrix, 0, tempMorganMatrix, 0, N);
        }
        return tempMorganMatrix;
    }

    @TestMethod(value="testPhenylamine")
    public static String[] getMorganNumbersWithElementSymbol(IAtomContainer atomContainer) {
        long[] morgannumbers = MorganNumbersTools.getMorganNumbers(atomContainer);
        String[] morgannumberswithelement = new String[morgannumbers.length];
        for (int i = 0; i < morgannumbers.length; ++i) {
            morgannumberswithelement[i] = atomContainer.getAtom(i).getSymbol() + "-" + morgannumbers[i];
        }
        return morgannumberswithelement;
    }
}

