/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.data;

import ambit2.base.data.AmbitBean;
import ambit2.base.data.ILiteratureEntry;

public class LiteratureEntry
extends AmbitBean
implements ILiteratureEntry {
    private static final long serialVersionUID = -3089173811051934066L;
    public static final String p_title = "title";
    public static final String p_url = "URL";
    protected String title;
    protected String URL;
    protected int id = -1;
    protected boolean editable;
    protected ILiteratureEntry._type type = ILiteratureEntry._type.BibtexEntry;
    protected static String EINECS_name = "EINECS";
    protected static String IUPAC_name = "IUPAC name";
    protected static String CAS_num = "CAS Registry Number";
    protected static String Default_name = "Default";
    protected static String AMBIT_uri = "http://ambit.sourceforge.net";
    protected static String EINECS_uri = "http://ec.europa.eu/environment/chemicals/exist_subst/einecs.htm";

    @Override
    public void setURL(String string) {
        this.URL = string;
    }

    @Override
    public ILiteratureEntry._type getType() {
        return this.type;
    }

    @Override
    public void setType(ILiteratureEntry._type _type2) {
        this.type = _type2;
    }

    public static synchronized LiteratureEntry getInstance() {
        return LiteratureEntry.getInstance(Default_name, AMBIT_uri);
    }

    public static synchronized LiteratureEntry getInstance(String string) {
        return LiteratureEntry.getInstance(string, AMBIT_uri);
    }

    public static synchronized LiteratureEntry getCASReference() {
        return LiteratureEntry.getInstance(CAS_num, AMBIT_uri);
    }

    public static synchronized LiteratureEntry getIUPACReference() {
        return LiteratureEntry.getInstance(IUPAC_name, AMBIT_uri);
    }

    public static synchronized LiteratureEntry getEINECSReference() {
        return LiteratureEntry.getInstance(EINECS_name, EINECS_uri);
    }

    public static synchronized LiteratureEntry getInstance(String string, String string2) {
        return LiteratureEntry.getInstance(string, string2, -1);
    }

    public static synchronized LiteratureEntry getInstance(String string, String string2, int n) {
        LiteratureEntry literatureEntry = new LiteratureEntry(string, string2);
        literatureEntry.setId(n);
        return literatureEntry;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getURL() {
        return this.URL;
    }

    public LiteratureEntry(String string, String string2) {
        this.title = string.length() > 255 ? string.substring(1, 255) : string;
        this.URL = string2.length() > 255 ? string2.substring(1, 255) : string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getTitle());
        stringBuffer.append(this.getURL());
        return stringBuffer.toString();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.getTitle();
    }

    @Override
    public boolean hasID() {
        return this.id > 0;
    }

    @Override
    public void setId(int n) {
        this.id = n;
    }

    public boolean equals(Object object) {
        if (object instanceof LiteratureEntry) {
            return ((LiteratureEntry)object).getTitle().equals(this.getTitle());
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        int n2 = null == this.getName() ? 0 : this.getTitle().hashCode();
        n = 31 * n + n2;
        return n;
    }
}

