/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.geometry.cip.rules;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.geometry.cip.ILigand;
import org.openscience.cdk.geometry.cip.rules.AtomicNumberRule;
import org.openscience.cdk.geometry.cip.rules.ISequenceSubRule;
import org.openscience.cdk.geometry.cip.rules.MassNumberRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.geometry.cip.rules.CombinedAtomicMassNumberRuleTest")
class CombinedAtomicMassNumberRule
implements ISequenceSubRule<ILigand> {
    MassNumberRule massNumberRule = new MassNumberRule();
    AtomicNumberRule atomicNumberRule = new AtomicNumberRule();

    CombinedAtomicMassNumberRule() {
    }

    @Override
    @TestMethod(value="testCompare,testCompare_Identity,testOrder")
    public int compare(ILigand ligand1, ILigand ligand2) {
        int atomicNumberComp = this.atomicNumberRule.compare(ligand1, ligand2);
        if (atomicNumberComp != 0) {
            return atomicNumberComp;
        }
        int massNumberComp = this.massNumberRule.compare(ligand1, ligand2);
        if (massNumberComp != 0) {
            return massNumberComp;
        }
        if ("H".equals(ligand1.getLigandAtom().getSymbol())) {
            return 0;
        }
        return massNumberComp;
    }
}

